/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.utils;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.helper.Selection;
import com.neptunelabs.imagereader.image.FSIImage;

public abstract class EffectUtils {
    protected final FSILogger logger;
    protected final ExecutorPool executorPool;
    public final int priority;
    public byte[] alphaSelection = null;

    public EffectUtils(FSILogger logger, ExecutorPool executorPool, int priority) {
        this.logger = logger;
        this.executorPool = executorPool;
        this.priority = priority;
    }

    public void setSelection(Selection selection) {
        if (selection != null) {
            this.alphaSelection = selection.getAlphaSelection();
        }
    }

    public static int[][] calcThreadImageRanges(int refDim, int threads) {
        int th = refDim < threads ? refDim : threads;
        int[][] ranges = new int[th][];
        int s = 0;
        float thb = (float)refDim / (float)th;
        for (int c = 0; c < th; ++c) {
            int from = s;
            int to = c + 1 < th ? (int)Math.floor(thb * (float)(c + 1)) - 1 : refDim - 1;
            ranges[c] = new int[]{from, to};
            s = to + 1;
        }
        return ranges;
    }

    public int calcThreads(FSIImage image) {
        int logicalThreads = image.getHeight() / 64 + 1;
        if (logicalThreads > 1) {
            int maxAvail = this.executorPool.getAvailableThreads(ExecutorPool.Type.RENDERER_CPU);
            return logicalThreads > maxAvail ? maxAvail : logicalThreads;
        }
        return 1;
    }

    public static void disposeImages(FSIImage ... images) {
        for (FSIImage image : images) {
            if (image == null) continue;
            image.dispose();
        }
    }
}

