/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.utils;

import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;

public abstract class ImageAWTUtils {
    final FSILogger logger;
    final SwapPool swapPool;

    public ImageAWTUtils(FSILogger logger, SwapPool swapPool) {
        this.logger = logger;
        this.swapPool = swapPool;
    }

    public Color argb2Color(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new Color(r, g, b, a);
    }

    public FSIImage bufferedImage2FSIImage(BufferedImage bi) {
        FSIImageLimited image = new FSIImageLimited(this.logger, this.swapPool, ByteOrder.LITTLE_ENDIAN, bi.getWidth(), bi.getHeight(), null, FSIImageMode.ARGB);
        WritableRaster ri = bi.getRaster();
        DataBuffer db = ri.getDataBuffer();
        int dblen = db.getSize();
        for (int i = 0; i < dblen; ++i) {
            ((FSIImage)image).setSample(db.getElem(0, i));
        }
        return image;
    }
}

