/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.MagicFormatScanner;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Map;

public final class ImageFormatScanner {
    private static ImageFormatScanner instance = null;
    private static Map<String, String> mimeMapping;
    private static boolean magicScan;

    private ImageFormatScanner(Map<String, String> mimeMappingValue, boolean magicScanValue) {
        mimeMapping = mimeMappingValue;
        magicScan = magicScanValue;
    }

    public static ImageFormatScanner getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ImageFormatScanner not initialized");
        }
        return instance;
    }

    public static ImageFormatScanner getInstance(Map<String, String> mimeMappingValue, boolean magicScanValue) {
        if (instance == null) {
            instance = new ImageFormatScanner(mimeMappingValue, magicScanValue);
        }
        return instance;
    }

    public boolean hasSuffixMimeMapping(String filename) {
        boolean result = false;
        String suffix = null;
        for (Map.Entry<String, String> entry : mimeMapping.entrySet()) {
            suffix = entry.getKey();
            if (!filename.endsWith(suffix)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasMimeMapping(String mime) {
        boolean result = false;
        for (Map.Entry<String, String> entry : mimeMapping.entrySet()) {
            System.err.println(entry.getValue());
        }
        for (Map.Entry<String, String> entry : mimeMapping.entrySet()) {
            if (!mime.equalsIgnoreCase(entry.getValue())) continue;
            result = true;
            break;
        }
        return result;
    }

    public ImageFormat scanFile(PathCached fp) {
        ImageFormat result = new ImageFormat();
        if (magicScan) {
            try {
                result.type = MagicFormatScanner.evaluate(fp.getPath());
                result.isImage = true;
            }
            catch (IOException | BufferUnderflowException e) {
                result.type = ImageFormat.Type.UNK;
                result.isImage = false;
            }
            String[] sf = FileOperations.splitFilename(fp.getFileName());
            if (sf != null) {
                result.prefix = sf[0];
                result.suffix = sf[1];
            }
        } else {
            String mimeType = null;
            String prefix = null;
            String suffix = null;
            String filename = fp.getFileName();
            String[] fs = FileOperations.splitFilename(filename);
            if (fs != null && fs.length == 2) {
                String fSuf = fs[1].toLowerCase();
                for (Map.Entry<String, String> entry : mimeMapping.entrySet()) {
                    suffix = entry.getKey();
                    if (!suffix.equals(fSuf)) continue;
                    mimeType = entry.getValue();
                    prefix = fs[0];
                    break;
                }
            }
            result.type = ImageFormat.Type.UNK;
            result.isImage = false;
            if (mimeType != null) {
                result.prefix = prefix;
                result.suffix = suffix;
                if (mimeType.equals("image/tiff")) {
                    result.type = ImageFormat.Type.TIF;
                    result.isImage = true;
                } else if (mimeType.equals("image/jpeg")) {
                    result.type = ImageFormat.Type.JPG;
                    result.isImage = true;
                } else if (mimeType.equals("image/vnd.fpx")) {
                    result.type = ImageFormat.Type.FPX;
                    result.isImage = true;
                } else if (mimeType.equals("image/bmp")) {
                    result.type = ImageFormat.Type.BMP;
                    result.isImage = true;
                } else if (mimeType.equals("image/png")) {
                    result.type = ImageFormat.Type.PNG;
                    result.isImage = true;
                } else if (mimeType.equals("image/gif")) {
                    result.type = ImageFormat.Type.GIF;
                    result.isImage = true;
                } else if (mimeType.equals("image/vnd.eis")) {
                    result.type = ImageFormat.Type.EIS;
                    result.isImage = true;
                }
            }
        }
        return result;
    }
}

