/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.reader.ConverterImageReaderAbstract;
import com.neptunelabs.imagereader.reader.ConverterImageReaderBMP;
import com.neptunelabs.imagereader.reader.ConverterImageReaderFPX;
import com.neptunelabs.imagereader.reader.ConverterImageReaderGIF;
import com.neptunelabs.imagereader.reader.ConverterImageReaderJPEG_TM;
import com.neptunelabs.imagereader.reader.ConverterImageReaderPNG;
import com.neptunelabs.imagereader.reader.ConverterImageReaderTIFF;
import java.nio.ByteOrder;

public final class ImageReader {
    private final FSILogger logger;
    private final ExecutorPool executorPool;
    private final SwapPool swapPool;
    private final boolean forceSwap;
    private boolean prefetch;
    private long maxPrefetchSize;
    private final ByteOrder byteOrder;
    private final BufferedImageConverter converter;
    private final PluginLoader pluginLoader;
    private final FSIMetaData metaData;
    private final String presettype;
    private final boolean makeHistogram;
    private ConverterImageReaderAbstract cir = null;
    private ICCProfileWrap defaultCMYKICC = null;
    private ICCProfileWrap defaultRGBICC = null;
    private ICCProfileWrap defaultGrayICC = null;
    private boolean fallbackICCConversion = true;
    private IOController ioController = null;
    private volatile boolean error = false;

    public ImageReader(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, BufferedImageConverter converter, PluginLoader pluginLoader, FSIMetaData metaData, boolean swap, ByteOrder byteOrder, String presettype, boolean prefetch, boolean makeHistogram) {
        this.logger = logger;
        this.executorPool = executorPool;
        this.swapPool = swapPool;
        this.converter = converter;
        this.pluginLoader = pluginLoader;
        this.forceSwap = swap;
        this.byteOrder = byteOrder;
        this.metaData = metaData;
        this.prefetch = prefetch;
        this.presettype = presettype != null ? presettype.toLowerCase() : null;
        this.makeHistogram = makeHistogram;
    }

    public void setDefaultICCProfiles(ICCProfileWrap cmyk, ICCProfileWrap rgb, ICCProfileWrap gray) {
        this.defaultCMYKICC = cmyk;
        this.defaultRGBICC = rgb;
        this.defaultGrayICC = gray;
    }

    public void setUseFallbackICCConversion(boolean state) {
        this.fallbackICCConversion = state;
    }

    public void setPrefetch(boolean state, long size) {
        this.prefetch = state;
        this.maxPrefetchSize = size;
    }

    public void setIOController(IOController ioController) {
        this.ioController = ioController;
    }

    public int getReaderVersion() {
        if (this.cir != null) {
            return this.cir.getVersion();
        }
        return 0;
    }

    public FSIImage getImage() throws FSIImageException {
        String errStr;
        if (this.cir != null) {
            if (!this.cir.isDisposed() && this.cir.getImage() != null) {
                this.cir.getImage().setPosition(0L);
                return this.cir.getImage();
            }
            errStr = "Image already disposed: " + this.metaData.source;
        } else {
            errStr = "Image is null";
        }
        throw new FSIImageException(errStr);
    }

    public void setImage(FSIImage image) {
        this.cir.setImage(image);
    }

    public boolean hasImage() {
        if (this.cir == null) {
            return false;
        }
        return this.cir.getImage() != null;
    }

    private void init() {
        switch (this.metaData.sourceFormat.type) {
            case TIF: {
                this.cir = new ConverterImageReaderTIFF(this.logger, this.executorPool, this.swapPool, this.converter, this.pluginLoader, this.byteOrder, this.forceSwap);
                break;
            }
            case BMP: {
                this.cir = new ConverterImageReaderBMP(this.logger, this.executorPool, this.swapPool, this.converter, this.pluginLoader, this.byteOrder, this.forceSwap);
                break;
            }
            case PNG: {
                this.cir = new ConverterImageReaderPNG(this.logger, this.executorPool, this.swapPool, this.converter, this.pluginLoader, this.byteOrder, this.forceSwap);
                break;
            }
            case JPG: {
                this.cir = new ConverterImageReaderJPEG_TM(this.logger, this.executorPool, this.swapPool, this.converter, this.pluginLoader, this.byteOrder, this.forceSwap);
                break;
            }
            case GIF: {
                this.cir = new ConverterImageReaderGIF(this.logger, this.executorPool, this.swapPool, this.converter, this.pluginLoader, this.byteOrder, this.forceSwap);
                break;
            }
            case FPX: {
                if (!this.pluginLoader.isPluginLoaded("JAI") && !this.logger.hasNeLaDebug()) break;
                this.cir = new ConverterImageReaderFPX(this.logger, this.executorPool, this.swapPool, this.converter, this.pluginLoader, this.byteOrder, this.forceSwap);
                break;
            }
            default: {
                this.cir = null;
            }
        }
        if (this.cir != null) {
            try {
                this.cir.setPrefetch(this.prefetch, this.maxPrefetchSize);
                this.cir.setMakeHistogram(this.makeHistogram);
                this.cir.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
                this.cir.setUseFallbackICCConversion(this.fallbackICCConversion);
                this.cir.setIOController(this.ioController);
                this.cir.setFile(this.metaData);
            }
            catch (Exception e) {
                this.logger.logException(e, 3801, e.getLocalizedMessage() + " " + this.metaData.source);
                this.error = true;
            }
        }
    }

    public boolean isMapped() {
        if (this.cir != null) {
            return this.cir.isMapped();
        }
        return false;
    }

    public boolean readImage(int priority) {
        boolean returnvalue = false;
        this.init();
        if (this.cir != null) {
            try {
                System.err.println("cir:" + this.cir);
                returnvalue = this.cir.readImage(priority);
                this.error |= !returnvalue;
            }
            catch (Exception e) {
                this.cir.setError(true);
                this.logger.logException(e, 3821, this.metaData.source, e.getLocalizedMessage());
                this.error = true;
            }
            catch (Error er) {
                this.cir.setError(true);
                this.logger.logError(er, 3820, this.metaData.source);
                this.error = true;
            }
        }
        return returnvalue;
    }

    public void shutdown() {
        if (this.cir != null) {
            this.cir.shutdown();
        }
    }

    public boolean isDown() {
        if (this.cir != null) {
            return this.cir.isDown();
        }
        return true;
    }

    public void destroy() {
        if (this.cir != null) {
            this.cir.destroy();
        }
    }

    public boolean isDisposed() {
        if (this.cir == null) {
            return false;
        }
        return this.cir.isDisposed();
    }

    public boolean hasError() {
        if (this.cir == null) {
            return false;
        }
        boolean imageError = false;
        if (this.cir.getImage() != null) {
            imageError = this.cir.getImage().hasError();
        }
        return this.error | this.cir.hasError() | imageError;
    }

    public void setError(boolean state) {
        if (this.cir != null) {
            this.cir.setError(state);
        }
    }

    private boolean match(String s, String ... suffixes) {
        for (String suffix : suffixes) {
            int abc = s.length() - suffix.length();
            if (s.length() < suffix.length() || !s.substring(abc, s.length()).equalsIgnoreCase(suffix)) continue;
            return true;
        }
        return false;
    }
}

