/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader;

import com.neptunelabs.imagereader.ImageFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class MagicFormatScanner {
    private static final byte[] magicPNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] magicFPX = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};

    protected MagicFormatScanner() {
    }

    public static ImageFormat.Type evaluate(Path path) throws IOException {
        ImageFormat.Type result = ImageFormat.Type.UNK;
        try (SeekableByteChannel sbc = Files.newByteChannel(path, StandardOpenOption.READ);){
            ByteBuffer dst = ByteBuffer.allocate(8);
            sbc.read(dst);
            dst.flip();
            if (result == ImageFormat.Type.UNK && MagicFormatScanner.checkJPG(dst)) {
                result = ImageFormat.Type.JPG;
            }
            if (result == ImageFormat.Type.UNK && MagicFormatScanner.checkTIF(dst)) {
                result = ImageFormat.Type.TIF;
            }
            if (result == ImageFormat.Type.UNK && MagicFormatScanner.checkBMP(dst)) {
                result = ImageFormat.Type.BMP;
            }
            if (result == ImageFormat.Type.UNK && MagicFormatScanner.checkPNG(dst)) {
                result = ImageFormat.Type.PNG;
            }
            if (result == ImageFormat.Type.UNK && MagicFormatScanner.checkGIF(dst)) {
                result = ImageFormat.Type.GIF;
            }
            if (result == ImageFormat.Type.UNK && MagicFormatScanner.checkFPX(dst)) {
                result = ImageFormat.Type.FPX;
            }
        }
        return result;
    }

    private static boolean checkBMP(ByteBuffer dst) {
        boolean result = false;
        dst.position(0);
        if (dst.get() == 66 && dst.get() == 77) {
            result = true;
        }
        return result;
    }

    private static boolean checkPNG(ByteBuffer dst) {
        boolean result = false;
        dst.position(0);
        byte[] m = new byte[8];
        dst.get(m);
        if (Arrays.equals(m, magicPNG)) {
            result = true;
        }
        return result;
    }

    private static boolean checkGIF(ByteBuffer dst) {
        boolean result = false;
        dst.position(0);
        if (dst.get() == 71 && dst.get() == 73 && dst.get() == 70) {
            result = true;
        }
        return result;
    }

    private static boolean checkJPG(ByteBuffer dst) {
        boolean result = false;
        dst.position(0);
        if (dst.get() == -1 && dst.get() == -40) {
            result = true;
        }
        return result;
    }

    private static boolean checkFPX(ByteBuffer dst) {
        boolean result = false;
        dst.position(0);
        byte[] m = new byte[8];
        dst.get(m);
        if (Arrays.equals(m, magicFPX)) {
            result = true;
        }
        return result;
    }

    private static boolean checkTIF(ByteBuffer dst) {
        boolean result = false;
        dst.position(0);
        if (dst.get() == 73 && dst.get() == 73 && dst.get() == 42 && dst.get() == 0) {
            result = true;
        } else {
            dst.position(0);
            if (dst.get() == 77 && dst.get() == 77 && dst.get() == 0 && dst.get() == 42) {
                result = true;
            }
        }
        return result;
    }
}

