/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader;

public final class Manipulator {
    public static byte[] crop(byte[] data, int width, int height, int samples, int left, int top, int new_width, int new_height) {
        byte[] returnvalue = null;
        if (new_height > 0 && new_width > 0 && new_width <= width && new_height <= height) {
            returnvalue = new byte[new_width * new_height * samples];
            if (new_height > 0 && new_width > 0 && top <= new_height && left <= new_width) {
                int y = top;
                int y2 = 0;
                while (y < new_height + top) {
                    int srcpos = y * width * samples + left * samples;
                    int destpos = y2 * new_width * samples;
                    System.arraycopy(data, srcpos, returnvalue, destpos, new_width * samples);
                    ++y;
                    ++y2;
                }
            }
        }
        return returnvalue;
    }

    public static byte[] flipHorizontal(byte[] data, int width, int height, int samples) {
        byte[] rowbuffer = new byte[width * samples];
        for (int y = 0; y < height; ++y) {
            int curpos = y * width * samples;
            System.arraycopy(data, curpos, rowbuffer, 0, width * samples);
            for (int x = 0; x < width * samples; x += samples) {
                for (int p = 0; p < samples; ++p) {
                    data[curpos + x + p] = rowbuffer[width * samples - x - (samples - p - 1) - 1];
                }
            }
        }
        return data;
    }

    public static byte[] flipVertical(byte[] data, int width, int height, int samples) {
        byte[] rowbuffer = new byte[width * samples];
        int hheight = (int)Math.floor(height / 2);
        int widsam = width * samples;
        for (int y = 0; y < hheight; ++y) {
            int curpos = y * widsam;
            int belowpos = (height - y - 1) * widsam;
            System.arraycopy(data, curpos, rowbuffer, 0, widsam);
            System.arraycopy(data, belowpos, data, curpos, widsam);
            System.arraycopy(rowbuffer, 0, data, belowpos, widsam);
        }
        return data;
    }

    public static byte[] rotate(byte[] data, int width, int height, int samples, int rotation) {
        if (rotation % 270 == 0) {
            data = Manipulator.introtate(data, width, height, samples, true);
        } else if (rotation % 180 == 0) {
            data = Manipulator.flipHorizontal(data, width, height, samples);
            data = Manipulator.flipVertical(data, width, height, samples);
        } else if (rotation % 90 == 0) {
            data = Manipulator.introtate(data, width, height, samples, false);
            data = Manipulator.flipHorizontal(data, height, width, samples);
        }
        return data;
    }

    private static byte[] introtate(byte[] data, int width, int height, int samples, boolean dir) {
        byte[] buf = new byte[width * height * samples];
        int data1x = 0;
        int data1y = 0;
        int data2x = 0;
        int data2y = 0;
        if (dir) {
            data2y = width - 1;
        }
        for (int p = 0; p < data.length; p += samples) {
            int pos1 = data1y * width * samples + data1x * samples;
            int pos2 = data2y * height * samples + data2x * samples;
            for (int s = 0; s < samples; ++s) {
                buf[pos2 + s] = data[pos1 + s];
            }
            if (++data1x == width) {
                data1x = 0;
                ++data1y;
            }
            if (dir) {
                if (--data2y != -1) continue;
                data2y = width - 1;
                ++data2x;
                continue;
            }
            if (++data2y != width) continue;
            data2y = 0;
            ++data2x;
        }
        data = buf;
        return data;
    }
}

