/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader;

import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import com.neptunelabs.imagereader.metareader.MetaReaderBMP;
import com.neptunelabs.imagereader.metareader.MetaReaderFPX;
import com.neptunelabs.imagereader.metareader.MetaReaderGIF;
import com.neptunelabs.imagereader.metareader.MetaReaderJPEG;
import com.neptunelabs.imagereader.metareader.MetaReaderPNG;
import com.neptunelabs.imagereader.metareader.MetaReaderTIFF;
import java.io.IOException;
import java.nio.file.NoSuchFileException;

public final class MetaScanner {
    private final FSILogger logger;
    private final IOController ioController;
    private boolean error;
    private int errorCode = 0;

    public MetaScanner(FSILogger logger, IOController ioController) {
        this.logger = logger;
        this.ioController = ioController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIMetaData scanImage(PathCached inputFile, boolean deep) throws NoSuchFileException, IOException {
        ImageFormatScanner ifs = ImageFormatScanner.getInstance();
        ImageFormat format = ifs.scanFile(inputFile);
        MetaReaderAbstract ita = null;
        if (format.isImage) {
            if (format.type == ImageFormat.Type.TIF) {
                ita = new MetaReaderTIFF(this.logger, format);
            } else if (format.type == ImageFormat.Type.JPG) {
                ita = new MetaReaderJPEG(this.logger, format);
            } else if (format.type == ImageFormat.Type.PNG) {
                ita = new MetaReaderPNG(this.logger, format);
            } else if (format.type == ImageFormat.Type.GIF) {
                ita = new MetaReaderGIF(this.logger, format);
            } else if (format.type == ImageFormat.Type.BMP) {
                ita = new MetaReaderBMP(this.logger, format);
            } else if (format.type == ImageFormat.Type.FPX) {
                ita = new MetaReaderFPX(this.logger, format);
            } else {
                this.error = true;
            }
        } else {
            this.error = true;
        }
        if (this.error) {
            this.logger.log(3810, "MetaScanner: " + inputFile);
        }
        FSIMetaData metaData = new FSIMetaData(inputFile);
        metaData.sourceFormat = format;
        if (ita != null) {
            this.ioController.waitForRead();
            try {
                ita.scanImage(inputFile, deep);
            }
            finally {
                this.ioController.unlockRead();
            }
            if (ita.hasError()) {
                this.error = true;
                this.errorCode = ita.getErrorCode();
            } else {
                metaData = ita.getMetaData();
            }
        }
        if (metaData == null) {
            metaData = new FSIMetaData(inputFile);
        }
        if (deep) {
            metaData.lastModified = inputFile.lastModified();
            metaData.filesize = inputFile.size();
        }
        return metaData;
    }

    public boolean hasError() {
        return this.error;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

