/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.colorspace.NeLaGrayScale;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class BufferedImageConverterCCO
extends BufferedImageConverter {
    private final ColorSpace colorSpaceSRGB = ColorSpace.getInstance(1000);

    public BufferedImageConverterCCO(FSILogger logger) {
        super(logger);
    }

    @Override
    public final boolean convert(int priority, int maxThreads, ExecutorPool.Type executorType, BufferedImageWrap biw, FSIImage targetFSIImage, int targetOffsetX, int targetOffsetY) throws FSIImageException {
        boolean success = false;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        if (biw.icc != null) {
            ICC_ColorSpace srcColorSpace = new ICC_ColorSpace(biw.icc.getProfile());
        } else {
            ColorSpace srcColorSpace = biw.colorSpace;
        }
        System.err.println("BI:" + biw.dbType + " " + biw);
        int width = biw.bi.getWidth();
        int height = biw.bi.getHeight();
        long startTime = System.currentTimeMillis();
        if (biw.type == 2 && biw.colorSpace.isCS_sRGB()) {
            DataBuffer db = biw.bi.getRaster().getDataBuffer();
            int[] pixels = ((DataBufferInt)db).getData(0);
            this.setRGBPixels(pixels, width, targetFSIImage, targetOffsetX, targetOffsetY, biw.hasAlpha(), biw.histogram);
        } else if (biw.bands > 1 && biw.type != 2 && biw.colorSpace.isCS_sRGB()) {
            int[] pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(biw.bi, 0, 0, width, height, pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setRGBPixels(pixels, width, targetFSIImage, targetOffsetX, targetOffsetY, biw.hasAlpha(), biw.histogram);
        } else if (biw.bands > 1 && !biw.colorSpace.isCS_sRGB()) {
            ColorConvertOp cco = new ColorConvertOp(biw.colorSpace, this.colorSpaceSRGB, hints);
            BufferedImage destImage = cco.createCompatibleDestImage(biw.bi, ColorModel.getRGBdefault());
            cco.filter(biw.bi, destImage);
            int[] pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(destImage, 0, 0, width, height, pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setRGBPixels(pixels, width, targetFSIImage, targetOffsetX, targetOffsetY, biw.hasAlpha(), biw.histogram);
        } else if (biw.bands == 1) {
            NeLaGrayScale nelaGray = new NeLaGrayScale(null, null, 1.0f);
            BufferedImage dstImage = null;
            ColorConvertOp op = new ColorConvertOp(nelaGray, null);
            dstImage = op.filter(biw.bi, null);
            WritableRaster wr = dstImage.getRaster();
            DataBuffer db0 = wr.getDataBuffer();
            System.err.println(db0);
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] pixels = db.getData();
            System.err.println("DB:" + db);
            this.setGrayPixels(pixels, width, targetFSIImage, targetOffsetX, targetOffsetY, biw.hasAlpha(), biw.histogram);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        System.err.println("CCO Time:" + totalTime);
        try {
            ImageIO.write((RenderedImage)biw.bi, "png", new File("/tmp/output_in.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        success = true;
        return success;
    }

    private void setRGBPixels(int[] pixels, int width, FSIImage image, int targetOffsetX, int targetOffsetY, boolean useAlpha, Histogram histogram) {
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int[] nArray = pixels;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int pixel;
            int trgb = pixel = nArray[i];
            System.err.println("X:" + tx + " V:" + (trgb & 0xFF));
            image.setSample(tx, ty, trgb);
            if (histogram != null) {
                if (useAlpha) {
                    histogram.pushARGB(trgb);
                } else {
                    histogram.pushRGB(trgb);
                }
            }
            if (++tx != width) continue;
            tx = targetOffsetX;
            ++ty;
            System.exit(0);
        }
    }

    private void setGrayPixels(byte[] pixels, int width, FSIImage image, int targetOffsetX, int targetOffsetY, boolean useAlpha, Histogram histogram) {
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        for (int p = 0; p < pixels.length; ++p) {
            byte trgb = pixels[p];
            int rgb = 0xFF000000 | (trgb & 0xFF) << 16 | (trgb & 0xFF) << 8 | trgb & 0xFF;
            System.err.println(tx + ":" + trgb);
            image.setSample(tx, ty, rgb);
            if (histogram != null) {
                if (useAlpha) {
                    histogram.pushARGB(trgb);
                } else {
                    histogram.pushRGB(trgb);
                }
            }
            if (++tx != width) continue;
            tx = targetOffsetX;
            ++ty;
        }
    }

    private void removePremultiplication(BufferedImageWrap biw) {
        block20: {
            int dblen;
            DataBuffer db;
            block23: {
                int cc;
                int tc;
                block25: {
                    block24: {
                        block22: {
                            block18: {
                                int dblen2;
                                DataBuffer db2;
                                int alphaBand;
                                int colorEnd;
                                block21: {
                                    block19: {
                                        tc = biw.totalComponents;
                                        cc = biw.colorComponents;
                                        colorEnd = biw.extraAlphaStart;
                                        alphaBand = biw.getAlphaBand();
                                        if (alphaBand == -1) break block18;
                                        WritableRaster wr = biw.bi.getRaster();
                                        db2 = wr.getDataBuffer();
                                        dblen2 = db2.getSize();
                                        if (db2.getDataType() != 0) break block19;
                                        for (int i = 0; i < dblen2; i += tc) {
                                            int a = db2.getElem(0, i + alphaBand);
                                            if (a == 0 || a == 255) continue;
                                            float alphaf = (float)a / 255.0f;
                                            for (int c = 0; c < colorEnd; ++c) {
                                                int colorval = db2.getElem(0, i + c);
                                                db2.setElem(0, i + c, (int)((float)colorval / alphaf));
                                            }
                                        }
                                        break block20;
                                    }
                                    if (db2.getDataType() != 1) break block21;
                                    for (int i = 0; i < dblen2; i += tc) {
                                        int a = db2.getElem(0, i + alphaBand);
                                        if (a == 0 || a == 65535) continue;
                                        float alphaf = (float)a / 65535.0f;
                                        for (int c = 0; c < colorEnd; ++c) {
                                            int colorval = db2.getElem(0, i + c);
                                            db2.setElem(0, i + c, (int)((float)colorval / alphaf));
                                        }
                                    }
                                    break block20;
                                }
                                if (db2.getDataType() != 4) break block20;
                                for (int i = 0; i < dblen2; i += tc) {
                                    float a = db2.getElemFloat(0, i + alphaBand);
                                    if (a == 0.0f || a == 255.0f) continue;
                                    for (int c = 0; c < colorEnd; ++c) {
                                        float colorval = db2.getElemFloat(0, i + c);
                                        db2.setElemFloat(0, i + c, colorval / a);
                                    }
                                }
                                break block20;
                            }
                            if (tc == cc) break block20;
                            WritableRaster wr = biw.bi.getRaster();
                            db = wr.getDataBuffer();
                            dblen = db.getSize();
                            if (biw.type != 1 && biw.type != 4 && biw.type != 2 && biw.type != 3) break block22;
                            for (int i = 0; i < dblen; ++i) {
                                int val = db.getElem(0, i);
                                int a = val >> 24 & 0xFF;
                                int r = val >> 16 & 0xFF;
                                int g = val >> 8 & 0xFF;
                                int b = val & 0xFF;
                                if (a == 0 || a == 255) continue;
                                float f = 255.0f / (float)a;
                                r = (int)((float)r * f);
                                g = (int)((float)g * f);
                                b = (int)((float)b * f);
                                if (r > 255) {
                                    r = 255;
                                }
                                if (g > 255) {
                                    g = 255;
                                }
                                if (b > 255) {
                                    b = 255;
                                }
                                int resultval = a << 24 | r << 16 | g << 8 | b;
                                db.setElem(0, i, resultval);
                            }
                            break block20;
                        }
                        if (biw.type != 0) break block23;
                        if (db.getDataType() != 0) break block24;
                        for (int i = 0; i < dblen; i += tc) {
                            int a = db.getElem(0, i + cc);
                            if (a == 0 || a == 255) continue;
                            float alphaf = (float)a / 255.0f;
                            for (int c = 0; c < cc; ++c) {
                                int colorval = db.getElem(0, i + c);
                                db.setElem(0, i + c, (int)((float)colorval / alphaf));
                            }
                        }
                        break block20;
                    }
                    if (db.getDataType() != 1) break block25;
                    for (int i = 0; i < dblen; i += tc) {
                        int a = db.getElem(0, i + cc);
                        if (a == 0 || a == 65535) continue;
                        float alphaf = (float)a / 65535.0f;
                        for (int c = 0; c < cc; ++c) {
                            int colorval = db.getElem(0, i + c);
                            db.setElem(0, i + c, (int)((float)colorval / alphaf));
                        }
                    }
                    break block20;
                }
                if (db.getDataType() != 4) break block20;
                for (int i = 0; i < dblen; i += tc) {
                    float a = db.getElemFloat(0, i + cc);
                    if (a == 0.0f || a == 255.0f) continue;
                    for (int c = 0; c < cc; ++c) {
                        float colorval = db.getElemFloat(0, i + c);
                        db.setElemFloat(0, i + c, colorval / a);
                    }
                }
                break block20;
            }
            if (biw.type == 6 || biw.type == 7) {
                for (int i = 0; i < dblen; i += 4) {
                    int a = db.getElem(0, i);
                    if (a == 0 || a == 255) continue;
                    int b = db.getElem(0, i + 1);
                    int g = db.getElem(0, i + 2);
                    int r = db.getElem(0, i + 3);
                    float alphaf = (float)a / 255.0f;
                    db.setElem(0, i + 1, (int)((float)b / alphaf));
                    db.setElem(0, i + 2, (int)((float)g / alphaf));
                    db.setElem(0, i + 3, (int)((float)r / alphaf));
                }
            }
        }
    }

    @Override
    public void dispose() {
    }
}

