/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.converter.ColorCache;
import com.neptunelabs.imagereader.converter.ColorConverterCache;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import com.neptunelabs.imagereader.converter.RgbProfileConverter;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.awt.color.CMMException;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class BufferedImageConverterThreaded
extends BufferedImageConverter {
    private final ExecutorPool executorPool;
    private final int minThreadDBSize = 262144;
    private final ColorSpaceConverter sRGB;
    private final ColorConverterCache colorConverterCache;
    boolean debugMode = false;

    public BufferedImageConverterThreaded(FSILogger logger, ExecutorPool executorPool, ColorConverterCache colorConverterCache) {
        super(logger);
        this.executorPool = executorPool;
        this.colorConverterCache = colorConverterCache;
        ICCProfileWrap masterProfile = colorConverterCache.getSRGBProfile();
        this.sRGB = new RgbProfileConverter(this.clutCache, masterProfile, ProfileDirection.Output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean convert(int priority, int maxThreads, ExecutorPool.Type executorType, BufferedImageWrap biw, FSIImage targetFSIImage, int targetOffsetX, int targetOffsetY) throws FSIImageException, InterruptedException {
        boolean returnvalue;
        int threads;
        if (biw.hasAlpha() && biw.isAlphaPremultiplied()) {
            this.removePremultiplication(biw);
        }
        boolean hasICC = false;
        if (biw.colorSpaceConverter != null && biw.conversionRequired) {
            hasICC = true;
        }
        int segments = 0;
        if (biw.colorType == ColorType.RGB24 || biw.colorType == ColorType.RGB15 || biw.colorType == ColorType.RGB16) {
            segments = 3;
        } else if (biw.colorType == ColorType.LAB) {
            segments = 3;
        } else if (biw.colorType == ColorType.GRAY || biw.colorType == ColorType.GRAYINVERTED) {
            segments = 1;
        }
        ColorCache colorMapCache = this.colorConverterCache.getColorCache(biw.icc);
        if (colorMapCache == null && biw.icc != null) {
            colorMapCache = this.colorConverterCache.registerProfile(biw.icc, segments);
        } else if (colorMapCache == null) {
            colorMapCache = this.colorConverterCache.getEmptyColorCache(segments);
        }
        DataBuffer db = biw.raster.getDataBuffer();
        int dbLength = db.getSize();
        if (maxThreads == 1 || biw.type == 12 || biw.type == 13) {
            threads = 1;
        } else {
            threads = this.executorPool.getAvailableThreads(executorType);
            if (threads > 1) {
                int logicalDBThreads = (int)Math.ceil((float)dbLength / 262144.0f);
                if (threads > logicalDBThreads) {
                    threads = logicalDBThreads;
                }
                if (threads > biw.height) {
                    threads = biw.height;
                }
            }
            if (maxThreads > threads) {
                threads = maxThreads;
            }
        }
        int elementsPerPixel = biw.bi.getRaster().getNumDataElements();
        if (this.debugMode) {
            System.out.println("Convert");
            System.out.println("Threads:" + threads);
            System.out.println("ColorType:" + (Object)((Object)biw.colorType));
            System.out.println("Type:" + biw.type);
            System.out.println("Bands:" + biw.bands);
            System.out.println("dblen:" + dbLength);
            System.out.println("dbtype:" + db.getDataType());
            System.out.println("dbbanks:" + db.getNumBanks());
            System.out.println("DB ElementsPerPixel:" + elementsPerPixel);
            System.out.println("Raster:" + biw.bi.getRaster());
            System.out.println("BIW\n" + biw.toString());
            System.out.println("ICC:" + biw.icc);
            System.out.println("colorComponents:" + biw.colorComponents);
            System.out.println("totalComponents:" + biw.totalComponents);
            System.out.println("conversionRequired:" + biw.conversionRequired);
            System.out.println("-----------------");
        }
        int threadTargetYStop = 0;
        if (threads > 1) {
            int c;
            PriorityExecutorCompletionService<Boolean> completionService = new PriorityExecutorCompletionService<Boolean>(this.executorPool.getExecutorService(executorType), threads);
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(threads);
            for (c = 0; c < threads; ++c) {
                int n = threadTargetYStop;
                threadTargetYStop = c + 1 == threads ? biw.height : (int)((float)(c + 1) * ((float)biw.height / (float)threads));
                if (threadTargetYStop > targetFSIImage.getHeight()) {
                    threadTargetYStop = targetFSIImage.getHeight();
                }
                int dbStart = biw.width * n * elementsPerPixel;
                int dbStop = biw.width * threadTargetYStop * elementsPerPixel;
                ConverterCallable converter = new ConverterCallable(priority, biw, targetFSIImage, colorMapCache, db, dbStart, dbStop, targetOffsetX, targetOffsetY + n, hasICC);
                futures.add(completionService.submit(converter));
            }
            returnvalue = true;
            try {
                for (c = 0; c < completionService.count(); ++c) {
                    returnvalue &= ((Boolean)completionService.take().get()).booleanValue();
                }
            }
            catch (ExecutionException e) {
                returnvalue = false;
                Throwable throwable = e.getCause();
                if (throwable instanceof FSIImageException) {
                    throw (FSIImageException)throwable;
                }
            }
            finally {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        } else {
            boolean dbStart = false;
            int dbStop = dbLength;
            ConverterCallable converter = new ConverterCallable(priority, biw, targetFSIImage, colorMapCache, db, 0, dbStop, targetOffsetX, targetOffsetY, hasICC);
            try {
                returnvalue = converter.call();
            }
            catch (Exception exception) {
                returnvalue = false;
                if (exception instanceof FSIImageException) {
                    throw (FSIImageException)exception;
                }
                this.logger.logException(exception, 3800, exception.getLocalizedMessage());
            }
        }
        return returnvalue;
    }

    private void removePremultiplication(BufferedImageWrap biw) {
        block20: {
            int dblen;
            DataBuffer db;
            block23: {
                int cc;
                int tc;
                block25: {
                    block24: {
                        block22: {
                            block18: {
                                int dblen2;
                                DataBuffer db2;
                                int alphaBand;
                                int colorEnd;
                                block21: {
                                    block19: {
                                        tc = biw.totalComponents;
                                        cc = biw.colorComponents;
                                        colorEnd = biw.extraAlphaStart;
                                        alphaBand = biw.getAlphaBand();
                                        if (alphaBand == -1) break block18;
                                        WritableRaster wr = biw.bi.getRaster();
                                        db2 = wr.getDataBuffer();
                                        dblen2 = db2.getSize();
                                        if (db2.getDataType() != 0) break block19;
                                        for (int i = 0; i < dblen2; i += tc) {
                                            int a = db2.getElem(0, i + alphaBand);
                                            if (a == 0 || a == 255) continue;
                                            float alphaf = (float)a / 255.0f;
                                            for (int c = 0; c < colorEnd; ++c) {
                                                int colorval = db2.getElem(0, i + c);
                                                db2.setElem(0, i + c, (int)((float)colorval / alphaf));
                                            }
                                        }
                                        break block20;
                                    }
                                    if (db2.getDataType() != 1) break block21;
                                    for (int i = 0; i < dblen2; i += tc) {
                                        int a = db2.getElem(0, i + alphaBand);
                                        if (a == 0 || a == 65535) continue;
                                        float alphaf = (float)a / 65535.0f;
                                        for (int c = 0; c < colorEnd; ++c) {
                                            int colorval = db2.getElem(0, i + c);
                                            db2.setElem(0, i + c, (int)((float)colorval / alphaf));
                                        }
                                    }
                                    break block20;
                                }
                                if (db2.getDataType() != 4) break block20;
                                for (int i = 0; i < dblen2; i += tc) {
                                    float a = db2.getElemFloat(0, i + alphaBand);
                                    if (a == 0.0f || a == 255.0f) continue;
                                    for (int c = 0; c < colorEnd; ++c) {
                                        float colorval = db2.getElemFloat(0, i + c);
                                        db2.setElemFloat(0, i + c, colorval / a);
                                    }
                                }
                                break block20;
                            }
                            if (tc == cc) break block20;
                            WritableRaster wr = biw.bi.getRaster();
                            db = wr.getDataBuffer();
                            dblen = db.getSize();
                            if (biw.type != 1 && biw.type != 4 && biw.type != 2 && biw.type != 3) break block22;
                            for (int i = 0; i < dblen; ++i) {
                                int val = db.getElem(0, i);
                                int a = val >> 24 & 0xFF;
                                int r = val >> 16 & 0xFF;
                                int g = val >> 8 & 0xFF;
                                int b = val & 0xFF;
                                if (a == 0 || a == 255) continue;
                                float f = 255.0f / (float)a;
                                r = (int)((float)r * f);
                                g = (int)((float)g * f);
                                b = (int)((float)b * f);
                                if (r > 255) {
                                    r = 255;
                                }
                                if (g > 255) {
                                    g = 255;
                                }
                                if (b > 255) {
                                    b = 255;
                                }
                                int resultval = a << 24 | r << 16 | g << 8 | b;
                                db.setElem(0, i, resultval);
                            }
                            break block20;
                        }
                        if (biw.type != 0) break block23;
                        if (db.getDataType() != 0) break block24;
                        for (int i = 0; i < dblen; i += tc) {
                            int a = db.getElem(0, i + cc);
                            if (a == 0 || a == 255) continue;
                            float alphaf = (float)a / 255.0f;
                            for (int c = 0; c < cc; ++c) {
                                int colorval = db.getElem(0, i + c);
                                db.setElem(0, i + c, (int)((float)colorval / alphaf));
                            }
                        }
                        break block20;
                    }
                    if (db.getDataType() != 1) break block25;
                    for (int i = 0; i < dblen; i += tc) {
                        int a = db.getElem(0, i + cc);
                        if (a == 0 || a == 65535) continue;
                        float alphaf = (float)a / 65535.0f;
                        for (int c = 0; c < cc; ++c) {
                            int colorval = db.getElem(0, i + c);
                            db.setElem(0, i + c, (int)((float)colorval / alphaf));
                        }
                    }
                    break block20;
                }
                if (db.getDataType() != 4) break block20;
                for (int i = 0; i < dblen; i += tc) {
                    float a = db.getElemFloat(0, i + cc);
                    if (a == 0.0f || a == 255.0f) continue;
                    for (int c = 0; c < cc; ++c) {
                        float colorval = db.getElemFloat(0, i + c);
                        db.setElemFloat(0, i + c, colorval / a);
                    }
                }
                break block20;
            }
            if (biw.type == 6 || biw.type == 7) {
                for (int i = 0; i < dblen; i += 4) {
                    int a = db.getElem(0, i);
                    if (a == 0 || a == 255) continue;
                    int b = db.getElem(0, i + 1);
                    int g = db.getElem(0, i + 2);
                    int r = db.getElem(0, i + 3);
                    float alphaf = (float)a / 255.0f;
                    db.setElem(0, i + 1, (int)((float)b / alphaf));
                    db.setElem(0, i + 2, (int)((float)g / alphaf));
                    db.setElem(0, i + 3, (int)((float)r / alphaf));
                }
            }
        }
    }

    @Override
    public ColorLookUpTableCache getClutCache() {
        return this.clutCache;
    }

    @Override
    public void dispose() {
        this.clutCache.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertLinearRaw(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, DataBuffer db, int dbStart, int dbStop, int dbtype, Histogram histogram, ColorType colorType) {
        int alphaBand = biw.getAlphaBand();
        boolean useAlpha = biw.hasAlpha() && alphaBand != -1;
        ColorSpaceConverter targetConverter = biw.colorSpaceConverter;
        ColorSpaceConverter cpcrgb = this.sRGB;
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        if (biw.type == 1) {
            for (int i = dbStart; i < dbStop; ++i) {
                int argb = db.getElem(0, i) & 0xFFFFFF;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 5) {
            for (int i = dbStart; i < dbStop; i += 3) {
                int rgb = db.getElem(0, i + 2) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i);
                image.setSample(tx, ty, rgb);
                if (histogram != null) {
                    histogram.pushRGB(rgb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 6) {
            if (colorType != ColorType.CMYK) throw new FSIImageException("Unsupported image format");
            float[] cmyk = new float[4];
            float[] xyz = new float[3];
            float[] rgb = new float[3];
            int oldCacheKey = -1;
            int oldRGB = 0;
            for (int x = dbStart; x < dbStop; x += 4) {
                int k;
                int y;
                int m;
                int c = db.getElem(0, x + 3);
                int cacheKey = c << 24 | (m = db.getElem(0, x + 2)) << 16 | (y = db.getElem(0, x + 1)) << 8 | (k = biw.sawAdobeMarker ? 255 - db.getElem(0, x) : db.getElem(0, x));
                if (cacheKey != oldCacheKey) {
                    cmyk[0] = (float)c / 255.0f;
                    cmyk[1] = (float)m / 255.0f;
                    cmyk[2] = (float)y / 255.0f;
                    cmyk[3] = (float)k / 255.0f;
                    targetConverter.toCIEXYZ(cmyk, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgb);
                    int rgbint = BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                    image.setSample(tx, ty, rgbint);
                    if (histogram != null) {
                        histogram.pushRGB(rgbint);
                    }
                    oldCacheKey = cacheKey;
                    oldRGB = rgbint;
                } else {
                    image.setSample(tx, ty, oldRGB);
                    if (histogram != null) {
                        histogram.pushRGB(oldRGB);
                    }
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 2 || biw.type == 3 || biw.type == 1) {
            if (colorType == ColorType.CMYK) {
                float[] cmyk = new float[4];
                float[] xyz = new float[3];
                float[] rgb = new float[3];
                int oldCacheKey = -1;
                int oldRGB = 0;
                for (int x = dbStart; x < dbStop; ++x) {
                    int cacheKey;
                    int cmyki = db.getElem(0, x);
                    int c = cmyki >> 1 & 0xFF;
                    int m = cmyki >> 8 & 0xFF;
                    int y = cmyki & 0xFF;
                    int k = cmyki >> 24 & 0xFF;
                    if (biw.sawAdobeMarker) {
                        k = 255 - k;
                    }
                    if ((cacheKey = cmyki) != oldCacheKey) {
                        cmyk[0] = (float)c / 255.0f;
                        cmyk[1] = (float)m / 255.0f;
                        cmyk[2] = (float)y / 255.0f;
                        cmyk[3] = (float)k / 255.0f;
                        targetConverter.toCIEXYZ(cmyk, xyz);
                        cpcrgb.fromCIEXYZ(xyz, rgb);
                        int rgbint = BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                        image.setSample(tx, ty, rgbint);
                        if (histogram != null) {
                            histogram.pushRGB(rgbint);
                        }
                        oldCacheKey = cacheKey;
                        oldRGB = rgbint;
                    } else {
                        image.setSample(tx, ty, oldRGB);
                        if (histogram != null) {
                            histogram.pushRGB(oldRGB);
                        }
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else if (useAlpha) {
                for (int i = dbStart; i < dbStop; ++i) {
                    int argb = db.getElem(0, i);
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                for (int i = dbStart; i < dbStop; ++i) {
                    int argb = db.getElem(0, i) & 0xFFFFFF;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushRGB(argb);
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else if (biw.type == 4) {
            for (int i = dbStart; i < dbStop; ++i) {
                int brg = db.getElem(0, i) & 0xFFFFFF;
                int rgb = brg >> 16 | brg & 0xFF00 | brg << 16 & 0xFF0000;
                image.setSample(tx, ty, rgb);
                if (histogram != null) {
                    histogram.pushRGB(rgb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 0) {
            if (colorType == ColorType.CMYK) {
                float[] cmyk = new float[4];
                float[] xyz = new float[3];
                float[] rgb = new float[3];
                int oldCacheKey = -1;
                int oldRGB = 0;
                int alpha = 255;
                for (int x = dbStart; x < dbStop; x += biw.totalComponents) {
                    int rgbint;
                    int c = db.getElem(0, x);
                    int m = db.getElem(0, x + 1);
                    int y = db.getElem(0, x + 2);
                    int k = biw.sawAdobeMarker ? 255 - db.getElem(0, x + 3) : db.getElem(0, x + 3);
                    alpha = useAlpha ? db.getElem(0, x + alphaBand) : 255;
                    int cacheKey = c << 24 | m << 16 | y << 8 | k;
                    if (cacheKey != oldCacheKey) {
                        cmyk[0] = (float)c / 255.0f;
                        cmyk[1] = (float)m / 255.0f;
                        cmyk[2] = (float)y / 255.0f;
                        cmyk[3] = (float)k / 255.0f;
                        targetConverter.toCIEXYZ(cmyk, xyz);
                        cpcrgb.fromCIEXYZ(xyz, rgb);
                        rgbint = BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                        oldCacheKey = cacheKey;
                        oldRGB = rgbint;
                    } else {
                        rgbint = oldRGB;
                    }
                    int argb = alpha << 24 | rgbint;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushRGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.totalComponents) {
                        alpha = db.getElem(0, x + ea);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)alpha);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                if (colorType != ColorType.RGB24 || biw.totalComponents != 4) throw new FSIImageException("Unsupported image format");
                for (int i = dbStart; i < dbStop; i += 4) {
                    int argb = db.getElem(0, i + 3) << 24 | db.getElem(0, i) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i + 2);
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else if (biw.type == 12) {
            if (dbtype != 0 || biw.bands != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(biw, image, targetOffsetX, targetOffsetY, db, dbStart, dbStop, histogram, colorType);
            return;
        } else if (biw.type == 8) {
            if (dbtype != 1 || biw.bands != 3) throw new FSIImageException("Unsupported image format");
            for (int i = dbStart; i < dbStop; ++i) {
                int i565 = db.getElem(0, i);
                int r = (((i565 & 0xF800) >> 11) + 1) * 8 - 1;
                int g = (((i565 & 0x7E0) >> 5) + 1) * 4 - 1;
                int b = ((i565 & 0x1F) + 1) * 8 - 1;
                int argb = r << 16 | g << 8 | b;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 9) {
            if (dbtype != 1 || biw.bands != 3) throw new FSIImageException("Unsupported image format");
            for (int i = dbStart; i < dbStop; ++i) {
                int i565 = db.getElem(0, i);
                int r = (((i565 & 0x7C00) >> 10) + 1) * 8 - 1;
                int g = (((i565 & 0x7E0) >> 5) + 1) * 8 - 1;
                int b = ((i565 & 0x1F) + 1) * 8 - 1;
                int argb = r << 16 | g << 8 | b;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 10) {
            for (int i = dbStart; i < dbStop; ++i) {
                int gray = db.getElem(0, i);
                int argb = gray << 16 | gray << 8 | gray;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.bands == 3) {
            for (int i = dbStart; i < dbStop; i += 3) {
                int argb = db.getElem(0, i) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i + 2);
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else {
            if (biw.bands != 1) throw new FSIImageException("Unsupported image format");
            for (int i = dbStart; i < db.getSize(); ++i) {
                int argb = db.getElem(0, i) & 0xFF;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
        }
    }

    void convertLinearIndexed(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, DataBuffer db, int dbStart, int dbStop, Histogram histogram, ColorType colorType) {
        if (biw.type == 12 || biw.type == 13 || biw.type == 10) {
            if (biw.bands != 1) {
                throw new FSIImageException("Unsupported image format");
            }
        } else {
            throw new FSIImageException("Unsupported image format");
        }
        this.convertByteBinary(biw, image, targetOffsetX, targetOffsetY, db, dbStart, dbStop, histogram, colorType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertLinearRGB(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, DataBuffer db, int dbStart, int dbStop, int dbtype, Histogram histogram, ColorType colorType) {
        int alphaBand = biw.getAlphaBand();
        boolean useAlpha = biw.hasAlpha() && alphaBand != -1;
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        if (biw.type == 1) {
            int[] dbi = ((DataBufferInt)db).getData(0);
            for (int i = dbStart; i < dbStop; ++i) {
                int argb = dbi[i];
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 2) {
            int[] dbi = ((DataBufferInt)db).getData(0);
            for (int i = dbStart; i < dbStop; ++i) {
                int argb = dbi[i];
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushARGB(argb);
                }
                int ea = biw.extraAlphaStart;
                int bank = 0;
                while (ea < biw.extraAlphaEnd) {
                    int alpha = db.getElem(0, i + ea - 3);
                    image.setSampleExtraAlpha(bank, tx, ty, (byte)alpha);
                    ++ea;
                    ++bank;
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 5) {
            for (int i = dbStart; i < dbStop; i += 3) {
                int b8 = db.getElem(0, i);
                int g8 = db.getElem(0, i + 1);
                int r8 = db.getElem(0, i + 2);
                int argb = r8 << 16 | g8 << 8 | b8;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(r8, g8, b8);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 6) {
            if (dbtype != 0 || db.getNumBanks() != 1) throw new FSIImageException("Unsupported image format");
            int a8 = 255;
            byte[] dbb = ((DataBufferByte)db).getData(0);
            for (int i = dbStart; i < dbStop; i += 4) {
                a8 = dbb[i] & 0xFF;
                int b8 = dbb[i + 1] & 0xFF;
                int g8 = dbb[i + 2] & 0xFF;
                int r8 = dbb[i + 3] & 0xFF;
                int argb = a8 << 24 | r8 << 16 | g8 << 8 | b8;
                image.setSample(tx, ty, argb);
                image.setSampleExtraAlpha(0, tx, ty, (byte)a8);
                if (histogram != null) {
                    histogram.pushARGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 0) {
            if (dbtype == 0) {
                int a8 = 255;
                byte[] dbb = ((DataBufferByte)db).getData(0);
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int r8 = dbb[i] & 0xFF;
                    int g8 = dbb[i + 1] & 0xFF;
                    int b8 = dbb[i + 2] & 0xFF;
                    a8 = useAlpha ? dbb[i + alphaBand] & 0xFF : 255;
                    int argb = a8 << 24 | r8 << 16 | g8 << 8 | b8;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a8 = dbb[i + ea] & 0xFF;
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a8);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else if (dbtype == 1) {
                int a16 = 255;
                short[] dbs = ((DataBufferUShort)db).getData(0);
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int r16 = BufferedImageConverterThreaded.sample16to8(dbs[i] & 0xFFFF);
                    int g16 = BufferedImageConverterThreaded.sample16to8(dbs[i + 1] & 0xFFFF);
                    int b16 = BufferedImageConverterThreaded.sample16to8(dbs[i + 2] & 0xFFFF);
                    a16 = useAlpha ? BufferedImageConverterThreaded.sample16to8(dbs[i + alphaBand] & 0xFFFF) : 255;
                    int argb = a16 << 24 | r16 << 16 | g16 << 8 | b16;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a16 = BufferedImageConverterThreaded.sample16to8(dbs[i + ea] & 0xFFFF);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a16);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                if (dbtype != 4) throw new FSIImageException("Unsupported image format");
                int a = 255;
                float[] dbf = ((DataBufferFloat)db).getData(0);
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int r = (int)(dbf[i] * 255.0f + 0.5f);
                    int g = (int)(dbf[i + 1] * 255.0f + 0.5f);
                    int b = (int)(dbf[i + 2] * 255.0f + 0.5f);
                    if (useAlpha) {
                        float alpha = dbf[i + alphaBand];
                        a = (int)(alpha * 255.0f + 0.5f);
                    } else {
                        a = 255;
                    }
                    int argb = a << 24 | r << 16 | g << 8 | b;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = (int)(dbf[i + ea] * 255.0f + 0.5f);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else {
            if (biw.type != 12) throw new FSIImageException("Unsupported image format:" + biw.type);
            if (dbtype != 0 || biw.bands != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(biw, image, targetOffsetX, targetOffsetY, db, dbStart, dbStop, histogram, colorType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertLinearGray(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, DataBuffer db, int dbStart, int dbStop, int dbtype, Histogram histogram, ColorType colorType) {
        int alphaBand = biw.getAlphaBand();
        boolean useAlpha = biw.hasAlpha() && alphaBand != -1;
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        if (biw.type == 10) {
            for (int i = dbStart; i < dbStop; ++i) {
                int gray8 = db.getElem(0, i) & 0xFF;
                int argb = gray8 << 16 | gray8 << 8 | gray8;
                image.setSample(argb);
                if (histogram == null) continue;
                histogram.pushRGB(argb);
            }
            return;
        } else if (biw.type == 12) {
            if (dbtype != 0 || biw.bands != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(biw, image, targetOffsetX, targetOffsetY, db, dbStart, dbStop, histogram, colorType);
            return;
        } else {
            if (biw.type != 0 && biw.type != 11) throw new FSIImageException("Unsupported image format");
            if (dbtype == 0) {
                int alpha8 = 255;
                byte[] dbb = ((DataBufferByte)db).getData(0);
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int gray8 = dbb[i] & 0xFF;
                    alpha8 = useAlpha ? dbb[i + alphaBand] & 0xFF : 255;
                    int argb = alpha8 << 24 | gray8 << 16 | gray8 << 8 | gray8;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        alpha8 = dbb[i + ea] & 0xFF;
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)alpha8);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else if (dbtype == 1) {
                int alpha8 = 255;
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int gray8 = (db.getElem(0, i) + 1) / 256 - 1;
                    int n = gray8 = gray8 < 0 ? 0 : gray8;
                    alpha8 = useAlpha ? ((alpha8 = (db.getElem(0, i + alphaBand) + 1) / 256 - 1) < 0 ? 0 : alpha8) : 255;
                    int argb = alpha8 << 24 | gray8 << 16 | gray8 << 8 | gray8;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        alpha8 = (db.getElem(0, i + ea) + 1) / 256 - 1;
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)alpha8);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                if (dbtype != 4) throw new FSIImageException("Unsupported image format");
                int alpha = 255;
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    float gray8 = db.getElemFloat(0, i);
                    int gray = (int)(gray8 * 255.0f + 0.5f);
                    alpha = useAlpha ? (int)(db.getElemFloat(0, i + alphaBand) * 255.0f + 0.5f) : 255;
                    int argb = alpha << 24 | gray << 16 | gray << 8 | gray;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        alpha = (int)(db.getElemFloat(0, i + ea) * 255.0f + 0.5f);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)alpha);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertICCRGB(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, ColorCache colorMapCache, DataBuffer db, int dbStart, int dbStop, int dbtype, Histogram histogram) {
        float[] xyz = new float[3];
        float[] rgbout = new float[3];
        int alpha = -16777216;
        int a = 255;
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        int alphaBand = biw.getAlphaBand();
        boolean useAlpha = biw.hasAlpha() && alphaBand != -1;
        ColorSpaceConverter targetConverter = biw.colorSpaceConverter;
        ColorSpaceConverter cpcrgb = this.sRGB;
        int btc = biw.totalComponents;
        if (biw.type == 2 || biw.type == 3 || biw.type == 1) {
            int[] dbi = ((DataBufferInt)db).getData(0);
            for (int i = dbStart; i < dbStop; ++i) {
                int rgbCached;
                int trgb = dbi[i];
                int r = trgb >> 16 & 0xFF;
                int g = trgb >> 8 & 0xFF;
                int b = trgb & 0xFF;
                if (useAlpha) {
                    alpha = trgb & 0xFF000000;
                }
                if ((rgbCached = colorMapCache.get(r, g, b)) == -1) {
                    targetConverter.toCIEXYZ((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgbout);
                    rgbCached = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                    colorMapCache.put(r, g, b, rgbCached);
                }
                int argb = useAlpha ? alpha | rgbCached : rgbCached;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    if (useAlpha) {
                        histogram.pushARGB(alpha, r, g, b);
                    } else {
                        histogram.pushRGB(r, g, b);
                    }
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 4) {
            int[] dbi = ((DataBufferInt)db).getData(0);
            for (int i = dbStart; i < dbStop; ++i) {
                int rgb = dbi[i] & 0xFFFFFF;
                int r = rgb & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb >> 16 & 0xFF;
                int argb = colorMapCache.get(r, g, b);
                if (argb == -1) {
                    targetConverter.toCIEXYZ(r, g, b, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgbout);
                    argb = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                    colorMapCache.put(r, g, b, argb);
                }
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 0) {
            if (dbtype == 3) {
                int[] dbi = ((DataBufferInt)db).getData(0);
                for (int i = dbStart; i < dbStop; ++i) {
                    int rgbCached;
                    int trgb = dbi[i];
                    int r = trgb >> 16 & 0xFF;
                    int g = trgb >> 8 & 0xFF;
                    int b = trgb & 0xFF;
                    if (useAlpha) {
                        alpha = trgb & 0xFF000000;
                    }
                    if ((rgbCached = colorMapCache.get(r, g, b)) == -1) {
                        targetConverter.toCIEXYZ((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
                        cpcrgb.fromCIEXYZ(xyz, rgbout);
                        rgbCached = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                        colorMapCache.put(r, g, b, rgbCached);
                    }
                    int argb = useAlpha ? alpha | rgbCached : rgbCached;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        if (useAlpha) {
                            histogram.pushARGB(argb);
                        } else {
                            histogram.pushRGB(argb);
                        }
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else if (dbtype == 0) {
                byte[] dbb = ((DataBufferByte)db).getData(0);
                for (int i = dbStart; i < dbStop; i += btc) {
                    int r = dbb[i] & 0xFF;
                    int g = dbb[i + 1] & 0xFF;
                    int b = dbb[i + 2] & 0xFF;
                    a = useAlpha ? dbb[i + alphaBand] & 0xFF : 255;
                    int rgb = colorMapCache.get(r, g, b);
                    if (rgb == -1) {
                        targetConverter.toCIEXYZ((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
                        cpcrgb.fromCIEXYZ(xyz, rgbout);
                        rgb = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                        colorMapCache.put(r, g, b, rgb);
                    }
                    int argb = a << 24 | rgb;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(a, r, g, b);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = dbb[i + ea] & 0xFF;
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else if (dbtype == 1) {
                short[] dbs = ((DataBufferUShort)db).getData(0);
                for (int i = dbStart; i < dbStop; i += btc) {
                    targetConverter.toCIEXYZ((float)(dbs[i] & 0xFFFF) / 65535.0f, (float)(dbs[i + 1] & 0xFFFF) / 65535.0f, (float)(dbs[i + 2] & 0xFFFF) / 65535.0f, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgbout);
                    a = useAlpha ? BufferedImageConverterThreaded.sample16to8(dbs[i + alphaBand] & 0xFFFF) : 255;
                    int argb = a << 24 | BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = BufferedImageConverterThreaded.sample16to8(dbs[i + ea] & 0xFFFF);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                if (dbtype != 4) throw new FSIImageException("Unsupported image format: " + biw.type + " " + dbtype);
                for (int i = dbStart; i < dbStop; i += btc) {
                    targetConverter.toCIEXYZ(db.getElemFloat(0, i), db.getElemFloat(0, i + 1), db.getElemFloat(0, i + 2), xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgbout);
                    if (useAlpha) {
                        float alphasf = db.getElemFloat(0, i + alphaBand);
                        a = (int)(alphasf * 255.0f + 0.5f);
                    } else {
                        a = 255;
                    }
                    int argb = a << 24 | BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = (int)(db.getElemFloat(0, i + ea) * 255.0f + 0.5f);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else if (biw.type == 1) {
            xyz = new float[3];
            rgbout = new float[3];
            int[] dbb = ((DataBufferInt)db).getData(0);
            for (int i = dbStart; i < dbStop; ++i) {
                int rgb = dbb[i];
                targetConverter.toCIEXYZ(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, xyz);
                cpcrgb.fromCIEXYZ(xyz, rgbout);
                int argb = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 5) {
            for (int i = dbStart; i < dbStop; i += 3) {
                int b = db.getElem(0, i);
                int g = db.getElem(0, i + 1);
                int r = db.getElem(0, i + 2);
                int rgb = colorMapCache.get(r, g, b);
                if (rgb == -1) {
                    targetConverter.toCIEXYZ((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgbout);
                    rgb = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                    colorMapCache.put(r, g, b, rgb);
                }
                image.setSample(tx, ty, rgb);
                if (histogram != null) {
                    histogram.pushRGB(rgb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else {
            if (biw.type != 6) throw new FSIImageException("Unsupported image format");
            for (int i = dbStart; i < dbStop; i += 4) {
                alpha = db.getElem(0, i);
                int b = db.getElem(0, i + 1);
                int g = db.getElem(0, i + 2);
                int r = db.getElem(0, i + 3);
                int rgb = colorMapCache.get(r, g, b);
                if (rgb == -1) {
                    targetConverter.toCIEXYZ((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgbout);
                    rgb = BufferedImageConverterThreaded.floatArray1ToInt(rgbout);
                    colorMapCache.put(r, g, b, rgb);
                }
                int argb = alpha << 24 | rgb;
                image.setSample(tx, ty, argb);
                int ea = biw.extraAlphaStart;
                int bank = 0;
                while (ea < biw.extraAlphaEnd) {
                    image.setSampleExtraAlpha(bank, tx, ty, (byte)alpha);
                    ++ea;
                    ++bank;
                }
                if (histogram != null) {
                    histogram.pushARGB(alpha, r, g, b);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertICCGray(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, ColorCache colorMapCache, DataBuffer db, int dbStart, int dbStop, int dbtype, Histogram histogram, ColorType colorType) {
        float[] xyz = new float[3];
        float[] grayout = new float[3];
        int a = 255;
        int tc = biw.totalComponents;
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        int alphaBand = biw.getAlphaBand();
        boolean useAlpha = biw.hasAlpha() && alphaBand != -1;
        ColorSpaceConverter targetConverter = biw.colorSpaceConverter;
        ColorSpaceConverter cpcrgb = this.sRGB;
        if (biw.type == 10) {
            for (int i = dbStart; i < dbStop; i += tc) {
                int k = db.getElem(0, i) & 0xFF;
                a = useAlpha ? db.getElem(0, i + alphaBand) & 0xFF : 255;
                int rgb = colorMapCache.get(k);
                if (rgb == -1) {
                    targetConverter.toCIEXYZ((float)k / 255.0f, 0.0f, 0.0f, xyz);
                    cpcrgb.fromCIEXYZ(xyz, grayout);
                    int gray = (int)(grayout[0] * 255.0f + 0.5f);
                    gray = k;
                    rgb = gray << 16 | gray << 8 | gray;
                    colorMapCache.put(k, rgb);
                }
                int argb = a << 24 | rgb;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushARGB(argb);
                }
                int ea = biw.extraAlphaStart;
                int bank = 0;
                while (ea < biw.extraAlphaEnd) {
                    a = db.getElem(0, i + ea);
                    image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                    ++ea;
                    ++bank;
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 0 || biw.type == 11) {
            if (dbtype == 0) {
                for (int i = dbStart; i < dbStop; i += tc) {
                    int k = db.getElem(0, i);
                    a = useAlpha ? db.getElem(0, i + alphaBand) : 255;
                    int rgb = colorMapCache.get(k);
                    if (rgb == -1) {
                        targetConverter.toCIEXYZ((float)k / 255.0f, 0.0f, 0.0f, xyz);
                        cpcrgb.fromCIEXYZ(xyz, grayout);
                        int gray = (int)(grayout[0] * 255.0f + 0.5f);
                        rgb = gray << 16 | gray << 8 | gray;
                        colorMapCache.put(k, rgb);
                    }
                    int argb = a << 24 | rgb;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = db.getElem(0, i + ea);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else if (dbtype == 4) {
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    float rgbin = db.getElemFloat(0, i);
                    a = useAlpha ? (int)(db.getElemFloat(0, i + alphaBand) * 255.0f + 0.5f) : 255;
                    targetConverter.toCIEXYZ(rgbin, 0.0f, 0.0f, xyz);
                    cpcrgb.fromCIEXYZ(xyz, grayout);
                    int gray = (int)(grayout[0] * 255.0f + 0.5f);
                    int argb = a << 24 | gray << 16 | gray << 8 | gray;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = (int)(db.getElemFloat(0, i + ea) * 255.0f + 0.5f);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                if (dbtype != 1) throw new FSIImageException("Unsupported image format");
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int k = db.getElem(0, i);
                    a = useAlpha ? BufferedImageConverterThreaded.sample16to8(db.getElem(0, i + alphaBand)) : 255;
                    int rgb = colorMapCache.get(k);
                    if (rgb == -1) {
                        targetConverter.toCIEXYZ((float)k / 65535.0f, 0.0f, 0.0f, xyz);
                        cpcrgb.fromCIEXYZ(xyz, grayout);
                        int gray = (int)(grayout[0] * 255.0f + 0.5f);
                        rgb = gray << 16 | gray << 8 | gray;
                        colorMapCache.put(k, rgb);
                    }
                    int argb = a << 24 | rgb;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = BufferedImageConverterThreaded.sample16to8(db.getElem(0, i + ea));
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else {
            if (biw.type != 12) throw new FSIImageException("Unsupported image format");
            if (dbtype != 0 || biw.bands != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(biw, image, targetOffsetX, targetOffsetY, db, dbStart, dbStop, histogram, colorType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertICCCMYK(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, DataBuffer db, int dbStart, int dbStop, int dbtype, Histogram histogram) {
        float[] cmyk = new float[4];
        float[] xyz = new float[3];
        float[] rgb = new float[3];
        int a = 255;
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        int alphaBand = biw.getAlphaBand();
        boolean useAlpha = biw.hasAlpha() && alphaBand != -1;
        ColorSpaceConverter targetConverter = biw.colorSpaceConverter;
        ColorSpaceConverter cpcrgb = this.sRGB;
        if (biw.type == 6) {
            int oldCacheKey = -1;
            int oldRGB = 0;
            for (int i = dbStart; i < dbStop; i += 4) {
                int k;
                int y;
                int m;
                int c = db.getElem(0, i + 3);
                int cacheKey = c << 24 | (m = db.getElem(0, i + 2)) << 16 | (y = db.getElem(0, i + 1)) << 8 | (k = biw.sawAdobeMarker ? 255 - db.getElem(0, i) : db.getElem(0, i));
                if (cacheKey != oldCacheKey) {
                    cmyk[0] = (float)c / 255.0f;
                    cmyk[1] = (float)m / 255.0f;
                    cmyk[2] = (float)y / 255.0f;
                    cmyk[3] = (float)k / 255.0f;
                    targetConverter.toCIEXYZ(cmyk, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgb);
                    int rgbint = BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                    image.setSample(tx, ty, rgbint);
                    oldCacheKey = cacheKey;
                    oldRGB = rgbint;
                    if (histogram != null) {
                        histogram.pushRGB(rgbint);
                    }
                } else {
                    image.setSample(tx, ty, oldRGB);
                    if (histogram != null) {
                        histogram.pushRGB(oldRGB);
                    }
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
            return;
        } else if (biw.type == 0) {
            if (dbtype == 0) {
                int oldCacheKey = -1;
                int oldRGB = 0;
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    int rgbint;
                    int c = db.getElem(0, i + 0);
                    int m = db.getElem(0, i + 1);
                    int y = db.getElem(0, i + 2);
                    int k = biw.sawAdobeMarker ? 255 - db.getElem(0, i + 3) : db.getElem(0, i + 3);
                    a = useAlpha ? db.getElem(0, i + alphaBand) : 255;
                    int cacheKey = c << 24 | m << 16 | y << 8 | k;
                    if (cacheKey != oldCacheKey) {
                        cmyk[0] = (float)c / 255.0f;
                        cmyk[1] = (float)m / 255.0f;
                        cmyk[2] = (float)y / 255.0f;
                        cmyk[3] = (float)k / 255.0f;
                        targetConverter.toCIEXYZ(cmyk, xyz);
                        cpcrgb.fromCIEXYZ(xyz, rgb);
                        rgbint = BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                        oldCacheKey = cacheKey;
                        oldRGB = rgbint;
                    } else {
                        rgbint = oldRGB;
                    }
                    int argb = a << 24 | rgbint & 0xFFFFFF;
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushARGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = db.getElem(0, i + ea);
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
                return;
            } else {
                if (dbtype != 1 && dbtype != 2) throw new FSIImageException("Unsupported image format");
                for (int i = dbStart; i < dbStop; i += biw.totalComponents) {
                    cmyk[0] = (float)db.getElem(0, i) / 65535.0f;
                    cmyk[1] = (float)db.getElem(0, i + 1) / 65535.0f;
                    cmyk[2] = (float)db.getElem(0, i + 2) / 65535.0f;
                    cmyk[3] = biw.sawAdobeMarker ? 1.0f - (float)db.getElem(0, i + 3) / 65535.0f : (float)db.getElem(0, i + 3) / 65535.0f;
                    a = useAlpha ? BufferedImageConverterThreaded.sample16to8(db.getElem(0, i + alphaBand)) : 255;
                    targetConverter.toCIEXYZ(cmyk, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgb);
                    int argb = a << 24 | BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushRGB(argb);
                    }
                    int ea = biw.extraAlphaStart;
                    int bank = 0;
                    while (ea < biw.extraAlphaEnd) {
                        a = BufferedImageConverterThreaded.sample16to8(db.getElem(0, i + ea));
                        image.setSampleExtraAlpha(bank, tx, ty, (byte)a);
                        ++ea;
                        ++bank;
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else {
            if (biw.type != 2) throw new FSIImageException("Unsupported image format");
            int oldCacheKey = -1;
            int oldRGB = 0;
            for (int x = dbStart; x < dbStop; ++x) {
                int rgbint;
                int cacheKey;
                int cmyki = db.getElem(0, x);
                int k = cmyki >> 24 & 0xFF;
                int c = cmyki >> 16 & 0xFF;
                int m = cmyki >> 8 & 0xFF;
                int y = cmyki & 0xFF;
                if (biw.sawAdobeMarker) {
                    k = 255 - k;
                }
                if ((cacheKey = c << 24 | m << 16 | y << 8 | k) != oldCacheKey) {
                    cmyk[0] = (float)c / 255.0f;
                    cmyk[1] = (float)m / 255.0f;
                    cmyk[2] = (float)y / 255.0f;
                    cmyk[3] = (float)k / 255.0f;
                    targetConverter.toCIEXYZ(cmyk, xyz);
                    cpcrgb.fromCIEXYZ(xyz, rgb);
                    rgbint = BufferedImageConverterThreaded.floatArray1ToInt(rgb);
                    oldCacheKey = cacheKey;
                    oldRGB = rgbint;
                } else {
                    rgbint = oldRGB;
                }
                int argb = a << 24 | rgbint;
                image.setSample(tx, ty, argb);
                if (histogram != null) {
                    histogram.pushRGB(argb);
                }
                if (++tx != tWidth) continue;
                tx = targetOffsetX;
                ++ty;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertByteBinary(BufferedImageWrap biw, FSIImage image, int targetOffsetX, int targetOffsetY, DataBuffer db, int dbStart, int dbStop, Histogram histogram, ColorType colorType) throws FSIImageException {
        int tx = targetOffsetX;
        int ty = targetOffsetY;
        int tWidth = targetOffsetX + biw.width;
        int opaque = -16777216;
        if (biw.colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)biw.colorModel;
            int[] rgbmap = new int[icm.getMapSize()];
            int tIndex = icm.getTransparentPixel();
            icm.getRGBs(rgbmap);
            int maxWidth = (int)(Math.ceil((float)image.getWidth() / 8.0f) * 8.0);
            if (biw.bpp == 1) {
                int v1;
                int v0;
                if (biw.bi.getColorModel() instanceof IndexColorModel) {
                    v0 = rgbmap[0];
                    v1 = rgbmap[1];
                } else if (colorType != ColorType.GRAYINVERTED) {
                    v0 = 0;
                    v1 = 0xFFFFFF;
                } else {
                    v1 = 0;
                    v0 = 0xFFFFFF;
                }
                int cx = 0;
                for (int i = dbStart; i < dbStop; ++i) {
                    int b8 = db.getElem(0, i);
                    for (int b = 7; b >= 0; --b) {
                        if (cx < image.getWidth()) {
                            int v = b8 >> b & 1;
                            int argb = v == 0 ? v0 : v1;
                            image.setSample(tx, ty, argb);
                            if (histogram != null) {
                                histogram.pushRGB(argb);
                            }
                            if (++tx == tWidth) {
                                tx = targetOffsetX;
                                ++ty;
                            }
                        }
                        if (++cx < maxWidth) continue;
                        cx = 0;
                    }
                }
                return;
            } else if (biw.bpp == 2) {
                int cx = 0;
                for (int i = dbStart; i < dbStop; ++i) {
                    int alpha;
                    int argb;
                    int v = db.getElem(0, i);
                    int v1 = v >>> 6;
                    int v2 = v >> 4 & 3;
                    int v3 = v >> 2 & 3;
                    int v4 = v & 3;
                    if (cx < image.getWidth() && v1 < rgbmap.length) {
                        if (v4 == tIndex) {
                            argb = 0;
                            alpha = 0;
                        } else {
                            argb = 0xFF000000 | rgbmap[v1];
                            alpha = 255;
                        }
                        image.setSample(tx, ty, argb);
                        if (histogram != null) {
                            histogram.pushRGB(argb);
                        }
                        if (image.hasExtraAlpha()) {
                            image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                        }
                        if (++tx == tWidth) {
                            tx = targetOffsetX;
                            ++ty;
                        }
                    }
                    if (++cx >= image.getWidth()) {
                        cx = 0;
                        continue;
                    }
                    if (cx < image.getWidth() && v2 < rgbmap.length) {
                        if (v4 == tIndex) {
                            argb = 0;
                            alpha = 0;
                        } else {
                            argb = 0xFF000000 | rgbmap[v2];
                            alpha = 255;
                        }
                        image.setSample(tx, ty, argb);
                        if (histogram != null) {
                            histogram.pushRGB(argb);
                        }
                        if (image.hasExtraAlpha()) {
                            image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                        }
                        if (++tx == tWidth) {
                            tx = targetOffsetX;
                            ++ty;
                        }
                    }
                    if (++cx >= image.getWidth()) {
                        cx = 0;
                        continue;
                    }
                    if (cx < image.getWidth() && v3 < rgbmap.length) {
                        if (v4 == tIndex) {
                            argb = 0;
                            alpha = 0;
                        } else {
                            argb = 0xFF000000 | rgbmap[v3];
                            alpha = 255;
                        }
                        image.setSample(tx, ty, argb);
                        if (histogram != null) {
                            histogram.pushRGB(argb);
                        }
                        if (image.hasExtraAlpha()) {
                            image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                        }
                        if (++tx == tWidth) {
                            tx = targetOffsetX;
                            ++ty;
                        }
                    }
                    if (++cx >= image.getWidth()) {
                        cx = 0;
                        continue;
                    }
                    if (cx < image.getWidth() && v4 < rgbmap.length) {
                        if (v4 == tIndex) {
                            argb = 0;
                            alpha = 0;
                        } else {
                            argb = 0xFF000000 | rgbmap[v4];
                            alpha = 255;
                        }
                        image.setSample(tx, ty, argb);
                        if (histogram != null) {
                            histogram.pushRGB(argb);
                        }
                        if (image.hasExtraAlpha()) {
                            image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                        }
                        if (++tx == tWidth) {
                            tx = targetOffsetX;
                            ++ty;
                        }
                    }
                    if (++cx < image.getWidth()) continue;
                    cx = 0;
                }
                return;
            } else if (biw.bpp == 4) {
                int cx = 0;
                for (int i = dbStart; i < dbStop; ++i) {
                    int alpha;
                    int argb;
                    int v = db.getElem(0, i);
                    int v1 = v >>> 4;
                    int v2 = v & 0xF;
                    if (cx == image.getWidth()) {
                        cx = 0;
                    }
                    if (v1 < rgbmap.length && cx < image.getWidth()) {
                        if (v1 == tIndex) {
                            argb = 0;
                            alpha = 0;
                        } else {
                            argb = 0xFF000000 | rgbmap[v1];
                            alpha = 255;
                        }
                        image.setSample(tx, ty, argb);
                        if (histogram != null) {
                            histogram.pushRGB(argb);
                        }
                        if (image.hasExtraAlpha()) {
                            image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                        }
                        if (++tx == tWidth) {
                            tx = targetOffsetX;
                            ++ty;
                        }
                    } else {
                        cx = 0;
                        continue;
                    }
                    if (v2 < rgbmap.length && ++cx < image.getWidth()) {
                        if (v2 == tIndex) {
                            argb = 0;
                            alpha = 0;
                        } else {
                            argb = 0xFF000000 | rgbmap[v2];
                            alpha = 255;
                        }
                        image.setSample(tx, ty, argb);
                        if (histogram != null) {
                            histogram.pushRGB(argb);
                        }
                        if (image.hasExtraAlpha()) {
                            image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                        }
                        if (++tx == tWidth) {
                            tx = targetOffsetX;
                            ++ty;
                        }
                    } else {
                        cx = 0;
                        continue;
                    }
                    ++cx;
                }
                return;
            } else {
                if (biw.bpp != 8) throw new FSIImageException("Unsupported image format");
                icm.getRGBs(rgbmap);
                for (int i = dbStart; i < dbStop; ++i) {
                    int alpha;
                    int argb;
                    int v = db.getElem(0, i);
                    if (v >= rgbmap.length) continue;
                    if (v == tIndex) {
                        argb = 0;
                        alpha = 0;
                    } else {
                        argb = 0xFF000000 | rgbmap[v];
                        alpha = 255;
                    }
                    image.setSample(tx, ty, argb);
                    if (histogram != null) {
                        histogram.pushRGB(argb);
                    }
                    if (image.hasExtraAlpha()) {
                        image.setSampleExtraAlpha(0, tx, ty, (byte)alpha);
                    }
                    if (++tx != tWidth) continue;
                    tx = targetOffsetX;
                    ++ty;
                }
            }
            return;
        } else {
            if (!(biw.colorModel instanceof ComponentColorModel)) throw new FSIImageException("Unsupported image format");
            throw new FSIImageException("Unsupported image format");
        }
    }

    private static int floatArray1ToInt(float[] rgbout) {
        return (int)(rgbout[0] * 255.0f + 0.5f) << 16 | (int)(rgbout[1] * 255.0f + 0.5f) << 8 | (int)(rgbout[2] * 255.0f + 0.5f);
    }

    private static int sample16to8(int bits) {
        return FastMath.ceil((float)(bits + 1) / 256.0f) - 1;
    }

    private final class DataImageData {
        DataBuffer db;
        int startX;
        int stopX;
        int startY;
        int stopY;
        int rowWidth;
        int elementSize;

        private DataImageData() {
        }
    }

    private final class ConverterCallable
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private final BufferedImageWrap biw;
        private final FSIImage targetImage;
        private final ColorCache colorMapCache;
        private final DataBuffer db;
        private final int dbtype;
        private final int dbStart;
        private final int dbStop;
        private final int targetOffsetX;
        private final int targetOffsetY;
        private final boolean hasICC;

        protected ConverterCallable(int priority, BufferedImageWrap biw, FSIImage targetImage, ColorCache colorMapCache, DataBuffer db, int dbStart, int dbStop, int targetOffsetX, int targetOffsetY, boolean hasICC) {
            this.priority = priority;
            this.biw = biw;
            this.targetImage = targetImage;
            this.colorMapCache = colorMapCache;
            this.db = db;
            this.dbtype = db.getDataType();
            this.dbStart = dbStart;
            this.dbStop = dbStop;
            this.targetOffsetX = targetOffsetX;
            this.targetOffsetY = targetOffsetY;
            this.hasICC = hasICC;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Boolean call() {
            boolean result = false;
            try {
                if (this.hasICC) {
                    if (this.biw.colorType == ColorType.CMYK) {
                        if (BufferedImageConverterThreaded.this.debugMode) {
                            System.out.println("convertICCCMYK");
                        }
                        BufferedImageConverterThreaded.this.convertICCCMYK(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.db, this.dbStart, this.dbStop, this.dbtype, this.biw.histogram);
                    } else if (this.biw.colorType == ColorType.GRAY || this.biw.colorType == ColorType.GRAYINVERTED) {
                        if (BufferedImageConverterThreaded.this.debugMode) {
                            System.out.println("convertICCGray");
                        }
                        BufferedImageConverterThreaded.this.convertICCGray(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.colorMapCache, this.db, this.dbStart, this.dbStop, this.dbtype, this.biw.histogram, this.biw.colorType);
                    } else {
                        if (this.biw.colorType != ColorType.RGB24 && this.biw.colorType != ColorType.LAB) throw new FSIImageException("Unsupported image format");
                        if (BufferedImageConverterThreaded.this.debugMode) {
                            System.out.println("convertICCRGB");
                        }
                        BufferedImageConverterThreaded.this.convertICCRGB(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.colorMapCache, this.db, this.dbStart, this.dbStop, this.dbtype, this.biw.histogram);
                    }
                } else if (this.biw.colorType == ColorType.GRAY || this.biw.colorType == ColorType.GRAYINVERTED) {
                    if (BufferedImageConverterThreaded.this.debugMode) {
                        System.out.println("convertLinearGray");
                    }
                    BufferedImageConverterThreaded.this.convertLinearGray(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.db, this.dbStart, this.dbStop, this.dbtype, this.biw.histogram, this.biw.colorType);
                } else if (this.biw.colorType == ColorType.RGB24 || this.biw.colorType == ColorType.LAB) {
                    if (BufferedImageConverterThreaded.this.debugMode) {
                        System.out.println("convertLinearRGB");
                    }
                    BufferedImageConverterThreaded.this.convertLinearRGB(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.db, this.dbStart, this.dbStop, this.dbtype, this.biw.histogram, this.biw.colorType);
                } else if (this.biw.colorType == ColorType.INDEXED) {
                    if (BufferedImageConverterThreaded.this.debugMode) {
                        System.out.println("convertLinearIndexed");
                    }
                    BufferedImageConverterThreaded.this.convertLinearIndexed(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.db, this.dbStart, this.dbStop, this.biw.histogram, this.biw.colorType);
                } else {
                    if (BufferedImageConverterThreaded.this.debugMode) {
                        System.out.println("convertLinearRaw:" + (Object)((Object)this.biw.colorType));
                    }
                    BufferedImageConverterThreaded.this.convertLinearRaw(this.biw, this.targetImage, this.targetOffsetX, this.targetOffsetY, this.db, this.dbStart, this.dbStop, this.dbtype, this.biw.histogram, this.biw.colorType);
                }
                result = true;
                return result;
            }
            catch (BufferOverflowException e) {
                e.printStackTrace();
                BufferedImageConverterThreaded.this.logger.logException(e, 3821, "BO:" + e.getLocalizedMessage(), this.biw.sourceImage);
                result = false;
                return result;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                BufferedImageConverterThreaded.this.logger.logException(e, 3821, "AIOB:" + e.getLocalizedMessage(), this.biw.sourceImage);
                result = false;
                return result;
            }
            catch (CMMException e) {
                e.printStackTrace();
                throw new FSIImageException("Unsupported ICC profile detected");
            }
        }
    }
}

