/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ClutProfileConverter;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.GrayProfileConverter;
import com.neptunelabs.imagereader.converter.GrayScaleConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.LinearCMYKConverter;
import com.neptunelabs.imagereader.converter.OriginProfileConverter;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import com.neptunelabs.imagereader.converter.RgbProfileConverter;
import com.neptunelabs.imagereader.helper.AWTDumper;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class BufferedImageWrap {
    public String sourceImage;
    public BufferedImage bi;
    public WritableRaster raster;
    public final SampleModel sampleModel;
    public final ColorModel colorModel;
    public final ColorSpace colorSpace;
    public final int colorSpaceType;
    public final ColorLookUpTableCache clutCache;
    public final int width;
    public final int height;
    public final int type;
    public final int bands;
    public final int totalComponents;
    public final int colorComponents;
    public final int bpp;
    public ColorType colorType;
    public boolean useFallbackConverter = true;
    public boolean sawAdobeMarker = false;
    public boolean forceCMYK = false;
    private boolean hasAlpha = false;
    private int alphaBand = -1;
    private boolean isAlphaPremultiplied = false;
    public int dbType;
    public ICCProfileWrap defaultCMYKICC = null;
    public ICCProfileWrap defaultRGBICC = null;
    public ICCProfileWrap defaultGrayICC = null;
    public String defaultCMYKICCHash = null;
    public String defaultRGBICCHash = null;
    public String defaultGrayICCHash = null;
    public boolean conversionRequired = true;
    public ColorSpaceConverter colorSpaceConverter = null;
    public ICCProfileWrap icc = null;
    public ColorType icc_type = ColorType.UNKNOWN;
    public int extraAlphaStart = 0;
    public int extraAlphaEnd = 0;
    public Histogram histogram;

    public BufferedImageWrap(BufferedImage bi, ColorLookUpTableCache clutCache) {
        this.bi = bi;
        this.clutCache = clutCache;
        this.raster = bi.getRaster();
        this.sampleModel = bi.getSampleModel();
        this.colorModel = bi.getColorModel();
        this.colorSpace = this.colorModel.getColorSpace();
        this.colorSpaceType = this.colorSpace.getType();
        this.dbType = this.raster.getDataBuffer().getDataType();
        this.width = this.raster.getWidth();
        this.height = this.raster.getHeight();
        this.conversionRequired = false;
        this.type = bi.getType();
        this.bands = this.sampleModel.getNumBands();
        this.colorComponents = this.colorModel.getNumColorComponents();
        this.totalComponents = this.colorModel.getNumComponents();
        this.bpp = this.colorModel.getPixelSize();
    }

    public void setHasAlpha(boolean state) {
        this.hasAlpha = state;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public void setIsAlphaPremultiplied(boolean state) {
        this.isAlphaPremultiplied = state;
    }

    public boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public void setAlphaBand(int band) {
        this.alphaBand = band;
    }

    public int getAlphaBand() {
        return this.alphaBand;
    }

    public void setICCProfile(ICCProfileWrap ipw) {
        this.icc = ipw;
        this.conversionRequired = this.icc != null;
    }

    public void setAlphaStart(int bandStart) {
        if (bandStart != -1) {
            this.extraAlphaStart = bandStart;
            this.extraAlphaEnd = this.totalComponents;
        } else {
            this.extraAlphaStart = 0;
            this.extraAlphaEnd = -1;
        }
    }

    public void setUseFallbackConverter(boolean state) {
        this.useFallbackConverter = state;
    }

    public void setSawAdobeMarker(boolean state) {
        this.sawAdobeMarker = state;
    }

    public void setDefaultICCProfiles(ICCProfileWrap cmyk, ICCProfileWrap rgb, ICCProfileWrap gray) {
        this.defaultCMYKICC = cmyk;
        this.defaultRGBICC = rgb;
        this.defaultGrayICC = gray;
    }

    public void dispose() {
        this.raster = null;
        this.bi.flush();
        this.bi = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BI Type:");
        sb.append(AWTDumper.bufferedTypeToString(this.type));
        sb.append('\n');
        sb.append("Dimension:");
        sb.append(this.width);
        sb.append(" x ");
        sb.append(this.height);
        sb.append('\n');
        sb.append("Bands:");
        sb.append(this.bands);
        sb.append('\n');
        sb.append("DataBuffer Length:");
        sb.append(this.raster.getDataBuffer().getSize());
        sb.append('\n');
        sb.append("DataBuffer Type:");
        sb.append(AWTDumper.dataBufferTypeToString(this.dbType));
        sb.append('\n');
        sb.append("Colormodel:");
        sb.append(this.colorModel);
        sb.append('\n');
        sb.append("Color Components:");
        sb.append(this.colorComponents);
        sb.append('\n');
        sb.append("Total Components:");
        sb.append(this.totalComponents);
        sb.append('\n');
        sb.append("hasAlpha:");
        sb.append(this.hasAlpha);
        sb.append('\n');
        sb.append("premultiplied:");
        sb.append(this.isAlphaPremultiplied);
        sb.append('\n');
        sb.append("alphaBand:");
        sb.append(this.alphaBand);
        sb.append('\n');
        sb.append("extraAlphaStart:");
        sb.append(this.extraAlphaStart);
        sb.append('\n');
        sb.append("extraAlphaEnd:");
        sb.append(this.extraAlphaEnd);
        sb.append('\n');
        sb.append("ICC Profile:");
        sb.append(this.icc);
        sb.append('\n');
        return sb.toString();
    }

    public void initColorConverter(ColorType expectedColorType) {
        ICC_Profile iccProfile;
        this.colorType = expectedColorType;
        if (this.icc != null && (iccProfile = this.icc.getProfile()) != null) {
            int iccColorType = iccProfile.getColorSpaceType();
            if (iccColorType == 9 && expectedColorType != ColorType.CMYK) {
                this.icc = this.getFittingProfile(expectedColorType);
            } else if (iccColorType == 5 && expectedColorType != ColorType.RGB24 && expectedColorType != ColorType.RGB16 && expectedColorType != ColorType.RGB15) {
                this.icc = this.getFittingProfile(expectedColorType);
            } else if (iccColorType == 6 && expectedColorType != ColorType.GRAY) {
                this.icc = this.getFittingProfile(expectedColorType);
            }
        }
        if (expectedColorType == ColorType.CMYK) {
            if (this.icc != null) {
                this.colorSpaceConverter = new ClutProfileConverter(this.clutCache, this.icc, ProfileDirection.Input);
                if ((this.colorSpaceConverter == null || this.colorSpaceConverter.hasError()) && this.useFallbackConverter) {
                    this.colorSpaceConverter = new OriginProfileConverter(this.clutCache, this.icc, ProfileDirection.Input);
                }
            }
            if (this.colorSpaceConverter == null) {
                if (this.defaultCMYKICC != null) {
                    this.colorSpaceConverter = new ClutProfileConverter(this.clutCache, this.defaultCMYKICC, ProfileDirection.Input);
                    this.icc = this.defaultCMYKICC;
                } else {
                    this.colorSpaceConverter = new LinearCMYKConverter();
                }
                this.conversionRequired = true;
            }
        } else if (expectedColorType == ColorType.GRAY || expectedColorType == ColorType.GRAYINVERTED) {
            if (this.icc != null) {
                this.colorSpaceConverter = new GrayProfileConverter(this.clutCache, this.icc, ProfileDirection.Input);
                if ((this.colorSpaceConverter == null || this.colorSpaceConverter.hasError()) && this.useFallbackConverter) {
                    this.colorSpaceConverter = new OriginProfileConverter(this.clutCache, this.icc, ProfileDirection.Input);
                }
                if (this.colorSpaceConverter != null && this.colorSpaceConverter.hasError()) {
                    this.colorSpaceConverter = null;
                } else {
                    this.conversionRequired = true;
                }
            }
            if (this.colorSpaceConverter == null) {
                if (this.defaultGrayICC != null) {
                    this.colorSpaceConverter = new GrayProfileConverter(this.clutCache, this.defaultGrayICC, ProfileDirection.Input);
                    this.icc = this.defaultGrayICC;
                    this.conversionRequired = true;
                } else {
                    this.colorSpaceConverter = new GrayScaleConverter(this.defaultGrayICC);
                    this.icc = this.defaultGrayICC;
                    this.conversionRequired = true;
                }
            }
        } else if (expectedColorType == ColorType.RGB24 || expectedColorType == ColorType.RGB15 || expectedColorType == ColorType.RGB16) {
            if (this.icc != null) {
                this.colorSpaceConverter = new RgbProfileConverter(this.clutCache, this.icc, ProfileDirection.Input);
                if (this.colorSpaceConverter != null && this.colorSpaceConverter.hasError()) {
                    this.colorSpaceConverter = null;
                } else {
                    this.conversionRequired = true;
                }
                if (this.colorSpaceConverter == null || this.colorSpaceConverter != null && this.colorSpaceConverter.hasError() && this.useFallbackConverter) {
                    this.colorSpaceConverter = new OriginProfileConverter(this.clutCache, this.icc, ProfileDirection.Input);
                }
            }
        } else if (expectedColorType == ColorType.LAB) {
            this.conversionRequired = false;
        }
        if (this.colorSpaceConverter == null || this.colorSpaceConverter != null && this.colorSpaceConverter.hasError()) {
            this.conversionRequired = false;
        }
    }

    private ICCProfileWrap getFittingProfile(ColorType cType) {
        ICCProfileWrap result = null;
        switch (cType) {
            case CMYK: {
                result = this.defaultCMYKICC;
                break;
            }
            case RGB15: 
            case RGB16: 
            case RGB24: {
                result = this.defaultRGBICC;
                break;
            }
            case GRAY: {
                result = this.defaultGrayICC;
            }
        }
        return result;
    }
}

