/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CMYKColorCache
extends ColorCache {
    private final Map<Long, Integer> cache;

    public CMYKColorCache(int max) {
        this.cache = Collections.synchronizedMap(new CMYKCache(max));
    }

    @Override
    public int get(long cmyk) {
        Integer i = this.cache.get(cmyk);
        int result = i == null ? -1 : i;
        if (this.hits++ % 100000L == 0L) {
            this.refresh();
        }
        return result;
    }

    @Override
    public int get(int r, int g, int b) {
        throw new IllegalArgumentException();
    }

    @Override
    public void put(long cmyk, int rgb) {
        this.cache.put(cmyk, rgb);
    }

    @Override
    public void put(int r, int g, int b, int rgb) {
        throw new IllegalArgumentException();
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    private static class CMYKCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 2552078002847868662L;
        private final int MAX_ENTRIES;

        public CMYKCache(int max) {
            this.MAX_ENTRIES = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.MAX_ENTRIES;
        }
    }
}

