/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorLookUpTable;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import java.awt.color.ICC_Profile;

public final class ClutProfileConverter
extends ColorSpaceConverter {
    private ColorLookUpTable toPCS;
    private ColorLookUpTable fromPCS;
    private final int nChannels;

    public ClutProfileConverter(ColorLookUpTableCache clutCache, ICCProfileWrap ipw, ProfileDirection pdir) {
        super(ipw);
        String iccHash = ipw.getHash();
        ICC_Profile profile = ipw.getProfile();
        this.nChannels = profile.getNumComponents();
        try {
            this.toPCS = clutCache.get(iccHash, profile, 1093812784);
        }
        catch (Exception e) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = clutCache.get(iccHash, profile, 1110589744);
        }
        catch (Exception e) {
            this.fromPCS = null;
        }
        if (this.toPCS != null || this.fromPCS != null) {
            if (pdir == ProfileDirection.Input) {
                this.setToWhitePoint(profile, this.toPCS, this.fromPCS);
            }
            return;
        }
        try {
            this.toPCS = clutCache.get(iccHash, profile, 1093812785);
        }
        catch (Exception e) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = clutCache.get(iccHash, profile, 1110589745);
        }
        catch (Exception e) {
            this.fromPCS = null;
        }
        if (this.toPCS != null || this.fromPCS != null) {
            if (pdir == ProfileDirection.Input) {
                this.setToWhitePoint(profile, this.toPCS, this.fromPCS);
            }
            return;
        }
        try {
            this.toPCS = clutCache.get(iccHash, profile, 1093812786);
        }
        catch (Exception e) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = clutCache.get(iccHash, profile, 1110589746);
        }
        catch (Exception e) {
            this.fromPCS = null;
        }
        if (this.toPCS == null && this.fromPCS == null) {
            this.error = true;
            throw new IllegalArgumentException("No CLUTs in profile!");
        }
        if (pdir == ProfileDirection.Input) {
            this.setToWhitePoint(profile, this.toPCS, this.fromPCS);
        }
    }

    @Override
    public void toCIEXYZ(float i0, float i1, float i2, float[] out) {
        if (this.toPCS != null) {
            this.toPCS.lookup(i0, i1, i2, out);
        }
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        if (this.toPCS != null) {
            this.toPCS.lookup(in, out);
        }
    }

    @Override
    public void fromCIEXYZ(float x, float y, float z, float[] out) {
        if (this.fromPCS != null) {
            this.fromPCS.lookup(x, y, z, out);
        }
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        if (this.fromPCS != null) {
            this.fromPCS.lookup(in, out);
        }
    }
}

