/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorCache;
import com.neptunelabs.imagereader.converter.GrayColorCache;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.RGBColorCache256k;
import com.neptunelabs.imagereader.helper.ICCDefaultReader;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class ColorConverterCache {
    private final ConcurrentHashMap<String, ColorCache> colorCacheMap;
    private final ConcurrentHashMap<String, ICCProfileWrap> profileMaps;
    private final int maxProfiles;
    private ICCProfileWrap masterProfile;
    private final ReentrantLock lock = new ReentrantLock();

    public ColorConverterCache(int maxProfiles) {
        ICC_Profile mpcc;
        this.maxProfiles = maxProfiles;
        this.colorCacheMap = new ConcurrentHashMap(maxProfiles);
        this.profileMaps = new ConcurrentHashMap(maxProfiles);
        try {
            mpcc = ICCDefaultReader.getDefaultICCProfile("rgb");
        }
        catch (IOException e) {
            mpcc = ICC_Profile.getInstance(1000);
        }
        if (mpcc != null) {
            this.masterProfile = new ICCProfileWrap(mpcc.getData());
        }
    }

    public ICCProfileWrap getSRGBProfile() {
        return this.masterProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorCache registerProfile(ICCProfileWrap ipw, int segments) {
        ColorCache cc = null;
        if (ipw != null) {
            this.lock.lock();
            cc = this.colorCacheMap.get(ipw.getHash());
            try {
                if (cc == null) {
                    if (segments == 1) {
                        cc = new GrayColorCache();
                    } else if (segments == 3) {
                        cc = new RGBColorCache256k();
                    }
                    if (cc != null) {
                        this.colorCacheMap.put(ipw.getHash(), cc);
                        this.cleanUp();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return cc;
    }

    public ColorCache getColorCache(ICCProfileWrap ipw) {
        if (ipw != null) {
            return this.colorCacheMap.get(ipw.getHash());
        }
        return null;
    }

    public ColorCache getEmptyColorCache(int segments) {
        ColorCache cc = null;
        if (segments == 1) {
            cc = new GrayColorCache();
        } else if (segments == 3) {
            cc = new RGBColorCache256k();
        }
        return cc;
    }

    public ICCProfileWrap getICCProfileWrap(String profileHash) {
        return this.profileMaps.get(profileHash);
    }

    public void close(String profileHash) {
        this.lock.lock();
        try {
            this.colorCacheMap.remove(profileHash);
            this.profileMaps.remove(profileHash);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void dispose() {
        this.lock.lock();
        try {
            this.colorCacheMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void cleanUp() {
        while (this.colorCacheMap.size() > this.maxProfiles) {
            long last = Long.MAX_VALUE;
            String key = null;
            for (Map.Entry<String, ColorCache> entry : this.colorCacheMap.entrySet()) {
                if (entry.getValue().getLastUsage() >= last) continue;
                last = entry.getValue().getLastUsage();
                key = entry.getKey();
            }
            if (key == null) continue;
            this.colorCacheMap.remove(key);
        }
    }
}

