/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.imagereader.converter.FastMath;
import java.awt.color.ICC_Profile;
import java.nio.ByteOrder;

final class ColorLookUpTable {
    private float whitePoint0 = 0.96422f;
    private float whitePoint1 = 1.0f;
    private float whitePoint2 = 0.82521f;
    private int nIn;
    private int nOut;
    private int nInTableEntries;
    private int nOutTableEntries;
    private int gridpoints;
    private int nClut;
    private double[][] inTable;
    private short[][] outTable;
    private double[] clut;
    private float[][] inMatrix;
    private boolean useMatrix = false;
    private int[] multiplier;
    private int[] offsets;
    private boolean inputLab;
    private boolean outputLab;

    public ColorLookUpTable(ICC_Profile profile, int tag) {
        switch (tag) {
            case 1093812784: 
            case 1093812785: 
            case 1093812786: {
                if (profile.getColorSpaceType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = false;
                this.outputLab = profile.getPCSType() == 1;
                break;
            }
            case 1110589744: 
            case 1110589745: 
            case 1110589746: {
                if (profile.getPCSType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = profile.getPCSType() == 1;
                this.outputLab = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a clut-type tag.");
            }
        }
        byte[] data = profile.getData(tag);
        if (data == null) {
            throw new IllegalArgumentException("Unsuitable profile, does not contain a CLUT (" + tag + ").");
        }
        if (data[0] != 109 || data[1] != 102 || data[2] != 116) {
            throw new IllegalArgumentException("Unsuitable profile, invalid CLUT data.");
        }
        if (data[3] == 50) {
            this.readClut16(data);
        } else if (data[3] == 49) {
            this.readClut8(data);
        } else {
            throw new IllegalArgumentException("Unknown/invalid CLUT type.");
        }
    }

    public void setWhitePoint(float[] whitePoint) {
        this.whitePoint0 = whitePoint[0];
        this.whitePoint1 = whitePoint[1];
        this.whitePoint2 = whitePoint[2];
    }

    private void readClut16(byte[] data) {
        int i;
        int j;
        int i2;
        ByteArrayWalker buf = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
        this.nIn = data[8] & 0xFF;
        this.nOut = data[9] & 0xFF;
        this.nInTableEntries = buf.getShort(48);
        this.nOutTableEntries = buf.getShort(50);
        this.gridpoints = data[10] & 0xFF;
        this.inMatrix = new float[3][3];
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 3; ++j) {
                this.inMatrix[i2][j] = (float)buf.getInt(12 + (i2 * 3 + j) * 4) / 65536.0f;
            }
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        for (int channel = 0; channel < this.nIn; ++channel) {
            for (i = 0; i < this.nInTableEntries; ++i) {
                this.inTable[channel][i] = (double)(buf.getShort(52 + (channel * this.nInTableEntries + i) * 2) & 0xFFFF) / 65536.0;
            }
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        for (i2 = 0; i2 < this.nIn; ++i2) {
            this.nClut *= this.gridpoints;
            if (i2 <= 0) continue;
            this.multiplier[this.nIn - i2 - 1] = this.multiplier[this.nIn - i2] * this.gridpoints;
        }
        int clutOffset = 52 + this.nIn * this.nInTableEntries * 2;
        this.clut = new double[this.nClut];
        for (i = 0; i < this.nClut; ++i) {
            this.clut[i] = (double)(buf.getShort(clutOffset + i * 2) & 0xFFFF) / 65536.0;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        for (int channel = 0; channel < this.nOut; ++channel) {
            for (int i3 = 0; i3 < this.nOutTableEntries; ++i3) {
                this.outTable[channel][i3] = buf.getShort(clutOffset + (this.nClut + channel * this.nOutTableEntries + i3) * 2);
            }
        }
        this.offsets = new int[1 << this.nIn];
        this.offsets[0] = 0;
        for (j = 0; j < this.nIn; ++j) {
            int factor = 1 << j;
            for (int i4 = 0; i4 < factor; ++i4) {
                this.offsets[factor + i4] = this.offsets[i4] + this.multiplier[j];
            }
        }
    }

    private void readClut8(byte[] data) {
        int i;
        int j;
        int i2;
        ByteArrayWalker buf = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
        this.nIn = data[8] & 0xFF;
        this.nOut = data[9] & 0xFF;
        this.nInTableEntries = 256;
        this.nOutTableEntries = 256;
        this.gridpoints = data[10] & 0xFF;
        this.inMatrix = new float[3][3];
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 3; ++j) {
                this.inMatrix[i2][j] = (float)buf.getInt(12 + (i2 * 3 + j) * 4) / 65536.0f;
            }
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        for (int channel = 0; channel < this.nIn; ++channel) {
            for (i = 0; i < this.nInTableEntries; ++i) {
                this.inTable[channel][i] = (double)(buf.get(48 + channel * this.nInTableEntries + i) & 0xFF) / 255.0;
            }
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        for (i2 = 0; i2 < this.nIn; ++i2) {
            this.nClut *= this.gridpoints;
            if (i2 <= 0) continue;
            this.multiplier[this.nIn - i2 - 1] = this.multiplier[this.nIn - i2] * this.gridpoints;
        }
        int clutOffset = 48 + this.nIn * this.nInTableEntries;
        this.clut = new double[this.nClut];
        for (i = 0; i < this.nClut; ++i) {
            this.clut[i] = (double)(buf.get(clutOffset + i) & 0xFF) / 255.0;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        for (int channel = 0; channel < this.nOut; ++channel) {
            for (int i3 = 0; i3 < this.nOutTableEntries; ++i3) {
                this.outTable[channel][i3] = (short)(buf.get(clutOffset + this.nClut + channel * this.nOutTableEntries + i3) * 257);
            }
        }
        this.offsets = new int[1 << this.nIn];
        this.offsets[0] = 0;
        for (j = 0; j < this.nIn; ++j) {
            int factor = 1 << j;
            for (int i4 = 0; i4 < factor; ++i4) {
                this.offsets[factor + i4] = this.offsets[i4] + this.multiplier[j];
            }
        }
    }

    private float calcIN1(float in, double[] inTableVal) {
        int index = (int)((double)in * (double)(this.nInTableEntries - 1));
        if (index >= this.nInTableEntries - 1) {
            in = (float)inTableVal[this.nInTableEntries - 1];
        } else if (index < 0) {
            in = (float)inTableVal[0];
        } else {
            double alpha = (double)in * ((double)this.nInTableEntries - 1.0) - (double)index;
            in = (float)(inTableVal[index] * (1.0 - alpha) + inTableVal[index + 1] * alpha);
        }
        return in;
    }

    protected void lookup(float in0, float in1, float in2, float[] out) {
        this.lookup(new float[]{in0, in1, in2}, out);
    }

    protected void lookup(float[] in, float[] output) {
        int i;
        int i2;
        float[] in2 = new float[in.length];
        if (this.useMatrix) {
            for (i2 = 0; i2 < 3; ++i2) {
                in2[i2] = in[0] * this.inMatrix[i2][0] + in[1] * this.inMatrix[i2][1] + in[2] * this.inMatrix[i2][2];
            }
        } else if (this.inputLab) {
            in2 = this.XYZtoLab(in[0], in[1], in[2]);
        } else {
            System.arraycopy(in, 0, in2, 0, in.length);
        }
        for (i2 = 0; i2 < this.nIn; ++i2) {
            int index = (int)((double)in2[i2] * (double)(this.nInTableEntries - 1));
            if (index >= this.nInTableEntries - 1) {
                in2[i2] = (float)this.inTable[i2][this.nInTableEntries - 1];
                continue;
            }
            if (index < 0) {
                in2[i2] = (float)this.inTable[i2][0];
                continue;
            }
            double alpha = (double)in2[i2] * ((double)this.nInTableEntries - 1.0) - (double)index;
            in2[i2] = (float)(this.inTable[i2][index] * (1.0 - alpha) + this.inTable[i2][index + 1] * alpha);
        }
        double[] output2 = new double[this.nOut];
        double[] weights = new double[1 << this.nIn];
        double[] clutalpha = new double[this.nIn];
        int offset = 0;
        for (i = 0; i < this.nIn; ++i) {
            int index = (int)((double)in2[i] * ((double)this.gridpoints - 1.0));
            double alpha = (double)in2[i] * ((double)this.gridpoints - 1.0) - (double)index;
            if (index > this.gridpoints - 1) {
                index = this.gridpoints - 1;
                alpha = 1.0;
            } else if (index < 0) {
                index = 0;
            }
            clutalpha[i] = alpha;
            offset += index * this.multiplier[i];
        }
        weights[0] = 1.0;
        for (int j = 0; j < this.nIn; ++j) {
            int factor = 1 << j;
            int i3 = 0;
            while (i3 < factor) {
                weights[factor + i3] = weights[i3] * clutalpha[j];
                int n = i3++;
                weights[n] = weights[n] * (1.0 - clutalpha[j]);
            }
        }
        for (i = 0; i < this.nOut; ++i) {
            output2[i] = weights[0] * this.clut[offset + i];
        }
        i = 0;
        int offset2 = 0;
        for (i = 1; i < 1 << this.nIn; ++i) {
            offset2 = offset + this.offsets[i];
            int f = 0;
            while (f < this.nOut) {
                int of = offset2 + f;
                if (of >= this.clut.length) {
                    of = this.clut.length - 1;
                } else if (of < 0) {
                    of = 0;
                }
                int n = f++;
                output2[n] = output2[n] + weights[i] * this.clut[of];
            }
        }
        if (output.length != this.nOut) {
            output = new float[this.nOut];
        }
        for (i = 0; i < this.nOut; ++i) {
            int index = (int)(output2[i] * ((double)this.nOutTableEntries - 1.0));
            if (index > this.nOutTableEntries) {
                output[i] = this.outTable[i][this.nOutTableEntries - 1];
                continue;
            }
            if (index < 0) {
                output[i] = this.outTable[i][0] & 0xFFFF;
                continue;
            }
            if (index + 1 < this.nOutTableEntries) {
                double a = output2[i] * ((double)this.nOutTableEntries - 1.0) - (double)index;
                output[i] = (float)((double)(this.outTable[i][index] & 0xFFFF) * (1.0 - a) + (double)(this.outTable[i][index + 1] & 0xFFFF) * a) / 65536.0f;
                continue;
            }
            output[i] = this.outTable[i][index] & 0xFFFF;
        }
        if (this.outputLab) {
            this.labtoXYZ(output);
            return;
        }
    }

    private void labtoXYZ(float[] in) {
        float in0 = (float)(100.392156862745 * (double)in[0]);
        float in1 = in[1] * 256.0f - 128.0f;
        float in2 = in[2] * 256.0f - 128.0f;
        float out1 = (in0 + 16.0f) / 116.0f;
        float out0 = in1 / 500.0f + out1;
        float out2 = out1 - in2 / 200.0f;
        in[0] = ColorLookUpTable.calcLabT1(out0, this.whitePoint0);
        in[1] = ColorLookUpTable.calcLabT1(out1, this.whitePoint1);
        in[2] = ColorLookUpTable.calcLabT1(out2, this.whitePoint2);
    }

    private static float calcLabT1(float out, float whitePoint) {
        double exp = out * out * out;
        out = exp <= 0.008856 ? (out - 0.13793103f) / 7.787f : (float)exp;
        return whitePoint * out;
    }

    private float[] XYZtoLab(float in0, float in1, float in2) {
        float temp0 = ColorLookUpTable.calcXYZT1(in0, this.whitePoint0);
        float temp1 = ColorLookUpTable.calcXYZT1(in1, this.whitePoint1);
        float temp2 = ColorLookUpTable.calcXYZT1(in2, this.whitePoint2);
        float out0 = 116.0f * temp1 - 16.0f;
        float out1 = 500.0f * (temp0 - temp1);
        float out2 = 200.0f * (temp1 - temp2);
        out0 = (float)((double)out0 / 100.392156862745);
        out1 = (out1 + 128.0f) / 256.0f;
        out2 = (out2 + 128.0f) / 256.0f;
        float f = out0 < 0.0f ? 0.0f : (out0 = out0 > 1.0f ? 1.0f : out0);
        float f2 = out1 < 0.0f ? 0.0f : (out1 = out1 > 1.0f ? 1.0f : out1);
        out2 = out2 < 0.0f ? 0.0f : (out2 > 1.0f ? 1.0f : out2);
        return new float[]{out0, out1, out2};
    }

    private static float calcXYZT1(float in, float whitePoint) {
        float temp = in / whitePoint;
        temp = temp <= 0.008856f ? 7.787069f * temp + 0.13793103f : (float)FastMath.exp(0.3333333432674408 * Math.log(temp));
        return temp;
    }
}

