/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.collections.LeastRecentlyUsedCache;
import com.neptunelabs.imagereader.converter.ColorLookUpTable;
import java.awt.color.ICC_Profile;
import java.util.Collections;
import java.util.Map;

public final class ColorLookUpTableCache {
    private final Map<String, ColorLookUpTable> cache = Collections.synchronizedMap(new LeastRecentlyUsedCache(100));

    public ColorLookUpTable get(String iccHash, ICC_Profile profile, int tag) {
        ColorLookUpTable clut = this.cache.get(iccHash + tag);
        if (clut == null) {
            clut = new ColorLookUpTable(profile, tag);
            this.put(iccHash + tag, clut);
        }
        return clut;
    }

    public void put(String iccHash, int tag, ColorLookUpTable clut) {
        this.put(iccHash + tag, clut);
    }

    private void put(String key, ColorLookUpTable clut) {
        this.cache.put(key, clut);
    }

    public void dispose() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }
}

