/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.imagereader.converter.ColorLookUpTable;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ICC_ProfileRGBExt;
import java.awt.color.ICC_Profile;
import java.nio.ByteOrder;

abstract class ColorSpaceConverter {
    final ICCProfileWrap ipw;
    boolean error = false;
    boolean lutInCache = false;
    private float[] baseWhitePoint = new float[]{0.96422f, 1.0f, 0.82521f};
    float[] whitePointD65 = new float[]{0.95047f, 1.0f, 1.08883f};
    float[] whitePointD50 = new float[]{0.9642f, 1.0f, 0.8249f};
    float[] customWhitePoint = null;

    ColorSpaceConverter(ICCProfileWrap ipw) {
        this.ipw = ipw;
    }

    public abstract void toCIEXYZ(float[] var1, float[] var2);

    public abstract void toCIEXYZ(float var1, float var2, float var3, float[] var4);

    public abstract void fromCIEXYZ(float[] var1, float[] var2);

    public abstract void fromCIEXYZ(float var1, float var2, float var3, float[] var4);

    public boolean hasError() {
        return this.error;
    }

    void setFromWhitePoint(ICC_Profile profile, ColorLookUpTable fromPCS, ColorLookUpTable toPCS) {
        float[] whitePoint;
        if (toPCS != null) {
            toPCS.setWhitePoint(this.baseWhitePoint);
        }
        if ((whitePoint = ColorSpaceConverter.getXYZData(profile, 0x77747074)) != null) {
            this.customWhitePoint = whitePoint;
            if (fromPCS != null) {
                fromPCS.setWhitePoint(whitePoint);
            }
        } else {
            fromPCS.setWhitePoint(this.whitePointD65);
        }
    }

    void setToWhitePoint(ICC_Profile profile, ColorLookUpTable fromPCS, ColorLookUpTable toPCS) {
        float[] whitePoint;
        if (fromPCS != null) {
            fromPCS.setWhitePoint(this.baseWhitePoint);
        }
        if ((whitePoint = ColorSpaceConverter.getXYZData(profile, 0x77747074)) != null) {
            this.customWhitePoint = whitePoint;
            if (toPCS != null) {
                toPCS.setWhitePoint(whitePoint);
            }
        } else {
            toPCS.setWhitePoint(this.whitePointD65);
        }
    }

    void setFromWhitePoint(ICC_ProfileRGBExt profile, ColorLookUpTable fromPCS, ColorLookUpTable toPCS) {
        float[] whitePoint;
        if (toPCS != null) {
            toPCS.setWhitePoint(this.baseWhitePoint);
        }
        if ((whitePoint = profile.getMediaWhitePoint()) != null) {
            this.customWhitePoint = whitePoint;
            if (fromPCS != null) {
                fromPCS.setWhitePoint(whitePoint);
            }
        } else {
            fromPCS.setWhitePoint(this.whitePointD65);
        }
    }

    void setToWhitePoint(ICC_ProfileRGBExt profile, ColorLookUpTable fromPCS, ColorLookUpTable toPCS) {
        float[] whitePoint;
        if (fromPCS != null) {
            fromPCS.setWhitePoint(this.baseWhitePoint);
        }
        if ((whitePoint = profile.getMediaWhitePoint()) != null) {
            this.customWhitePoint = whitePoint;
            if (toPCS != null) {
                toPCS.setWhitePoint(whitePoint);
            }
        } else {
            toPCS.setWhitePoint(this.whitePointD65);
        }
    }

    static float[] getXYZData(ICC_Profile icc, int signature) {
        byte[] data = icc.getData(signature);
        if (data == null) {
            return null;
        }
        ByteArrayWalker buf = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
        if (buf.getInt(0) != 1482250784) {
            return null;
        }
        float[] point = new float[]{(float)buf.getInt(8) / 65536.0f, (float)buf.getInt(12) / 65536.0f, (float)buf.getInt(16) / 65536.0f};
        return point;
    }

    float[] d50ToD65(float[] xyz) {
        float[] d65 = new float[]{xyz[0] * (this.whitePointD50[0] / this.whitePointD65[0]), xyz[1] * (this.whitePointD50[1] / this.whitePointD65[1]), xyz[2] * (this.whitePointD50[2] / this.whitePointD65[2])};
        return d65;
    }

    float[] d50ToDX(float[] xyz, float[] wp) {
        float[] d65 = new float[]{xyz[0] * (this.whitePointD50[0] / wp[0]), xyz[1] * (this.whitePointD50[1] / wp[1]), xyz[2] * (this.whitePointD50[2] / wp[2])};
        return d65;
    }
}

