/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;

public final class FSIImageConverter {
    protected FSIImageConverter() {
    }

    public static BufferedImage convertToBufferedImage(FSIImage image) {
        return FSIImageConverter.convertToBufferedImage(image, true, 0xFFFFFF);
    }

    public static BufferedImage convertToBufferedImage(FSIImage image, boolean useAlpha, int matte) throws FSIImageException {
        int width = image.getWidth();
        int height = image.getHeight();
        int bpp = 0;
        boolean drawMatte = false;
        Image result = null;
        try {
            if (useAlpha && image.hasAlpha()) {
                if (image.getMode() == FSIImageMode.ARGB) {
                    result = new BufferedImage(width, height, 2);
                    bpp = 4;
                } else if (image.getMode() == FSIImageMode.AGRAY) {
                    result = new BufferedImage(width, height, 10);
                    bpp = 1;
                }
            } else {
                if (image.hasAlpha()) {
                    drawMatte = true;
                }
                if (image.getMode() == FSIImageMode.RGB || image.getMode() == FSIImageMode.ARGB) {
                    result = new BufferedImage(width, height, 1);
                    bpp = 3;
                } else {
                    result = new BufferedImage(width, height, 10);
                    bpp = 1;
                }
            }
        }
        catch (OutOfMemoryError e) {
            if (result != null) {
                result.flush();
            }
            result = null;
            throw new FSIImageException("Out of memory");
        }
        if (result != null) {
            DataBuffer db = ((BufferedImage)result).getRaster().getDataBuffer();
            long mbbmax = image.getIntSize();
            image.setPosition(0L);
            FSIImageConverter.convert(image, bpp, db, mbbmax, drawMatte, matte);
        }
        return result;
    }

    public static Raster convertToRaster(FSIImage image, boolean useAlpha, int matte) throws FSIImageException {
        int width = image.getWidth();
        int height = image.getHeight();
        int bpp = 0;
        boolean drawMatte = false;
        Raster raster = null;
        try {
            int[] nBits;
            ColorSpace cs;
            DirectColorModel colorModel;
            if (useAlpha && image.hasAlpha()) {
                if (image.getMode() == FSIImageMode.ARGB) {
                    colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                    raster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
                    bpp = 4;
                } else if (image.getMode() == FSIImageMode.AGRAY) {
                    cs = ColorSpace.getInstance(1003);
                    nBits = new int[]{8};
                    ComponentColorModel colorModel2 = new ComponentColorModel(cs, nBits, false, true, 1, 0);
                    raster = ((ColorModel)colorModel2).createCompatibleWritableRaster(width, height);
                    bpp = 1;
                }
            } else {
                if (image.hasAlpha()) {
                    drawMatte = true;
                }
                if (image.getMode() == FSIImageMode.RGB || image.getMode() == FSIImageMode.ARGB) {
                    colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
                    raster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
                    bpp = 3;
                } else {
                    cs = ColorSpace.getInstance(1003);
                    nBits = new int[]{8};
                    ComponentColorModel colorModel3 = new ComponentColorModel(cs, nBits, false, true, 1, 0);
                    raster = ((ColorModel)colorModel3).createCompatibleWritableRaster(width, height);
                    bpp = 1;
                }
            }
        }
        catch (OutOfMemoryError e) {
            raster = null;
            throw new FSIImageException("Out of memory");
        }
        if (raster != null) {
            DataBuffer db = raster.getDataBuffer();
            long mbbmax = image.getIntSize();
            image.setPosition(0L);
            FSIImageConverter.convert(image, bpp, db, mbbmax, drawMatte, matte);
        }
        return raster;
    }

    private static final void convert(FSIImage image, int bpp, DataBuffer db, long mbbmax, boolean drawMatte, int matte) {
        block6: {
            block7: {
                block5: {
                    if (bpp != 4) break block5;
                    int[] dbi = ((DataBufferInt)db).getData(0);
                    image.getSamples(dbi, 0, dbi.length);
                    break block6;
                }
                if (bpp != 3) break block7;
                int[] dbi = ((DataBufferInt)db).getData(0);
                if (drawMatte) {
                    int mr = matte >> 16 & 0xFF;
                    int mg = matte >> 8 & 0xFF;
                    int mb = matte & 0xFF;
                    int i = 0;
                    while ((long)i < mbbmax) {
                        int nargb;
                        int argb = image.getSample();
                        int a = argb >>> 24 & 0xFF;
                        int r = argb >> 16 & 0xFF;
                        int g = argb >> 8 & 0xFF;
                        int b = argb & 0xFF;
                        if (a < 255) {
                            int alphai = (int)((float)(255 - a) * 100.0f / 255.0f);
                            r = FSIImageConverter.clampFT255(r - (r - mr) * alphai / 100);
                            g = FSIImageConverter.clampFT255(g - (g - mg) * alphai / 100);
                            b = FSIImageConverter.clampFT255(b - (b - mb) * alphai / 100);
                        }
                        dbi[i] = nargb = 0xFF000000 | r << 16 | g << 8 | b;
                        ++i;
                    }
                } else {
                    image.getSamples(dbi, 0, dbi.length);
                }
                break block6;
            }
            if (bpp != 1) break block6;
            int i = 0;
            while ((long)i < mbbmax) {
                db.setElem(0, i, image.getSample());
                ++i;
            }
        }
    }

    private static final int clampFT255(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 255.0f) {
            return 255;
        }
        return (int)(x + 0.5f);
    }
}

