/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorCache;

public final class GrayColorCache
extends ColorCache {
    private int[] lut = new int[65536];

    public GrayColorCache() {
        this.fillNegative(this.lut);
    }

    @Override
    public int get(long color) {
        if (this.hits++ % 500000L == 0L) {
            this.refresh();
        }
        return this.lut[(int)color];
    }

    @Override
    public int get(int r, int g, int b) {
        if (this.hits++ % 100000L == 0L) {
            this.refresh();
        }
        return this.lut[r];
    }

    @Override
    public void put(long keycolor, int gray) {
        this.lut[(int)keycolor] = gray;
    }

    @Override
    public void put(int r, int g, int b, int gray) {
        this.lut[r] = gray;
    }

    @Override
    public void flush() {
        this.lut = new int[65536];
    }
}

