/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorLookUpTable;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.GrayScaleConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import com.neptunelabs.imagereader.converter.ToneReproduction;
import com.neptunelabs.imagereader.converter.ToneReproductionCurve;
import com.neptunelabs.imagereader.converter.ToneReproductionGamma;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ProfileDataException;

public final class GrayProfileConverter
extends ColorSpaceConverter {
    private final ICC_ProfileGray profile;
    private final GrayScaleConverter gc;
    private ToneReproduction trc;
    private ColorLookUpTable toPCS;
    private ColorLookUpTable fromPCS;

    public GrayProfileConverter(ColorLookUpTableCache clutCache, ICCProfileWrap ipw, ProfileDirection pdir) {
        super(ipw);
        this.profile = (ICC_ProfileGray)ipw.getProfile();
        try {
            this.trc = new ToneReproductionGamma(this.profile.getGamma());
        }
        catch (ProfileDataException e) {
            this.trc = new ToneReproductionCurve(this.profile.getTRC());
        }
        this.gc = new GrayScaleConverter(ipw);
        try {
            this.toPCS = clutCache.get(ipw.getHash(), this.profile, 1093812784);
        }
        catch (Exception e) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = clutCache.get(ipw.getHash(), this.profile, 1110589744);
        }
        catch (Exception e) {
            this.fromPCS = null;
        }
        if (pdir == ProfileDirection.Input) {
            this.setToWhitePoint(this.profile, this.fromPCS, this.toPCS);
        }
    }

    @Override
    public void toCIEXYZ(float i0, float i1, float i2, float[] out) {
        if (this.toPCS != null) {
            this.toPCS.lookup(i0, i1, i2, out);
            return;
        }
        this.gc.toCIEXYZ(this.trc.lookup(i0), 0.0f, 0.0f, out);
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        this.toCIEXYZ(in[0], in[0], in[0], out);
    }

    @Override
    public void fromCIEXYZ(float x, float y, float z, float[] out) {
        if (this.fromPCS != null) {
            this.fromPCS.lookup(x, y, z, out);
            return;
        }
        this.gc.fromCIEXYZ(x, y, z, out);
        out[0] = this.trc.reverseLookup(out[0]);
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        this.fromCIEXYZ(in[0], in[1], in[2], out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ipw.getName());
        sb.append(';');
        sb.append("ColorLookUpTable To:" + this.toPCS);
        sb.append(';');
        sb.append("ColorLookUpTable From:" + this.fromPCS);
        sb.append(';');
        if (this.customWhitePoint != null) {
            sb.append("customWhitePoint:" + this.customWhitePoint[0] + "x" + this.customWhitePoint[1] + "x" + this.customWhitePoint[2]);
        }
        sb.append(';');
        sb.append("ICC:" + this.profile.toString());
        return sb.toString();
    }
}

