/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import java.awt.color.ICC_ProfileGray;

public final class GrayScaleConverter
extends ColorSpaceConverter {
    private final double[] coeff = new double[]{0.2125f, 0.7154f, 0.0721f};
    private final float coeff0 = 0.2125f;
    private final float coeff1 = 0.7154f;
    private final float coeff2 = 0.0721f;

    public GrayScaleConverter(ICCProfileWrap ipw) {
        super(ipw);
        ICC_ProfileGray profile;
        if (ipw != null && (profile = (ICC_ProfileGray)ipw.getProfile()) != null) {
            this.customWhitePoint = GrayScaleConverter.getXYZData(profile, 0x77747074);
        }
    }

    @Override
    public void toCIEXYZ(float i0, float i1, float i2, float[] out) {
        float g = i0;
        if (g < 0.0f) {
            g = 1.0f + g;
        }
        if (this.customWhitePoint != null) {
            out[0] = g * this.customWhitePoint[0];
            out[1] = g * this.customWhitePoint[1];
            out[2] = g * this.customWhitePoint[2];
        } else {
            out[0] = g * this.whitePointD50[0];
            out[1] = g * this.whitePointD50[1];
            out[2] = g * this.whitePointD50[2];
        }
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        this.toCIEXYZ(in[0], 0.0f, 0.0f, out);
    }

    @Override
    public void fromCIEXYZ(float x, float y, float z, float[] out) {
        out[0] = (0.072f * x - 0.229f * y + 1.4056f * z) * 0.0721f;
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        this.fromCIEXYZ(in[0], in[1], in[2], out);
    }
}

