/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.imagereader.converter.ICC_ProfileRGBExt;
import java.awt.color.ICC_Profile;
import java.util.zip.CRC32;

public final class ICCProfileWrap {
    private final byte[] bytes;
    private ICC_Profile profile = null;
    private String name = null;
    private final String hash;
    private ICC_ProfileRGBExt rgbProfile;

    public ICCProfileWrap(byte[] data) throws IllegalArgumentException {
        this.bytes = data;
        this.hash = this.getICCHash();
    }

    public ICC_Profile getProfile() {
        if (this.profile == null && this.bytes != null) {
            try {
                this.profile = ICC_Profile.getInstance(this.bytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.profile;
    }

    public ICC_ProfileRGBExt getRGBProfile() {
        if (this.rgbProfile == null) {
            try {
                this.rgbProfile = new ICC_ProfileRGBExt(this.getProfile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rgbProfile;
    }

    public String getHash() {
        return this.hash;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getICCName(this.getProfile());
        }
        return this.name;
    }

    public void overwriteName(String value) {
        this.name = value;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.bytes != null) {
            sb.append(this.getName());
            sb.append(", ");
            sb.append(this.getHash());
        }
        return sb.toString();
    }

    private String getICCHash() {
        String hashing = null;
        if (this.bytes != null) {
            CRC32 crc = new CRC32();
            crc.update(this.bytes);
            Long digest = crc.getValue();
            hashing = digest.toString();
        }
        return hashing;
    }

    private String getICCName(ICC_Profile icc) {
        byte[] tagBytes;
        String icc_name = null;
        if (icc != null && (tagBytes = icc.getData(1684370275)) != null) {
            if (icc.getMajorVersion() >= 4) {
                int len = ICCProfileWrap.getInt(tagBytes, 20);
                byte[] descRaw = new byte[len];
                int pos = ICCProfileWrap.getInt(tagBytes, 24);
                System.arraycopy(tagBytes, pos, descRaw, 0, len);
                icc_name = new String(descRaw, FileOperations.charsetUTF16BE).trim();
            } else {
                int l;
                for (l = ICCProfileWrap.getInt(tagBytes, 8); tagBytes[12 + l - 1] == 0 && l >= 0; --l) {
                }
                if (l > 0) {
                    icc_name = new String(tagBytes, 12, l).trim();
                }
            }
        }
        return icc_name;
    }

    private static int getInt(byte[] tagBytes, int i) {
        int j = 0;
        for (int k = 0; k <= 3; ++k) {
            j = j << 8 | 0xFF & tagBytes[k + i];
        }
        return j;
    }
}

