/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ICC_ProfileRGBExt {
    public static final int REDCOMPONENT = 0;
    public static final int GREENCOMPONENT = 1;
    public static final int BLUECOMPONENT = 2;
    private final transient float[][] matrix;
    private transient float gamma = 0.0f;
    private final transient float[] whitePoint;
    private final transient float[] blackPoint;
    private final ICC_Profile iccProfile;

    public ICC_ProfileRGBExt(ICC_Profile icc) {
        this.iccProfile = icc;
        this.matrix = this.createMatrix();
        this.whitePoint = this.getXYZData(0x77747074);
        this.blackPoint = this.getXYZData(1651208308);
    }

    public ICC_ProfileRGBExt(byte[] data) {
        this(ICC_Profile.getInstance(data));
    }

    public ICC_Profile getICCProfile() {
        return this.iccProfile;
    }

    public float[] getMediaWhitePoint() {
        float[] wp = new float[]{this.whitePoint[0], this.whitePoint[1], this.whitePoint[2]};
        return wp;
    }

    public float[][] getMatrix() {
        float[][] mat;
        if (this.matrix != null) {
            mat = new float[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    mat[i][j] = this.matrix[i][j];
                }
            }
        } else {
            mat = null;
        }
        return mat;
    }

    public float getGamma(int component) {
        short[] data;
        if (this.gamma != 0.0f) {
            return this.gamma;
        }
        switch (component) {
            case 0: {
                data = this.getCurve(1918128707);
                break;
            }
            case 1: {
                data = this.getCurve(1733579331);
                break;
            }
            case 2: {
                data = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (data == null) {
            throw new ProfileDataException("No TRC");
        }
        if (data.length != 1) {
            throw new ProfileDataException("Not a single-gamma TRC: " + data.length);
        }
        float gammaX = (data[0] & 0xFF00) >> 8;
        double fraction = (double)(data[0] & 0xFF) / 256.0;
        this.gamma = gammaX + (float)fraction;
        return this.gamma;
    }

    public short[] getTRC(int component) {
        short[] data;
        switch (component) {
            case 0: {
                data = this.getCurve(1918128707);
                break;
            }
            case 1: {
                data = this.getCurve(1733579331);
                break;
            }
            case 2: {
                data = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (data == null) {
            throw new ProfileDataException("Error reading TRC");
        }
        if (data.length <= 1) {
            throw new ProfileDataException("Gamma value, not a TRC table.");
        }
        return data;
    }

    private float[][] createMatrix() throws IllegalArgumentException {
        float[][] mat = null;
        float[] r = this.getXYZData(1918392666);
        float[] g = this.getXYZData(1733843290);
        float[] b = this.getXYZData(1649957210);
        if (r != null && g != null && b != null) {
            mat = new float[3][3];
            for (int i = 0; i < 3; ++i) {
                mat[i][0] = r[i];
                mat[i][1] = g[i];
                mat[i][2] = b[i];
            }
        }
        return mat;
    }

    private float[] getXYZData(int signature) {
        byte[] data = this.iccProfile.getData(signature);
        if (data == null) {
            return null;
        }
        ByteArrayWalker buf = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
        if (buf.getInt(0) != 1482250784) {
            return null;
        }
        float[] point = new float[]{(float)buf.getInt(8) / 65536.0f, (float)buf.getInt(12) / 65536.0f, (float)buf.getInt(16) / 65536.0f};
        return point;
    }

    private short[] getCurve(int signature) {
        byte[] data = this.iccProfile.getData(signature);
        if (data == null) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (buf.getInt(0) != 1668641398) {
            return null;
        }
        int count = buf.getInt(8);
        if (count == 0) {
            short[] curve = new short[]{256};
            return curve;
        }
        if (count == 1) {
            short[] curve = new short[]{buf.getShort(12)};
            return curve;
        }
        short[] curve = new short[count];
        for (int i = 0; i < count; ++i) {
            curve[i] = buf.getShort(12 + i * 2);
        }
        return curve;
    }

    public String toString() {
        return this.iccProfile.toString();
    }
}

