/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import java.awt.color.ColorSpace;

public final class LinearCMYKConverter
extends ColorSpaceConverter {
    private final ColorSpace csRGB = ColorSpace.getInstance(1000);
    private static final double power1 = 0.4166666666666667;

    public LinearCMYKConverter() {
        super(null);
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        float[] xyz = this.csRGB.toCIEXYZ(LinearCMYKConverter.toRGB(in));
        out[0] = xyz[0];
        out[1] = xyz[1];
        out[2] = xyz[2];
    }

    @Override
    public void toCIEXYZ(float i0, float i1, float i2, float[] out) {
        this.toCIEXYZ(new float[]{i0, i1, i2}, out);
    }

    @Override
    public void fromCIEXYZ(float x, float y, float z, float[] out) {
        float Y;
        float M;
        float C = LinearCMYKConverter.calcCIE1(x);
        float K = Math.min(C, Math.min(M = LinearCMYKConverter.calcCIE1(y), Y = LinearCMYKConverter.calcCIE1(z)));
        if (K != 1.0f) {
            float K1 = 1.0f - K;
            C = (C - K) / K1;
            M = (M - K) / K1;
            Y = (Y - K) / K1;
        } else {
            Y = 0.0f;
            M = 0.0f;
            C = 0.0f;
        }
        out[0] = C;
        out[1] = M;
        out[2] = Y;
        out[3] = K;
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        this.fromCIEXYZ(in[0], in[1], in[2], out);
    }

    private static float calcCIE1(float in) {
        in = in < 0.040449936f ? (in /= 12.92f) : (float)Math.pow(((double)in + 0.055) / 1.055, 2.4);
        return 1.0f - in;
    }

    private static float[] toRGB(float[] colorvalue) {
        float C = colorvalue[0];
        float M = colorvalue[1];
        float Y = colorvalue[2];
        float K = colorvalue[3];
        float K1 = 1.0f - K;
        float[] rgbvalue = new float[]{K1 * (1.0f - C), K1 * (1.0f - M), K1 * (1.0f - Y)};
        for (int i = 0; i < 3; ++i) {
            float v = rgbvalue[i];
            if (v < 0.0f) {
                v = 0.0f;
            }
            if (v < 0.0031308f) {
                rgbvalue[i] = 12.92f * v;
                continue;
            }
            if (v > 1.0f) {
                v = 1.0f;
            }
            rgbvalue[i] = (float)(1.055 * Math.pow(v, 0.4166666666666667) - 0.055);
        }
        return rgbvalue;
    }
}

