/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import sun.java2d.cmm.CMSManager;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;

public final class NewProfileConverter
extends ColorSpaceConverter {
    private final ICC_Profile profile;
    private ICC_ColorSpace iccColorSpace;
    private transient float[] whitePoint;
    private transient float[] blackPoint;
    private final float Xd50 = 0.9642f;
    private final float Yd50 = 1.0f;
    private final float Zd50 = 0.8249f;
    public float[][] Mi = new float[][]{{3.2406f, -1.5372f, -0.4986f}, {-0.9689f, 1.8758f, 0.0415f}, {0.0557f, -0.204f, 1.057f}};
    private boolean needScaleInit = true;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private final float factor;
    private ColorTransform xyz2this;

    public NewProfileConverter(ColorLookUpTableCache clutCache, ICCProfileWrap ipw, ProfileDirection pdir) {
        super(ipw);
        float ALMOST_TWO = 1.9999695f;
        this.factor = 65535.0f / ALMOST_TWO;
        this.profile = ipw.getProfile();
        if (this.profile != null) {
            this.iccColorSpace = new ICC_ColorSpace(this.profile);
            this.whitePoint = NewProfileConverter.getXYZData(this.profile, 0x77747074);
            this.blackPoint = NewProfileConverter.getXYZData(this.profile, 1651208308);
            ColorTransform[] transformList = new ColorTransform[2];
            ICC_ColorSpace xyzCS = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            PCMM mdl = CMSManager.getModule();
            transformList[0] = mdl.createTransform(xyzCS.getProfile(), -1, 1);
            try {
                transformList[1] = mdl.createTransform(this.profile, 1, 2);
            }
            catch (CMMException e) {
                transformList[1] = CMSManager.getModule().createTransform(this.profile, -1, 2);
            }
            this.xyz2this = mdl.createTransform(transformList);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
            float[] test = new float[this.profile.getNumComponents()];
            try {
                this.iccColorSpace.toCIEXYZ(test);
            }
            catch (Exception e) {
                this.error = true;
            }
        } else {
            this.error = true;
        }
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        float[] xyz = this.iccColorSpace.toCIEXYZ(in);
        out[0] = xyz[0];
        out[1] = xyz[1];
        out[2] = xyz[2];
    }

    @Override
    public void toCIEXYZ(float i0, float i1, float i2, float[] out) {
        float[] rgb = new float[]{i0, i1, i2};
        float[] xyz = this.iccColorSpace.toCIEXYZ(rgb);
        out[0] = xyz[0] * 0.90454155f;
        out[1] = xyz[1] * 0.91799164f;
        out[2] = xyz[2] * 1.2109534f;
    }

    public float[] fromCIEXYZ(float[] colorvalue) {
        short[] tmp = new short[3];
        for (int i = 0; i < 3; ++i) {
            tmp[i] = (short)(colorvalue[i] * this.factor + 0.5f);
        }
        tmp = this.xyz2this.colorConvert(tmp, null);
        int nc = this.iccColorSpace.getNumComponents();
        float[] result = new float[nc];
        for (int i = 0; i < nc; ++i) {
            result[i] = (float)(tmp[i] & 0xFFFF) / 65535.0f * this.diffMinMax[i] + this.minVal[i];
        }
        return result;
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        float[] xyz = new float[]{this.whitePointD65[0] * in[0], this.whitePointD65[1] * in[1], this.whitePointD65[2] * in[2]};
        float[] o = this.XYZtoRGBDirect(xyz);
        out[0] = o[0];
        out[1] = o[1];
        out[2] = o[2];
    }

    public float[] XYZtoRGBDirect(float[] in) {
        float x = in[0];
        float y = in[1];
        float z = in[2];
        float r = x * this.Mi[0][0] + y * this.Mi[0][1] + z * this.Mi[0][2];
        float g = x * this.Mi[1][0] + y * this.Mi[1][1] + z * this.Mi[1][2];
        float b = x * this.Mi[2][0] + y * this.Mi[2][1] + z * this.Mi[2][2];
        r = r < 0.0f ? 0.0f : r;
        g = g < 0.0f ? 0.0f : g;
        b = b < 0.0f ? 0.0f : b;
        r = r > 1.0f ? 1.0f : r;
        g = g > 1.0f ? 1.0f : g;
        b = b > 1.0f ? 1.0f : b;
        return new float[]{r, g, b};
    }

    public float[] XYZtoRGB(float[] in) {
        float x = in[0];
        float y = in[1];
        float z = in[2];
        float r = x * this.Mi[0][0] + y * this.Mi[0][1] + z * this.Mi[0][2];
        float g = x * this.Mi[1][0] + y * this.Mi[1][1] + z * this.Mi[1][2];
        float b = x * this.Mi[2][0] + y * this.Mi[2][1] + z * this.Mi[2][2];
        r = (double)r > 0.0031308 ? 1.055f * (float)Math.pow(r, 0.4166666666666667) - 0.055f : (r *= 12.92f);
        g = (double)g > 0.0031308 ? 1.055f * (float)Math.pow(g, 0.4166666666666667) - 0.055f : (g *= 12.92f);
        b = (double)b > 0.0031308 ? 1.055f * (float)Math.pow(b, 0.4166666666666667) - 0.055f : (b *= 12.92f);
        r = r < 0.0f ? 0.0f : r;
        g = g < 0.0f ? 0.0f : g;
        b = b < 0.0f ? 0.0f : b;
        r = r > 1.0f ? 1.0f : r;
        g = g > 1.0f ? 1.0f : g;
        b = b > 1.0f ? 1.0f : b;
        return new float[]{r, g, b};
    }

    @Override
    public void fromCIEXYZ(float x, float y, float z, float[] out) {
        float[] o = this.iccColorSpace.fromCIEXYZ(new float[]{x, y, z});
        out[0] = o[0];
        out[1] = o[1];
        out[2] = o[2];
    }

    private void setComponentScaling() {
        int nc = this.iccColorSpace.getNumComponents();
        this.diffMinMax = new float[nc];
        this.invDiffMinMax = new float[nc];
        for (int i = 0; i < nc; ++i) {
            this.minVal[i] = this.getMinValue(i);
            this.maxVal[i] = this.getMaxValue(i);
            this.diffMinMax[i] = this.maxVal[i] - this.minVal[i];
            this.invDiffMinMax[i] = 65535.0f / this.diffMinMax[i];
        }
        this.needScaleInit = false;
    }

    private float getMinValue(int component) {
        if (component < 0 || component > this.iccColorSpace.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.minVal[component];
    }

    private float getMaxValue(int component) {
        if (component < 0 || component > this.iccColorSpace.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.maxVal[component];
    }
}

