/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;

public final class OriginProfileConverter
extends ColorSpaceConverter {
    private ICC_ColorSpace iccColorSpace;
    private transient float[] whitePoint;
    private transient float[] blackPoint;

    public OriginProfileConverter(ColorLookUpTableCache clutCache, ICCProfileWrap ipw, ProfileDirection pdir) {
        super(ipw);
        ICC_Profile profile = ipw.getProfile();
        if (profile != null) {
            this.iccColorSpace = new ICC_ColorSpace(profile);
            this.whitePoint = OriginProfileConverter.getXYZData(profile, 0x77747074);
            this.blackPoint = OriginProfileConverter.getXYZData(profile, 1651208308);
            float[] test = new float[profile.getNumComponents()];
            try {
                this.iccColorSpace.toCIEXYZ(test);
            }
            catch (Exception e) {
                this.error = true;
            }
        } else {
            this.error = true;
        }
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        float[] xyz = this.iccColorSpace.toCIEXYZ(in);
        out[0] = xyz[0];
        out[1] = xyz[1];
        out[2] = xyz[2];
    }

    @Override
    public void toCIEXYZ(float i0, float i1, float i2, float[] out) {
        float[] rgb = new float[]{i0, i1, i2};
        float[] xyz = this.iccColorSpace.toCIEXYZ(rgb);
        out[0] = xyz[0];
        out[1] = xyz[1];
        out[2] = xyz[2];
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        float[] o = this.iccColorSpace.fromCIEXYZ(in);
        out[0] = o[0];
        out[1] = o[1];
        out[2] = o[2];
    }

    @Override
    public void fromCIEXYZ(float x, float y, float z, float[] out) {
        float[] o = this.iccColorSpace.fromCIEXYZ(new float[]{x, y, z});
        out[0] = o[0];
        out[1] = o[1];
        out[2] = o[2];
    }
}

