/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorCache;
import java.util.Arrays;

public final class RGBColorCache256k
extends ColorCache {
    private final long[] rgbCache = new long[262144];

    public RGBColorCache256k() {
        this.flush();
    }

    @Override
    public int get(long color) {
        int cacheKey = (int)(color & 0x3F0000L) >> 4 | (int)(color & 0x3F00L) >> 2 | (int)(color & 0x3FL);
        long cacheContent = this.rgbCache[cacheKey];
        ++this.requests;
        if (cacheContent != -1L && (cacheContent & 0xFFFFFFL) == (color & 0xFFFFFFL)) {
            if (this.hits++ % 100000L == 0L) {
                this.refresh();
            }
            return (int)(cacheContent >> 32);
        }
        return -1;
    }

    @Override
    public int get(int r, int g, int b) {
        int cacheKey = (r & 0x3F) << 12 | (g & 0x3F) << 6 | b & 0x3F;
        long cacheContent = this.rgbCache[cacheKey];
        ++this.requests;
        if (cacheContent != -1L && (cacheContent & 0xFFFFFFL) == (long)(r << 16 | g << 8 | b)) {
            if (this.hits++ % 100000L == 0L) {
                this.refresh();
            }
            return (int)(cacheContent >> 32);
        }
        return -1;
    }

    @Override
    public void put(long color, int rgb) {
        int cacheKey = (int)(color & 0x3F0000L) >> 4 | (int)(color & 0x3F00L) >> 2 | (int)(color & 0x3FL);
        this.rgbCache[cacheKey] = (long)(rgb << 32) | color & 0xFFFFFFL;
    }

    @Override
    public void put(int r, int g, int b, int rgb) {
        int cacheKey = (r & 0x3F) << 12 | (g & 0x3F) << 6 | b & 0x3F;
        this.rgbCache[cacheKey] = (long)rgb << 32 | (long)(r << 16) | (long)(g << 8) | (long)b;
    }

    @Override
    public void flush() {
        Arrays.fill(this.rgbCache, -1L);
    }
}

