/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ColorLookUpTable;
import com.neptunelabs.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.imagereader.converter.ColorSpaceConverter;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.converter.ICC_ProfileRGBExt;
import com.neptunelabs.imagereader.converter.ProfileDirection;
import com.neptunelabs.imagereader.converter.ToneReproduction;
import com.neptunelabs.imagereader.converter.ToneReproductionCurve;
import com.neptunelabs.imagereader.converter.ToneReproductionGamma;
import java.awt.color.ProfileDataException;

public final class RgbProfileConverter
extends ColorSpaceConverter {
    private final ICC_ProfileRGBExt profile;
    private final float m00;
    private final float m01;
    private final float m02;
    private final float m10;
    private final float m11;
    private final float m12;
    private final float m20;
    private final float m21;
    private final float m22;
    private final float im00;
    private final float im01;
    private final float im02;
    private final float im10;
    private final float im11;
    private final float im12;
    private final float im20;
    private final float im21;
    private final float im22;
    private ToneReproduction rTRC;
    private ToneReproduction gTRC;
    private ToneReproduction bTRC;
    private ColorLookUpTable toPCS;
    private ColorLookUpTable fromPCS;

    public RgbProfileConverter(ColorLookUpTableCache clutCache, ICCProfileWrap ipw, ProfileDirection pdir) {
        super(ipw);
        float[][] matrix = null;
        float[][] inv_matrix = null;
        this.profile = ipw.getRGBProfile();
        if (this.profile == null) {
            this.error = true;
        } else {
            this.fromPCS = null;
            this.toPCS = null;
            matrix = this.profile.getMatrix();
            try {
                this.rTRC = new ToneReproductionGamma(this.profile.getGamma(0));
            }
            catch (ProfileDataException e) {
                try {
                    this.rTRC = new ToneReproductionCurve(this.profile.getTRC(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.gTRC = new ToneReproductionGamma(this.profile.getGamma(1));
            }
            catch (ProfileDataException e) {
                try {
                    this.gTRC = new ToneReproductionCurve(this.profile.getTRC(1));
                }
                catch (ProfileDataException profileDataException) {
                    // empty catch block
                }
            }
            try {
                this.bTRC = new ToneReproductionGamma(this.profile.getGamma(2));
            }
            catch (ProfileDataException e) {
                try {
                    this.bTRC = new ToneReproductionCurve(this.profile.getTRC(2));
                }
                catch (ProfileDataException profileDataException) {
                    // empty catch block
                }
            }
            try {
                this.toPCS = clutCache.get(ipw.getHash(), this.profile.getICCProfile(), 1093812784);
            }
            catch (Exception e) {
                this.toPCS = null;
            }
            try {
                this.fromPCS = clutCache.get(ipw.getHash(), this.profile.getICCProfile(), 1110589744);
            }
            catch (Exception e) {
                this.fromPCS = null;
            }
            if (matrix != null) {
                if (this.fromPCS == null) {
                    try {
                        inv_matrix = RgbProfileConverter.invertMatrix(matrix);
                    }
                    catch (IllegalArgumentException e) {
                        inv_matrix = null;
                    }
                } else {
                    inv_matrix = new float[3][3];
                    inv_matrix[2][2] = 1.0f;
                    inv_matrix[1][1] = 1.0f;
                    inv_matrix[0][0] = 1.0f;
                }
            }
            if (matrix != null || this.fromPCS == null || this.toPCS == null) {
                // empty if block
            }
            if (pdir == ProfileDirection.Input) {
                this.setToWhitePoint(this.profile, this.fromPCS, this.toPCS);
            } else {
                this.setFromWhitePoint(this.profile, this.fromPCS, this.toPCS);
            }
            if (this.rTRC == null && this.toPCS == null) {
                this.error = true;
            }
        }
        if (matrix != null) {
            this.m00 = matrix[0][0];
            this.m01 = matrix[0][1];
            this.m02 = matrix[0][2];
            this.m10 = matrix[1][0];
            this.m11 = matrix[1][1];
            this.m12 = matrix[1][2];
            this.m20 = matrix[2][0];
            this.m21 = matrix[2][1];
            this.m22 = matrix[2][2];
        } else {
            this.m00 = 0.0f;
            this.m01 = 0.0f;
            this.m02 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = 0.0f;
            this.m12 = 0.0f;
            this.m20 = 0.0f;
            this.m21 = 0.0f;
            this.m22 = 0.0f;
        }
        if (inv_matrix != null) {
            this.im00 = inv_matrix[0][0];
            this.im01 = inv_matrix[0][1];
            this.im02 = inv_matrix[0][2];
            this.im10 = inv_matrix[1][0];
            this.im11 = inv_matrix[1][1];
            this.im12 = inv_matrix[1][2];
            this.im20 = inv_matrix[2][0];
            this.im21 = inv_matrix[2][1];
            this.im22 = inv_matrix[2][2];
        } else {
            this.im00 = 1.0f;
            this.im01 = 0.0f;
            this.im02 = 0.0f;
            this.im10 = 1.0f;
            this.im11 = 0.0f;
            this.im12 = 0.0f;
            this.im20 = 1.0f;
            this.im21 = 0.0f;
            this.im22 = 0.0f;
        }
    }

    @Override
    public void toCIEXYZ(float[] in, float[] out) {
        this.toCIEXYZ(in[0], in[1], in[2], out);
    }

    @Override
    public void toCIEXYZ(float in0, float in1, float in2, float[] out) {
        if (this.toPCS != null) {
            this.toPCS.lookup(in0, in1, in2, out);
            return;
        }
        float t0 = this.rTRC.lookup(in0);
        float t1 = this.gTRC.lookup(in1);
        float t2 = this.bTRC.lookup(in2);
        out[0] = this.m00 * t0 + this.m01 * t1 + this.m02 * t2;
        out[1] = this.m10 * t0 + this.m11 * t1 + this.m12 * t2;
        out[2] = this.m20 * t0 + this.m21 * t1 + this.m22 * t2;
    }

    @Override
    public void fromCIEXYZ(float[] in, float[] out) {
        if (this.fromPCS != null) {
            this.fromPCS.lookup(in, out);
            return;
        }
        float in0 = in[0];
        float in1 = in[1];
        float in2 = in[2];
        out[0] = this.rTRC.reverseLookup(this.im00 * in0 + this.im01 * in1 + this.im02 * in2);
        out[1] = this.gTRC.reverseLookup(this.im10 * in0 + this.im11 * in1 + this.im12 * in2);
        out[2] = this.bTRC.reverseLookup(this.im20 * in0 + this.im21 * in1 + this.im22 * in2);
    }

    @Override
    public void fromCIEXYZ(float in0, float in1, float in2, float[] out) {
        if (this.fromPCS != null) {
            this.fromPCS.lookup(in0, in1, in2, out);
            return;
        }
        out[0] = this.rTRC.reverseLookup(this.im00 * in0 + this.im01 * in1 + this.im02 * in2);
        out[1] = this.gTRC.reverseLookup(this.im10 * in0 + this.im11 * in1 + this.im12 * in2);
        out[2] = this.bTRC.reverseLookup(this.im20 * in0 + this.im21 * in1 + this.im22 * in2);
    }

    private static float[][] invertMatrix(float[][] matrixValue) {
        float[][] out = new float[3][3];
        double determinant = matrixValue[0][0] * (matrixValue[1][1] * matrixValue[2][2] - matrixValue[2][1] * matrixValue[1][2]) - matrixValue[0][1] * (matrixValue[1][0] * matrixValue[2][2] - matrixValue[2][0] * matrixValue[1][2]) + matrixValue[0][2] * (matrixValue[1][0] * matrixValue[2][1] - matrixValue[2][0] * matrixValue[1][1]);
        if (determinant == 0.0) {
            throw new IllegalArgumentException("Can't invert conversion matrix.");
        }
        float invdet = (float)(1.0 / determinant);
        out[0][0] = invdet * (matrixValue[1][1] * matrixValue[2][2] - matrixValue[1][2] * matrixValue[2][1]);
        out[0][1] = invdet * (matrixValue[0][2] * matrixValue[2][1] - matrixValue[0][1] * matrixValue[2][2]);
        out[0][2] = invdet * (matrixValue[0][1] * matrixValue[1][2] - matrixValue[0][2] * matrixValue[1][1]);
        out[1][0] = invdet * (matrixValue[1][2] * matrixValue[2][0] - matrixValue[1][0] * matrixValue[2][2]);
        out[1][1] = invdet * (matrixValue[0][0] * matrixValue[2][2] - matrixValue[0][2] * matrixValue[2][0]);
        out[1][2] = invdet * (matrixValue[0][2] * matrixValue[1][0] - matrixValue[0][0] * matrixValue[1][2]);
        out[2][0] = invdet * (matrixValue[1][0] * matrixValue[2][1] - matrixValue[1][1] * matrixValue[2][0]);
        out[2][1] = invdet * (matrixValue[0][1] * matrixValue[2][0] - matrixValue[0][0] * matrixValue[2][1]);
        out[2][2] = invdet * (matrixValue[0][0] * matrixValue[1][1] - matrixValue[0][1] * matrixValue[1][0]);
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ipw.getName());
        sb.append(';');
        sb.append("ICC:" + this.profile.toString());
        return sb.toString();
    }
}

