/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.ToneReproduction;

final class ToneReproductionCurve
extends ToneReproduction {
    private final float[] trc;
    private final float[] reverseTrc;

    public ToneReproductionCurve(float[] trcValues) {
        this.trc = new float[trcValues.length];
        System.arraycopy(trcValues, 0, this.trc, 0, trcValues.length);
        this.reverseTrc = this.setupReverseTrc();
    }

    public ToneReproductionCurve(short[] trcValues) {
        this.trc = new float[trcValues.length];
        for (int i = 0; i < trcValues.length; ++i) {
            this.trc[i] = (float)(trcValues[i] & 0xFFFF) / 65535.0f;
        }
        this.reverseTrc = this.setupReverseTrc();
    }

    @Override
    public float lookup(float in) {
        float alpha = in * (float)(this.trc.length - 1);
        int index = (int)alpha;
        alpha -= (float)index;
        if (index >= this.trc.length - 1) {
            return this.trc[this.trc.length - 1];
        }
        if (index <= 0) {
            return this.trc[0];
        }
        return (float)((double)this.trc[index] * (1.0 - (double)alpha) + (double)(this.trc[index + 1] * alpha));
    }

    @Override
    public float reverseLookup(float in) {
        float alpha = in * (float)(this.reverseTrc.length - 1);
        int index = (int)alpha;
        alpha -= (float)index;
        if (index >= this.reverseTrc.length - 1) {
            return this.reverseTrc[this.reverseTrc.length - 1];
        }
        if (index <= 0) {
            return this.reverseTrc[0];
        }
        return this.reverseTrc[index] * (1.0f - alpha) + this.reverseTrc[index + 1] * alpha;
    }

    private float[] setupReverseTrc() {
        float[] reverseTrcNew = new float[10000];
        int j = 0;
        for (int i = 0; i < 10000; ++i) {
            float n = (float)i / 10000.0f;
            while (this.trc[j + 1] < n && j < this.trc.length - 2) {
                ++j;
            }
            reverseTrcNew[i] = j == this.trc.length - 2 ? this.trc[this.trc.length - 1] : ((float)j + (n - this.trc[j]) / (this.trc[j + 1] - this.trc[j])) / (float)this.trc.length;
        }
        return reverseTrcNew;
    }
}

