/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.converter;

import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.converter.ToneReproduction;

final class ToneReproductionGamma
extends ToneReproduction {
    private final float gamma;

    public ToneReproductionGamma(float gamma) {
        this.gamma = gamma;
    }

    @Override
    public float lookup(float in) {
        if (in == 0.0f) {
            return 0.0f;
        }
        return (float)FastMath.exp((double)this.gamma * Math.log(in));
    }

    @Override
    public float reverseLookup(float in) {
        if (in == 0.0f) {
            return 0.0f;
        }
        return (float)FastMath.exp(1.0 / (double)this.gamma * Math.log(in));
    }
}

