/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.exif;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.imagereader.exif.ExifIDFRawTag;
import com.neptunelabs.imagereader.helper.Rational;
import java.io.IOException;
import java.util.ArrayList;

public final class ExifBuilder {
    private final ArrayList<PreTag> binBlock = new ArrayList();

    public byte[] evaluate() throws IOException {
        int entryCount = this.binBlock.size();
        int binLength = entryCount * 12;
        int binAddOffset = binLength + 10;
        ByteArrayOutputStreamFast binAdd = new ByteArrayOutputStreamFast(binLength);
        byte[] preBin = new byte[binLength];
        int binOffset = 0;
        for (PreTag tag : this.binBlock) {
            System.arraycopy(tag.binPrepare, 0, preBin, binOffset, tag.binPrepare.length);
            binOffset += tag.binPrepare.length;
            if (tag.rawdata == null) continue;
            preBin[binOffset - 4] = (byte)(binAddOffset >> 24 & 0xFF);
            preBin[binOffset - 3] = (byte)(binAddOffset >> 16 & 0xFF);
            preBin[binOffset - 2] = (byte)(binAddOffset >> 8 & 0xFF);
            preBin[binOffset - 1] = (byte)(binAddOffset & 0xFF);
            if (tag.rawdata instanceof String) {
                String str = (String)tag.rawdata;
                byte[] strbytes = str.getBytes(FileOperations.charsetASCII);
                binAdd.write(strbytes);
                binAdd.write(0);
                int totalLen = strbytes.length + 1;
                binAddOffset += totalLen;
                continue;
            }
            if (tag.rawdata instanceof Long && (tag.entry.tagtype == 12 || tag.entry.tagtype == 4 || tag.entry.tagtype == 9)) {
                Long l = (Long)tag.rawdata;
                byte[] longbytes = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
                binAdd.write(longbytes);
                binAddOffset += longbytes.length;
                continue;
            }
            if (tag.rawdata instanceof Rational) {
                byte[] ratbytes = new byte[8];
                Rational rat = (Rational)tag.rawdata;
                ratbytes[0] = (byte)(rat.numerator >> 24 & 0xFFL);
                ratbytes[1] = (byte)(rat.numerator >> 16 & 0xFFL);
                ratbytes[2] = (byte)(rat.numerator >> 8 & 0xFFL);
                ratbytes[3] = (byte)(rat.numerator & 0xFFL);
                ratbytes[4] = (byte)(rat.denominator >> 24 & 0xFFL);
                ratbytes[5] = (byte)(rat.denominator >> 16 & 0xFFL);
                ratbytes[6] = (byte)(rat.denominator >> 8 & 0xFFL);
                ratbytes[7] = (byte)(rat.denominator & 0xFFL);
                binAdd.write(ratbytes);
                binAddOffset += ratbytes.length;
                continue;
            }
            if (!(tag.rawdata instanceof byte[])) continue;
            byte[] bytes = (byte[])tag.rawdata;
            binAdd.write(bytes);
            binAddOffset += bytes.length;
        }
        binAdd.close();
        byte[] binAddBytes = binAdd.toByteArray();
        byte[] header = new byte[]{77, 77, 0, 42};
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(7 + header.length + preBin.length + binAddBytes.length);){
            baos.write(header);
            baos.write(0);
            baos.write(0);
            baos.write(0);
            baos.write(8);
            baos.write((byte)(entryCount >> 8 & 0xFF));
            baos.write((byte)(entryCount & 0xFF));
            baos.write(preBin);
            baos.write(binAddBytes);
            baos.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public void addTag(ExifIDFRawTag entry, Object rawdata) {
        PreTag preTag = new PreTag();
        preTag.entry = entry;
        int offset = 0;
        boolean forbidoffsetcalc = false;
        preTag.binPrepare = new byte[12];
        preTag.binPrepare[offset] = (byte)(entry.tagname >> 8 & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagname & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagtype >> 8 & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagtype & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagvaluecount >> 24 & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagvaluecount >> 16 & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagvaluecount >> 8 & 0xFF);
        preTag.binPrepare[++offset] = (byte)(entry.tagvaluecount & 0xFF);
        if (entry.tagvaluecount == 1 && entry.tagtype == 3) {
            preTag.binPrepare[++offset] = (byte)(entry.tagvalueoffset >> 8 & 0xFFL);
            preTag.binPrepare[++offset] = (byte)(entry.tagvalueoffset & 0xFFL);
            preTag.binPrepare[++offset] = 0;
            preTag.binPrepare[++offset] = 0;
        } else {
            if ((entry.tagtype == 2 || entry.tagtype == 1) && entry.tagvaluecount <= 4) {
                forbidoffsetcalc = true;
            }
            preTag.binPrepare[++offset] = (byte)(entry.tagvalueoffset >> 24 & 0xFFL);
            preTag.binPrepare[++offset] = (byte)(entry.tagvalueoffset >> 16 & 0xFFL);
            preTag.binPrepare[++offset] = (byte)(entry.tagvalueoffset >> 8 & 0xFFL);
            preTag.binPrepare[++offset] = (byte)(entry.tagvalueoffset & 0xFFL);
        }
        if (!(forbidoffsetcalc || entry.tagvaluecount == 1 && rawdata == null)) {
            preTag.rawdata = rawdata;
        }
        this.binBlock.add(preTag);
    }

    public int size() {
        return this.binBlock.size();
    }

    private class PreTag {
        byte[] binPrepare;
        ExifIDFRawTag entry;
        Object rawdata;
    }
}

