/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.exif;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.exif.Directory;
import com.neptunelabs.imagereader.exif.ExifIDFRawTag;
import com.neptunelabs.imagereader.exif.ExifTag;
import com.neptunelabs.imagereader.exif.ExifTagMapping;
import com.neptunelabs.imagereader.exif.ExifTagPriority;
import com.neptunelabs.imagereader.exif.ExifValueType;
import com.neptunelabs.imagereader.helper.Rational;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExifParser {
    private static final int[] BYTES_PER_TAGTYPE = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final byte[] UNDEF_DESIGNATION_ASCII = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    private static final byte[] UNDEF_DESIGNATION_UNICODE = new byte[]{85, 78, 73, 67, 79, 68, 69, 0};
    boolean littleendian = false;
    private FSILogger fsilogger = null;
    private boolean error = false;
    private ByteArrayWalker bois;
    private String name = null;
    private final LinkedList<Directory> idf = new LinkedList();
    private final List<ExifTag> exifTags = new ArrayList<ExifTag>();
    private final ExifTagMapping tagMapper = ExifTagMapping.getInstance();
    private final ExifTagPriority tagSortMap = ExifTagPriority.getInstance();
    private final DecimalFormat df2f = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US));

    private ExifParser(FSILogger logger) {
        this.fsilogger = logger;
    }

    public static ExifParser getInstance(FSILogger logger) {
        return new ExifParser(logger);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void scanExif(byte[] exifData) {
        block7: {
            if (!this.error) {
                try {
                    ByteOrder bo = this.parseHeader(exifData);
                    if (this.error || bo == null) break block7;
                    this.bois = ByteArrayWalker.wrap(exifData, bo);
                    this.bois.position(4);
                    int idfOffset = this.bois.getInt();
                    Directory d = new Directory(34665, idfOffset);
                    boolean hasMoreIFDs = true;
                    while (!this.error && hasMoreIFDs) {
                        if (idfOffset >= 8) {
                            this.scanIFD(d);
                        }
                        hasMoreIFDs = !this.idf.isEmpty();
                        Directory nextDirectory = this.idf.poll();
                        if (nextDirectory != null) {
                            d = nextDirectory;
                            continue;
                        }
                        break;
                    }
                }
                catch (RuntimeException e) {
                    if (this.fsilogger != null) {
                        this.fsilogger.logException(e, 3830, e.getClass().getName() + ": " + e.getLocalizedMessage(), this.name);
                    }
                    this.error = true;
                }
            }
        }
        this.close();
    }

    public List<ExifTag> getExifTags() {
        return this.exifTags;
    }

    public List<Integer> getTagSortMap() {
        return this.tagSortMap.getList();
    }

    public Map<Pair<Integer, String>, String> getShortMap() {
        HashMap<Pair<Integer, String>, String> result = new HashMap<Pair<Integer, String>, String>();
        for (ExifTag tag : this.exifTags) {
            result.put(new Pair<Integer, String>(tag.getTag(), tag.getShortDescription()), tag.getValueAsText());
        }
        return result;
    }

    public ExifTag getTag(int tagId) {
        ExifTag result = null;
        if (this.exifTags != null) {
            for (ExifTag et : this.exifTags) {
                if (et.getTag() != tagId) continue;
                result = et;
                break;
            }
        }
        return result;
    }

    private void close() {
        if (this.bois != null) {
            this.bois = null;
        }
    }

    private void evaluateExifTag(ExifIDFRawTag tag) throws UnsupportedEncodingException, IOException {
        switch (tag.tagname) {
            case 34665: 
            case 34853: 
            case 40965: {
                this.idf.offer(new Directory(tag.tagname, this.getTagValueLong(tag)[0]));
                break;
            }
            case 11: 
            case 270: 
            case 271: 
            case 272: 
            case 305: 
            case 306: 
            case 315: 
            case 33432: 
            case 34852: 
            case 36867: 
            case 36868: 
            case 37520: 
            case 37521: 
            case 37522: 
            case 42016: {
                this.readAndEvaluatePlainTextTag(34665, tag);
                break;
            }
            case 256: 
            case 257: 
            case 259: 
            case 277: 
            case 18246: 
            case 18249: 
            case 40962: 
            case 40963: 
            case 41989: {
                this.readAndEvaluatePlainNumberTag(34665, tag);
                break;
            }
            case 258: {
                this.readAndEvaluatePlainNumberListTag(34665, tag);
                break;
            }
            case 37122: 
            case 37378: 
            case 37379: 
            case 37381: 
            case 37386: 
            case 41483: 
            case 41493: 
            case 41988: {
                this.readAndEvaluateRationalAsDouble(34665, tag);
                break;
            }
            case 36864: 
            case 37510: 
            case 40960: 
            case 41730: {
                this.readAndEvaluateUndefinedTagAsString(34665, tag);
                break;
            }
            case 318: 
            case 319: 
            case 529: 
            case 532: {
                this.readAndEvaluateRationalsListAsDoubleArray(34665, tag);
                break;
            }
            case 284: {
                this.readAndEvaluatePlanarConfigurationTag(tag);
                break;
            }
            case 262: {
                this.readAndEvaluatePhotometricInterpretationTag(tag);
                break;
            }
            case 41728: {
                this.readAndEvaluateFileSourceTag(tag);
                break;
            }
            case 41729: {
                this.readAndEvaluateSceneTypeTag(tag);
                break;
            }
            case 282: 
            case 283: 
            case 41486: 
            case 41487: {
                this.readAndEvaluateResolutionTag(tag);
                break;
            }
            case 274: {
                this.readAndEvaluateOrientationTag(tag);
                break;
            }
            case 531: {
                this.readAndEvaluateYCbCrPositioningTag(tag);
                break;
            }
            case 296: 
            case 41488: {
                this.readAndEvaluateResolutionUnitTag(tag);
                break;
            }
            case 37380: {
                this.readAndEvaluateExposureBiasValueTag(tag);
                break;
            }
            case 33434: 
            case 37377: {
                this.readAndEvaluateShutterSpeedValueTag(tag);
                break;
            }
            case 34850: {
                this.readAndEvaluateExposureProgramTag(tag);
                break;
            }
            case 37382: {
                this.readAndEvaluateSubjectDistanceTag(tag);
                break;
            }
            case 33437: {
                this.readAndEvaluateFNumberTag(tag);
                break;
            }
            case 34855: {
                this.readAndEvaluateISOSpeedRatingsTag(tag);
                break;
            }
            case 37383: {
                this.readAndEvaluateMeteringModeTag(tag);
                break;
            }
            case 37384: {
                this.readAndEvaluateLightSourceTag(tag);
                break;
            }
            case 37385: {
                this.readAndEvaluateFlashTag(tag);
                break;
            }
            case 40961: {
                this.readAndEvaluateColorSpaceTag(tag);
                break;
            }
            case 41495: {
                this.readAndEvaluateSensingMethodTag(tag);
                break;
            }
            case 41985: {
                this.readAndEvaluateCustomRenderedTag(tag);
                break;
            }
            case 41986: {
                this.readAndEvaluateExposureModeTag(tag);
                break;
            }
            case 41987: {
                this.readAndEvaluateWhiteBalanceTag(tag);
                break;
            }
            case 41990: {
                this.readAndEvaluateScreenCaptureTypeTag(tag);
                break;
            }
            case 41991: {
                this.readAndEvaluateGainControlTag(tag);
                break;
            }
            case 41992: 
            case 41993: 
            case 41994: {
                this.readAndEvaluateNormalLowHighTag(tag);
                break;
            }
            case 41996: {
                this.readAndEvaluateSubjectDistanceRangeTag(tag);
                break;
            }
            case 37121: {
                this.readAndEvaluateComponentsConfigurationTag(tag);
                break;
            }
            default: {
                this.fsilogger.log(3835, "Skipping tag: " + tag.tagname + " (" + ExifTagMapping.getInstance().getShortName(34665, tag.tagname) + ") in " + this.name);
            }
        }
    }

    private void evaluateInterOpTag(ExifIDFRawTag tag) throws UnsupportedEncodingException, IOException {
        switch (tag.tagname) {
            case 1: 
            case 4096: {
                this.readAndEvaluatePlainTextTag(40965, tag);
                break;
            }
            case 2: {
                this.readAndEvaluateUndefinedTagAsString(40965, tag);
                break;
            }
            case 4097: 
            case 4098: {
                this.readAndEvaluatePlainNumberTag(40965, tag);
                break;
            }
            default: {
                this.fsilogger.log(3835, "Skipping tag: " + tag.tagname + " (" + ExifTagMapping.getInstance().getShortName(40965, tag.tagname) + ") in " + this.name);
            }
        }
    }

    private void evaluateGPSTag(ExifIDFRawTag tag) throws UnsupportedEncodingException, IOException {
        switch (tag.tagname) {
            case 8: 
            case 18: 
            case 29: {
                this.readAndEvaluatePlainTextTag(34853, tag);
                break;
            }
            case 1: {
                this.readAndEvaluateGPSLatitudeRefTag(tag);
                break;
            }
            case 3: {
                this.readAndEvaluateGPSLongitudeRefTag(tag);
                break;
            }
            case 5: {
                this.readAndEvaluateGPSAltitudeRefTag(tag);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                this.readAndEvaluateRationalsListAsDoubleArray(34853, tag);
                break;
            }
            case 9: {
                this.readAndEvaluateGPSStatusTag(tag);
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                this.readAndEvaluateRationalAsDouble(34853, tag);
                break;
            }
            case 10: {
                this.readAndEvaluateGPSMeasureModeTag(tag);
                break;
            }
            case 12: {
                this.readAndEvaluateGPSSpeedRefTag(tag);
                break;
            }
            case 14: 
            case 16: {
                this.readAndEvaluateGPSTrackRefTag(tag);
                break;
            }
            case 30: {
                this.readAndEvaluateGPSDifferentalTag(tag);
                break;
            }
            default: {
                this.fsilogger.log(3835, "Skipping tag: " + tag.tagname + " (" + ExifTagMapping.getInstance().getShortName(34853, tag.tagname) + ") in " + this.name);
            }
        }
    }

    private void readAndEvaluatePlainTextTag(int directoryType, ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String ascii = this.readPlainTextTag(tag);
        String tagShortDesc = this.tagMapper.getShortName(directoryType, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(directoryType, tag.tagname);
        if (ascii != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, ascii, null));
        } else {
            this.fsilogger.log(3835, "Unexpected content for String tag: tagname:" + tag.tagname + "(" + tagShortDesc + ") in " + this.name);
        }
    }

    private void readAndEvaluatePlainNumberTag(int directoryType, ExifIDFRawTag tag) {
        int value = -1;
        if (tag.tagtype == 3 || tag.tagtype == 8) {
            value = this.getTagValueShort(tag)[0];
        } else if (tag.tagtype == 4 || tag.tagtype == 9) {
            value = this.getTagValueLong(tag)[0];
        }
        String tagShortDesc = this.tagMapper.getShortName(directoryType, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(directoryType, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Number, value, value));
    }

    private void readAndEvaluatePlainNumberListTag(int directoryType, ExifIDFRawTag tag) {
        int[] value = null;
        if (tag.tagtype == 3 || tag.tagtype == 8) {
            value = this.getTagValueShort(tag);
        } else if (tag.tagtype == 4 || tag.tagtype == 9) {
            value = this.getTagValueLong(tag);
        }
        String tagShortDesc = this.tagMapper.getShortName(directoryType, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(directoryType, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.NumberList, value, value));
    }

    private void readAndEvaluateUndefinedTagAsString(int directoryType, ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String tagShortDesc = this.tagMapper.getShortName(directoryType, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(directoryType, tag.tagname);
        String str = this.readUndefinedTagAsString(tag);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, str));
        }
    }

    private void readAndEvaluateRationalAsDouble(int directoryType, ExifIDFRawTag tag) {
        Rational valueRational = this.getTagValueRational(tag);
        if (valueRational != null) {
            String tagShortDesc = this.tagMapper.getShortName(directoryType, tag.tagname);
            String tagLongDesc = this.tagMapper.getLongName(directoryType, tag.tagname);
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Rational, ExifParser.convertRationalToDouble(valueRational), valueRational));
        }
    }

    private void readAndEvaluateRationalsListAsDoubleArray(int directoryType, ExifIDFRawTag tag) {
        String tagShortDesc = this.tagMapper.getShortName(directoryType, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(directoryType, tag.tagname);
        Rational[] valueRationalList = this.getTagValueRationalList(tag);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.RationalsList, ExifParser.convertRationalsListToDoubleArray(valueRationalList), null));
    }

    private void readAndEvaluateNormalLowHighTag(ExifIDFRawTag tag) {
        int tagvalue = this.getTagValueShort(tag)[0];
        String str = null;
        switch (tagvalue) {
            case 0: {
                str = "Normal";
                break;
            }
            case 1: {
                str = "Soft";
                break;
            }
            case 2: {
                str = "Hard";
                break;
            }
            default: {
                str = "Unknown";
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
    }

    private void readAndEvaluatePlanarConfigurationTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 1: {
                str = "Chunky";
                break;
            }
            case 2: {
                str = "Planar";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateComponentsConfigurationTag(ExifIDFRawTag tag) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = this.getTagValueBytes(tag);
        for (int i = 0; i < 4; ++i) {
            byte v = bytes[i];
            if (v == 1) {
                sb.append("Y");
                continue;
            }
            if (v == 2) {
                sb.append("Cb");
                continue;
            }
            if (v == 3) {
                sb.append("Cr");
                continue;
            }
            if (v == 4) {
                sb.append("R");
                continue;
            }
            if (v == 5) {
                sb.append("G");
                continue;
            }
            if (v != 6) continue;
            sb.append("B");
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (sb.length() > 0) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, sb.toString(), bytes));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + bytes.length + " in " + this.name);
        }
    }

    private void readAndEvaluateSubjectDistanceRangeTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "unknown";
                break;
            }
            case 1: {
                str = "Macro";
                break;
            }
            case 2: {
                str = "Close view";
                break;
            }
            case 3: {
                str = "Distant view";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateGainControlTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "None";
                break;
            }
            case 1: {
                str = "Low gain up";
                break;
            }
            case 2: {
                str = "High gain up";
                break;
            }
            case 3: {
                str = "Low gain down";
                break;
            }
            case 4: {
                str = "High gain down";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateScreenCaptureTypeTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Standard";
                break;
            }
            case 1: {
                str = "Landscape";
                break;
            }
            case 2: {
                str = "Portrait";
                break;
            }
            case 3: {
                str = "Night scene";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateWhiteBalanceTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Auto white balance";
                break;
            }
            case 1: {
                str = "Manual white balance";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateExposureModeTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Auto exposure";
                break;
            }
            case 1: {
                str = "Manual exposure";
                break;
            }
            case 2: {
                str = "Auto bracket";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateCustomRenderedTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Normal process";
                break;
            }
            case 1: {
                str = "Custom process";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateSensingMethodTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 2: {
                str = "One-chip color area sensor";
                break;
            }
            case 3: {
                str = "Two-chip color area sensor";
                break;
            }
            case 4: {
                str = "Three-chip color area sensor";
                break;
            }
            case 5: {
                str = "Color sequential area sensor";
                break;
            }
            case 7: {
                str = "Trilinear sensor";
                break;
            }
            case 8: {
                str = "Color sequential linear sensor";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateColorSpaceTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 1: {
                str = "sRGB";
                break;
            }
            case 65535: {
                str = "Uncalibrated";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateFlashTag(ExifIDFRawTag tag) throws IOException {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Flash did not fire";
                break;
            }
            case 1: {
                str = "Flash fired";
                break;
            }
            case 5: {
                str = "Strobe return light not detected";
                break;
            }
            case 7: {
                str = "Strobe return light detected";
                break;
            }
            case 9: {
                str = "Flash fired, compulsory flash mode";
                break;
            }
            case 13: {
                str = "Flash fired, compulsory flash mode, return light not detected";
                break;
            }
            case 15: {
                str = "Flash fired, compulsory flash mode, return light detected";
                break;
            }
            case 16: {
                str = "Flash did not fire, compulsory flash mode";
                break;
            }
            case 24: {
                str = "Flash did not fire, auto mode";
                break;
            }
            case 25: {
                str = "Flash fired, auto mode";
                break;
            }
            case 29: {
                str = "Flash fired, auto mode, return light not detected";
                break;
            }
            case 31: {
                str = "Flash fired, auto mode, return light detected";
                break;
            }
            case 32: {
                str = "No flash function";
                break;
            }
            case 65: {
                str = "Flash fired, red-eye reduction mode";
                break;
            }
            case 69: {
                str = "Flash fired, red-eye reduction mode, return light not detected";
                break;
            }
            case 71: {
                str = "Flash fired, red-eye reduction mode, return light detected";
                break;
            }
            case 73: {
                str = "Flash fired, compulsory flash mode, red-eye reduction mode";
                break;
            }
            case 77: {
                str = "Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected";
                break;
            }
            case 79: {
                str = "Flash fired, compulsory flash mode, red-eye reduction mode, return light detected";
                break;
            }
            case 89: {
                str = "Flash fired, auto mode, red-eye reduction mode";
                break;
            }
            case 93: {
                str = "Flash fired, auto mode, return light not detected, red-eye reduction mode";
                break;
            }
            case 95: {
                str = "Flash fired, auto mode, return light detected, red-eye reduction mode";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateLightSourceTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Unknown";
                break;
            }
            case 1: {
                str = "Daylight";
                break;
            }
            case 2: {
                str = "Fluorescent";
                break;
            }
            case 3: {
                str = "Tungsten";
                break;
            }
            case 4: {
                str = "Flash";
                break;
            }
            case 9: {
                str = "Fine weather";
                break;
            }
            case 10: {
                str = "Cloudy weather";
                break;
            }
            case 11: {
                str = "Shade";
                break;
            }
            case 12: {
                str = "Daylight fluorescent (D 5700 \u2013 7100K)";
                break;
            }
            case 13: {
                str = "Day white fluorescent (N 4600 \u2013 5400K)";
                break;
            }
            case 14: {
                str = "Cool white fluorescent (W 3900 \u2013 4500K)";
                break;
            }
            case 15: {
                str = "White fluorescent (WW 3200 \u2013 3700K)";
                break;
            }
            case 17: {
                str = "Standard light A";
                break;
            }
            case 18: {
                str = "Standard light B";
                break;
            }
            case 19: {
                str = "Standard light C";
                break;
            }
            case 20: {
                str = "D55";
                break;
            }
            case 21: {
                str = "D65";
                break;
            }
            case 22: {
                str = "D75";
                break;
            }
            case 23: {
                str = "D50";
                break;
            }
            case 24: {
                str = "ISO studio tungsten";
                break;
            }
            case 255: {
                str = "other light source";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateMeteringModeTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Unknown";
                break;
            }
            case 1: {
                str = "Average";
                break;
            }
            case 2: {
                str = "Center Weighted Average";
                break;
            }
            case 3: {
                str = "Spot";
                break;
            }
            case 4: {
                str = "Multi Spot";
                break;
            }
            case 5: {
                str = "Pattern";
                break;
            }
            case 6: {
                str = "Partial";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateISOSpeedRatingsTag(ExifIDFRawTag tag) {
        int[] value = this.getTagValueShort(tag);
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.NumberList, value, null));
    }

    private void readAndEvaluateFNumberTag(ExifIDFRawTag tag) {
        Rational valueRational = this.getTagValueRational(tag);
        float f = ExifParser.convertRationalToFloat(valueRational);
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, "f/" + f, Float.valueOf(f)));
    }

    private void readAndEvaluateSubjectDistanceTag(ExifIDFRawTag tag) {
        Rational rational = this.getTagValueRational(tag);
        float f = ExifParser.convertRationalToFloat(rational);
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (rational.numerator == 0L) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, "unknown distance", Float.valueOf(f)));
        } else if (rational.numerator > Integer.MAX_VALUE) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, "infinity", Float.valueOf(f)));
        } else {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, Float.toString(f) + " m", Float.valueOf(f)));
        }
    }

    private void readAndEvaluateExposureProgramTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 0: {
                str = "Not defined";
                break;
            }
            case 1: {
                str = "Manual";
                break;
            }
            case 2: {
                str = "Normal program";
                break;
            }
            case 3: {
                str = "Aperture priority";
                break;
            }
            case 4: {
                str = "Shutter priority";
                break;
            }
            case 5: {
                str = "Creative program";
                break;
            }
            case 6: {
                str = "Action program";
                break;
            }
            case 7: {
                str = "Portrait mode";
                break;
            }
            case 8: {
                str = "Landscape mode";
                break;
            }
            default: {
                str = null;
            }
        }
        if (str != null) {
            String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
            String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + ": " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateShutterSpeedValueTag(ExifIDFRawTag tag) {
        Rational rational = this.getTagValueRational(tag);
        float f = ExifParser.convertRationalToFloat(rational);
        if (f >= 0.0f) {
            String s = f < 1.0f ? "1/" + Math.round(1.0f / f) + " sec" : f + " sec";
            String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
            String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, s, Float.valueOf(f)));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + " " + f + " in " + this.name);
        }
    }

    private void readAndEvaluateExposureBiasValueTag(ExifIDFRawTag tag) {
        Rational rational = this.getTagValueRational(tag);
        float f = ExifParser.convertRationalToFloat(rational);
        int fi = (int)Math.floor(f);
        float rest = f - (float)fi;
        StringBuilder fsb = new StringBuilder();
        if (f > 0.0f) {
            fsb.append('+');
        }
        if ((double)rest > 0.332 && (double)rest < 0.335) {
            if (fi != 0) {
                fsb.append(fi);
                fsb.append(' ');
            }
            fsb.append("1/3");
        } else if ((double)rest > 0.665 && (double)rest < 0.667) {
            if (fi != 0) {
                fsb.append(fi);
                fsb.append(' ');
            }
            fsb.append("2/3");
        } else if (rest == 0.0f) {
            fsb.append("\u00b10");
        } else {
            fsb.append(this.df2f.format(f));
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, fsb.toString(), Float.valueOf(f)));
    }

    private void readAndEvaluateResolutionUnitTag(ExifIDFRawTag tag) {
        String str;
        int tagvalue = this.getTagValueShort(tag)[0];
        switch (tagvalue) {
            case 2: {
                str = "Inch";
                break;
            }
            case 3: {
                str = "Centimeter";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateYCbCrPositioningTag(ExifIDFRawTag tag) {
        int tagvalue = this.getTagValueShort(tag)[0];
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (tagvalue == 1) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, "Centered", tagvalue));
        } else if (tagvalue == 2) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, "Co-sited", tagvalue));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + tagvalue + " in " + this.name);
        }
    }

    private void readAndEvaluateOrientationTag(ExifIDFRawTag tag) {
        String str;
        int value = this.getTagValueShort(tag)[0];
        switch (value) {
            case 1: {
                str = "Top Left (Horizontal, normal)";
                break;
            }
            case 2: {
                str = "Top Right (Mirror horizontal)";
                break;
            }
            case 3: {
                str = "Bottom Right (Rotate 180)";
                break;
            }
            case 4: {
                str = "Bottom Left (Mirror vertical)";
                break;
            }
            case 5: {
                str = "Left Top (Mirror horizontal and rotate 270 CW)";
                break;
            }
            case 6: {
                str = "Right Top (Rotate 90 CW )";
                break;
            }
            case 7: {
                str = "Right Bottom (Mirror horizontal and rotate 90 CW)";
                break;
            }
            case 8: {
                str = "Left Bottom (Rotate 270 CW)";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, value));
        } else {
            this.fsilogger.log(3835, "Invalid value for tag: tagname:" + tag.tagname + "(" + tagShortDesc + "): " + value + " in " + this.name);
        }
    }

    private void readAndEvaluateResolutionTag(ExifIDFRawTag tag) {
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        Rational rational = this.getTagValueRational(tag);
        if (rational.denominator == 1L) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, String.valueOf(rational.numerator), rational));
        } else {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, rational.numerator + "/" + rational.denominator, rational));
        }
    }

    private void readAndEvaluatePhotometricInterpretationTag(ExifIDFRawTag tag) {
        String str;
        int value = this.getTagValueShort(tag)[0];
        switch (value) {
            case 0: {
                str = "WhiteIsZero";
                break;
            }
            case 2: {
                str = "BlackIsZero";
                break;
            }
            case 3: {
                str = "RGB";
                break;
            }
            case 4: {
                str = "RGB Palette ";
                break;
            }
            case 5: {
                str = "Transparency Mask ";
                break;
            }
            case 6: {
                str = "CMYK";
                break;
            }
            case 7: {
                str = "YCbCr";
                break;
            }
            case 8: {
                str = "CIELab";
                break;
            }
            case 9: {
                str = "ICCLab";
                break;
            }
            case 10: {
                str = "ITULab";
                break;
            }
            case 32803: {
                str = "Color Filter Array ";
                break;
            }
            case 32844: {
                str = "Pixar LogL ";
                break;
            }
            case 32845: {
                str = "Pixar LogLuv ";
                break;
            }
            case 34892: {
                str = "Linear Raw";
                break;
            }
            default: {
                str = null;
            }
        }
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        if (str != null) {
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, value));
        } else {
            this.fsilogger.log(3835, "Unknown value for Photometric Interpretation: " + value + " in " + this.name);
        }
    }

    private void readAndEvaluateSceneTypeTag(ExifIDFRawTag tag) {
        byte[] bytes = this.getTagValueBytes(tag);
        String str = null;
        str = bytes[0] == 1 ? "Directly Photographed" : "Unknown";
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, bytes[0]));
    }

    private void readAndEvaluateFileSourceTag(ExifIDFRawTag tag) {
        byte[] bytes = this.getTagValueBytes(tag);
        String str = null;
        str = bytes[0] == 1 ? "Film Scanner" : (bytes[0] == 2 ? "Reflection Print Scanner" : (bytes[0] == 3 ? "Digital Camera" : "Unknown"));
        String tagShortDesc = this.tagMapper.getShortName(34665, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34665, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, bytes[0]));
    }

    private void readAndEvaluateGPSLatitudeRefTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String str = null;
        String ascii = this.readPlainTextTag(tag);
        if (ascii != null) {
            if (ascii.equals("N")) {
                str = "North";
            } else if (ascii.equals("S")) {
                str = "South";
            }
            String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
            String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, ascii));
        }
    }

    private void readAndEvaluateGPSLongitudeRefTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String str = null;
        String ascii = this.readPlainTextTag(tag);
        if (ascii != null) {
            if (ascii.equals("E")) {
                str = "East";
            } else if (ascii.equals("W")) {
                str = "West";
            }
            String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
            String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
            this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, ascii));
        }
    }

    private void readAndEvaluateGPSStatusTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String str = null;
        String ascii = this.readPlainTextTag(tag);
        if (ascii != null) {
            if (ascii.equals("A")) {
                str = "Measurement Active";
            } else if (ascii.equals("V")) {
                str = "Measurement Void";
            }
            if (str != null) {
                String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
                String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
                this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, ascii));
            } else {
                this.fsilogger.log(3835, "Unknown content for GPS Status: " + ascii + " in " + this.name);
            }
        }
    }

    private void readAndEvaluateGPSAltitudeRefTag(ExifIDFRawTag tag) {
        String str = null;
        byte[] bytes = this.getTagValueBytes(tag);
        if (bytes[0] == 0) {
            str = "Above Sea Level";
        } else if (bytes[0] == 1) {
            str = "Below Sea Level";
        }
        String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, bytes[0]));
    }

    private void readAndEvaluateGPSDifferentalTag(ExifIDFRawTag tag) {
        String str = null;
        byte[] bytes = this.getTagValueBytes(tag);
        if (bytes[0] == 0) {
            str = "No Correction";
        } else if (bytes[0] == 1) {
            str = "Differential Correction";
        }
        String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
        String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
        this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, bytes[0]));
    }

    private void readAndEvaluateGPSMeasureModeTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String str = null;
        String ascii = this.readPlainTextTag(tag);
        if (ascii != null) {
            if (ascii.equals("2")) {
                str = "2-Dimensional Measurement";
            } else if (ascii.equals("3")) {
                str = "3-Dimensional Measurement";
            }
            if (str != null) {
                String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
                String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
                this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, ascii));
            } else {
                this.fsilogger.log(3835, "Unknown content for GPS Measure Mode: " + ascii + " in " + this.name);
            }
        }
    }

    private void readAndEvaluateGPSSpeedRefTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String str = null;
        String ascii = this.readPlainTextTag(tag);
        if (ascii != null) {
            if (ascii.equals("K")) {
                str = "km/h";
            } else if (ascii.equals("M")) {
                str = "mph";
            } else if (ascii.equals("N")) {
                str = "knots";
            }
            if (str != null) {
                String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
                String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
                this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, ascii));
            } else {
                this.fsilogger.log(3835, "Unknown content for GPS Speed Ref: " + ascii + " in " + this.name);
            }
        }
    }

    private void readAndEvaluateGPSTrackRefTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        String str = null;
        String ascii = this.readPlainTextTag(tag);
        if (ascii != null) {
            if (ascii.equals("M")) {
                str = "Magnetic North";
            } else if (ascii.equals("T")) {
                str = "True North";
            }
            if (str != null) {
                String tagShortDesc = this.tagMapper.getShortName(34853, tag.tagname);
                String tagLongDesc = this.tagMapper.getLongName(34853, tag.tagname);
                this.exifTags.add(new ExifTag(tag.tagname, tagShortDesc, tagLongDesc, ExifValueType.Text, str, ascii));
            } else {
                this.fsilogger.log(3835, "Unknown content for GPS Track Ref: " + ascii + " in " + this.name);
            }
        }
    }

    private String readPlainTextTag(ExifIDFRawTag tag) throws UnsupportedEncodingException {
        byte[] strRaw = this.getTagValueBytes(tag);
        String ascii = new String(strRaw, FileOperations.charsetISO8859_15);
        if (ascii.length() == 0) {
            return null;
        }
        return ascii.trim();
    }

    private String readUndefinedTagAsString(ExifIDFRawTag tag) {
        String result = null;
        byte[] bytesRaw = this.getTagValueBytes(tag);
        byte[] designation = Arrays.copyOf(bytesRaw, 8);
        if (Arrays.equals(designation, UNDEF_DESIGNATION_ASCII) && bytesRaw.length > 8) {
            byte[] strRaw = Arrays.copyOfRange(bytesRaw, 8, bytesRaw.length - 1);
            result = new String(strRaw, FileOperations.charsetASCII);
        } else if (Arrays.equals(designation, UNDEF_DESIGNATION_UNICODE) && bytesRaw.length > 8) {
            byte[] strRaw = Arrays.copyOfRange(bytesRaw, 8, bytesRaw.length - 1);
            result = new String(strRaw, FileOperations.charsetUTF8);
        } else if (tag.tagname == 36864 || tag.tagname == 40960 || tag.tagname == 2) {
            result = new String(bytesRaw, FileOperations.charsetASCII);
            if (!this.littleendian && result.length() <= 4) {
                result = new StringBuffer(result).reverse().toString();
            }
        } else {
            String undefDesignation = new String(designation, FileOperations.charsetASCII);
            this.fsilogger.log(3835, "Unknown content for tag: " + tag.tagname + "(length: " + bytesRaw.length + "): " + undefDesignation + " in " + this.name);
        }
        return result;
    }

    private Rational getTagValueRational(ExifIDFRawTag tag) throws BufferUnderflowException {
        this.bois.position((int)tag.tagvalueoffset);
        return new Rational(this.bois.getInt(), this.bois.getInt());
    }

    private Rational[] getTagValueRationalList(ExifIDFRawTag tag) throws BufferUnderflowException {
        Rational[] returnvalue = new Rational[tag.tagvaluecount];
        this.bois.position((int)tag.tagvalueoffset);
        for (int i = 0; i < tag.tagvaluecount; ++i) {
            returnvalue[i] = new Rational(this.bois.getInt(), this.bois.getInt());
        }
        return returnvalue;
    }

    private int[] getTagValueLong(ExifIDFRawTag tag) throws BufferUnderflowException {
        int[] result = new int[tag.tagvaluecount];
        this.bois.position((int)tag.tagvalueoffset);
        for (int l = 0; l < tag.tagvaluecount; ++l) {
            result[l] = this.bois.getInt();
        }
        return result;
    }

    private int[] getTagValueShort(ExifIDFRawTag tag) throws BufferUnderflowException {
        int[] result = new int[tag.tagvaluecount];
        try {
            this.bois.position((int)tag.tagvalueoffset);
            for (int i = 0; i < tag.tagvaluecount; ++i) {
                result[i] = this.bois.getShort() & 0xFFFF;
            }
        }
        catch (IllegalArgumentException e) {
            if (this.fsilogger != null) {
                this.fsilogger.logException(e, 3830, "IAR1", e.getLocalizedMessage());
            }
            this.error = true;
        }
        catch (BufferUnderflowException e) {
            if (this.fsilogger != null) {
                this.fsilogger.logException(e, 3830, "BUE2", e.getLocalizedMessage());
            }
            this.error = true;
        }
        return result;
    }

    private byte[] getTagValueBytes(ExifIDFRawTag tag) throws BufferUnderflowException, IllegalArgumentException {
        byte[] bytes = new byte[tag.tagvaluecount];
        this.bois.position((int)tag.tagvalueoffset);
        this.bois.get(bytes);
        return bytes;
    }

    private ByteOrder parseHeader(byte[] ifh) {
        ByteOrder bo;
        if (ifh[0] == 73 && ifh[1] == 73) {
            this.littleendian = true;
            bo = ByteOrder.LITTLE_ENDIAN;
        } else if (ifh[0] == 77 && ifh[1] == 77) {
            this.littleendian = false;
            bo = ByteOrder.BIG_ENDIAN;
        } else {
            this.error = true;
            bo = null;
        }
        if (this.littleendian && ifh[2] != 42 && ifh[3] != 0) {
            this.error = true;
        } else if (!this.littleendian && ifh[2] != 0 && ifh[3] != 42) {
            this.error = true;
        }
        if (this.error && this.fsilogger != null) {
            this.fsilogger.log(3831, this.name);
        }
        return bo;
    }

    private void scanIFD(Directory directory) {
        block18: {
            try {
                this.bois.position(directory.getStartOffset());
                int idf_entry_count = this.bois.getShort();
                if (idf_entry_count > 0 && idf_entry_count <= 3000) {
                    int i;
                    ExifIDFRawTag[] idfTable = new ExifIDFRawTag[idf_entry_count];
                    for (i = 0; i < idf_entry_count; ++i) {
                        int bytecount;
                        int tagstartoffset = directory.getStartOffset() + 2 + 12 * i;
                        this.bois.position(tagstartoffset);
                        idfTable[i] = new ExifIDFRawTag();
                        idfTable[i].tagname = this.bois.getShort() & 0xFFFF;
                        idfTable[i].tagtype = this.bois.getShort() & 0xFFFF;
                        idfTable[i].tagvaluecount = this.bois.getInt();
                        idfTable[i].tagvalueoffset = this.bois.getInt();
                        if (idfTable[i].tagtype < 0 || idfTable[i].tagtype > 12 || (bytecount = idfTable[i].tagvaluecount * BYTES_PER_TAGTYPE[idfTable[i].tagtype]) > 4) continue;
                        idfTable[i].tagvalueoffset = tagstartoffset + 8;
                    }
                    switch (directory.getType()) {
                        case 34665: {
                            for (i = 0; i < idf_entry_count; ++i) {
                                if (idfTable[i].tagname <= 0) continue;
                                this.evaluateExifTag(idfTable[i]);
                            }
                            break block18;
                        }
                        case 34853: {
                            for (i = 0; i < idf_entry_count; ++i) {
                                if (idfTable[i].tagname <= 0) continue;
                                this.evaluateGPSTag(idfTable[i]);
                            }
                            break block18;
                        }
                        case 40965: {
                            for (i = 0; i < idf_entry_count; ++i) {
                                if (idfTable[i].tagname <= 0) continue;
                                this.evaluateInterOpTag(idfTable[i]);
                            }
                            break block18;
                        }
                    }
                    break block18;
                }
                if (idf_entry_count < 0 || idf_entry_count > 3000) {
                    if (this.fsilogger != null) {
                        this.fsilogger.log(3832, this.name);
                    }
                    this.error = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.fsilogger != null) {
                    this.fsilogger.logException(e, 3830, "IOE1", this.name);
                }
                this.error = true;
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                if (this.fsilogger != null) {
                    this.fsilogger.logException(e, 3830, "IAE2", this.name);
                }
                this.error = true;
            }
        }
    }

    private static double[] convertRationalsListToDoubleArray(Rational[] r) {
        double[] result = new double[r.length];
        for (int i = 0; i < r.length; ++i) {
            result[i] = ExifParser.convertRationalToDouble(r[i]);
        }
        return result;
    }

    private static double convertRationalToDouble(Rational r) {
        double resx = (double)r.numerator / (double)r.denominator;
        return resx;
    }

    private static float convertRationalToFloat(Rational r) {
        if (r.denominator != 0L) {
            float resx = (float)r.numerator / (float)r.denominator;
            return resx;
        }
        return 0.0f;
    }
}

