/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.exif;

import com.neptunelabs.imagereader.exif.ExifValueType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class ExifTag
implements Comparable<ExifTag> {
    private final int key;
    private final String shortDesc;
    private final String longDesc;
    private final ExifValueType type;
    private final Object rawvalue;
    private String valueText;
    private long valueNumber;
    private long[] valueNumberList;
    private double valueRational;
    private double[] valueRationalsList;
    private final DecimalFormatSymbols geoDFS = new DecimalFormatSymbols(Locale.US);
    private final DecimalFormat geoFormat = new DecimalFormat("##0.######", this.geoDFS);
    private final DecimalFormat tsFormat = new DecimalFormat("00", this.geoDFS);

    public ExifTag(int tag, String shortDesc, String longDesc, ExifValueType type, Object value, Object rawvalue) {
        this.key = tag;
        this.shortDesc = shortDesc;
        this.longDesc = longDesc;
        this.type = type;
        this.rawvalue = rawvalue;
        switch (type) {
            case Number: {
                if (value instanceof Long) {
                    this.valueNumber = (Long)value;
                    break;
                }
                if (!(value instanceof Integer)) break;
                this.valueNumber = ((Integer)value).longValue();
                break;
            }
            case NumberList: {
                if (value instanceof long[]) {
                    this.valueNumberList = (long[])value;
                    break;
                }
                if (!(value instanceof int[])) break;
                int[] intvalues = (int[])value;
                this.valueNumberList = new long[intvalues.length];
                for (int i = 0; i < intvalues.length; ++i) {
                    this.valueNumberList[i] = intvalues[i];
                }
                break;
            }
            case Rational: {
                this.valueRational = (Double)value;
                break;
            }
            case RationalsList: {
                this.valueRationalsList = (double[])value;
                break;
            }
            case Text: {
                this.valueText = (String)value;
            }
        }
    }

    public ExifValueType getType() {
        return this.type;
    }

    public int getTag() {
        return this.key;
    }

    public String getShortDescription() {
        return this.shortDesc;
    }

    public String getLongDescription() {
        return this.longDesc;
    }

    public String getText() {
        return this.valueText;
    }

    public long getNumber() {
        return this.valueNumber;
    }

    public double getRational() {
        return this.valueRational;
    }

    public double[] getRationalsList() {
        return this.valueRationalsList;
    }

    public Object getRaw() {
        return this.rawvalue;
    }

    public String getValueAsText() {
        String result = "";
        switch (this.type) {
            case Text: {
                result = this.valueText;
                break;
            }
            case Number: {
                result = String.valueOf(this.valueNumber);
                break;
            }
            case NumberList: {
                if (this.valueNumberList == null) break;
                for (long element : this.valueNumberList) {
                    result = result + String.valueOf(element) + " ";
                }
                break;
            }
            case Rational: {
                result = String.valueOf(this.valueRational);
                break;
            }
            case RationalsList: {
                if (this.key == 4 || this.key == 2) {
                    if (this.valueRationalsList.length != 3) break;
                    double v = this.valueRationalsList[0] + this.valueRationalsList[1] / 60.0 + this.valueRationalsList[2] / 3600.0;
                    result = result + this.geoFormat.format(v);
                    break;
                }
                if (this.key == 7) {
                    if (this.valueRationalsList.length != 3) break;
                    result = result + this.tsFormat.format(this.valueRationalsList[0]) + ":" + this.tsFormat.format(this.valueRationalsList[1]) + ":" + this.tsFormat.format(this.valueRationalsList[2]);
                    break;
                }
                for (double element : this.valueRationalsList) {
                    result = result + String.valueOf(element) + " ";
                }
                break;
            }
        }
        return result;
    }

    @Override
    public int compareTo(ExifTag o) {
        return this.shortDesc.compareTo(o.shortDesc);
    }

    public String toString() {
        return this.longDesc + ": " + this.getValueAsText();
    }
}

