/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.imagereader.helper.Data8BIM;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Decode8BIM {
    private static final byte[] ID8MAGIC = new byte[]{56, 66, 73, 77};
    private final ByteArrayWalker psresource;
    private final Map<String, Data8BIM> resourceMap = new HashMap<String, Data8BIM>();
    private final List<Data8BIM> pathList = new ArrayList<Data8BIM>();
    private final List<String> alphaNames = new ArrayList<String>();
    private boolean error = false;

    public Decode8BIM(byte[] psresource) {
        this(ByteArrayWalker.wrap(psresource, ByteOrder.BIG_ENDIAN));
    }

    public Decode8BIM(ByteArrayWalker psresource) {
        this.psresource = psresource;
        try {
            int pos1 = this.findFirstPos();
            if (pos1 >= 0) {
                this.deepScan(pos1);
            } else {
                this.error = true;
            }
        }
        catch (Exception e) {
            this.error = true;
        }
    }

    public byte[] getResource(String resource) {
        byte[] result = null;
        if (this.resourceMap.containsKey(resource)) {
            Data8BIM d8bim = this.resourceMap.get(resource);
            this.psresource.position(d8bim.pos);
            result = new byte[d8bim.len];
            this.psresource.get(result);
        }
        return result;
    }

    public Set<String> getResourceKeys() {
        return this.resourceMap.keySet();
    }

    private byte[] getData(Data8BIM d8bim) {
        this.psresource.position(d8bim.pos);
        byte[] result = new byte[d8bim.len];
        this.psresource.get(result);
        return result;
    }

    public int getPathCount() {
        return this.pathList.size();
    }

    public String[] getAlphaNames() {
        if (this.alphaNames.size() == 0) {
            return null;
        }
        String[] result = new String[this.alphaNames.size()];
        for (int i = 0; i < this.alphaNames.size(); ++i) {
            result[i] = this.alphaNames.get(i);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public byte[] getPaths() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] getSelectionNames(byte[] fsiSelectionsRaw) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(fsiSelectionsRaw, ByteOrder.LITTLE_ENDIAN);
        int selectionCount = bb.getInt();
        String[] resultNames = new String[selectionCount];
        for (int i = 0; i < selectionCount; ++i) {
            int nameLen = bb.getInt();
            byte[] nameRaw = new byte[nameLen];
            bb.get(nameRaw);
            int pathLen = bb.getInt();
            bb.position(bb.position() + pathLen);
            resultNames[i] = new String(nameRaw);
        }
        return resultNames;
    }

    public static byte[] drawSelection(byte[] fsiSelectionsRaw, int selectionID, int width, int height) {
        return Decode8BIM.drawSelection(fsiSelectionsRaw, selectionID, width, height, width, height, 0.0f, 0.0f);
    }

    public static byte[] drawSelection(byte[] fsiSelectionsRaw, int selectionID, int targetWidth, int targetHeight, int fullWidth, int fullHeight, float offSetX, float offSetY) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(fsiSelectionsRaw, ByteOrder.LITTLE_ENDIAN);
        int selectionCount = bb.getInt();
        byte[] result = null;
        for (int i = 0; i < selectionCount; ++i) {
            int pathLen;
            int nameLen;
            if (selectionID == i) {
                nameLen = bb.getInt();
                bb.position(bb.position() + nameLen);
                pathLen = bb.getInt();
                byte[] path = new byte[pathLen];
                bb.get(path);
                ByteArrayWalker selectionBB = ByteArrayWalker.wrap(path, ByteOrder.LITTLE_ENDIAN);
                GeneralPath generalPath = new GeneralPath();
                generalPath.setWindingRule(0);
                boolean openPath = true;
                boolean closePath = false;
                CurvePoint cp1 = new CurvePoint();
                CurvePoint cp2 = new CurvePoint();
                CurvePoint cp3 = new CurvePoint();
                generalPath.moveTo(offSetX, offSetY);
                int elements = selectionBB.getInt();
                block5: for (int e = 0; e < elements; ++e) {
                    byte selector = selectionBB.get();
                    switch (selector) {
                        case 0: 
                        case 3: {
                            if (!closePath) {
                                closePath = true;
                                continue block5;
                            }
                            if (!openPath) {
                                generalPath.curveTo(cp2.x3 * (float)fullWidth, cp2.y3 * (float)fullHeight, cp3.x1 * (float)fullWidth, cp3.y1 * (float)fullHeight, cp3.x2 * (float)fullWidth, cp3.y2 * (float)fullHeight);
                            }
                            openPath = true;
                            continue block5;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: {
                            cp1.x1 = selectionBB.getFloat() + offSetX;
                            cp1.y1 = selectionBB.getFloat() + offSetY;
                            cp1.x2 = selectionBB.getFloat() + offSetX;
                            cp1.y2 = selectionBB.getFloat() + offSetY;
                            cp1.x3 = selectionBB.getFloat() + offSetX;
                            cp1.y3 = selectionBB.getFloat() + offSetY;
                            if (openPath) {
                                generalPath.moveTo(cp1.x2 * (float)fullWidth, cp1.y2 * (float)fullHeight);
                                cp2 = cp1.clone();
                                cp3 = cp1.clone();
                                openPath = false;
                                continue block5;
                            }
                            generalPath.curveTo(cp2.x3 * (float)fullWidth, cp2.y3 * (float)fullHeight, cp1.x1 * (float)fullWidth, cp1.y1 * (float)fullHeight, cp1.x2 * (float)fullWidth, cp1.y2 * (float)fullHeight);
                            cp2 = cp1.clone();
                            continue block5;
                        }
                    }
                }
                generalPath.curveTo(cp2.x3 * (float)fullWidth, cp2.y3 * (float)fullHeight, cp3.x1 * (float)fullWidth, cp3.y1 * (float)fullHeight, cp3.x2 * (float)fullWidth, cp3.y2 * (float)fullHeight);
                if (closePath) {
                    generalPath.closePath();
                }
                BufferedImage selectionAlphaImage = new BufferedImage(targetWidth, targetHeight, 10);
                Graphics2D g2 = selectionAlphaImage.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setPaint(Color.white);
                g2.fill(generalPath);
                g2.dispose();
                WritableRaster wRaster = selectionAlphaImage.getRaster();
                if (wRaster.getDataBuffer().getDataType() == 0) {
                    result = ((DataBufferByte)wRaster.getDataBuffer()).getData();
                }
                selectionAlphaImage.flush();
                break;
            }
            nameLen = bb.getInt();
            bb.position(bb.position() + nameLen);
            pathLen = bb.getInt();
            bb.position(bb.position() + pathLen);
        }
        return result;
    }

    public boolean hasError() {
        return this.error;
    }

    private int findFirstPos() {
        int pos1bim = -1;
        boolean result = false;
        for (int dp = 0; dp < this.psresource.capacity() - ID8MAGIC.length; ++dp) {
            byte ddp = this.psresource.get();
            if (ddp == ID8MAGIC[0]) {
                result = true;
                int c = 1;
                while (c < ID8MAGIC.length) {
                    ddp = this.psresource.get();
                    if (ddp != ID8MAGIC[c]) {
                        result = false;
                        break;
                    }
                    ++c;
                    ++dp;
                }
            }
            if (!result) continue;
            pos1bim = dp - ID8MAGIC.length + 1;
            break;
        }
        return pos1bim;
    }

    private void deepScan(int startPos) {
        boolean stop = false;
        this.psresource.position(startPos);
        int pathIDCount = 0;
        ArrayList<Data8BIM> pathListWON = new ArrayList<Data8BIM>();
        byte[] eightbim = new byte[4];
        while (this.psresource.remaining() >= 4 && !stop) {
            this.psresource.get(eightbim);
            if (Arrays.equals(eightbim, ID8MAGIC)) {
                short id = this.psresource.getShort();
                String name = null;
                int namelen = this.psresource.get() & 0xFF;
                if (namelen > 0) {
                    byte[] nameBytes = new byte[namelen];
                    this.psresource.get(nameBytes);
                    name = new String(nameBytes, FileOperations.charsetISO8859_15);
                    if (!Decode8BIM.isPosEven(this.psresource.position())) {
                        this.psresource.get();
                    }
                } else {
                    this.psresource.get();
                }
                int datalen = this.psresource.getInt();
                if (datalen > 0) {
                    String nameStr;
                    byte[] nameRaw;
                    int bPos;
                    int nameLen;
                    ByteArrayWalker bb;
                    int cpos = this.psresource.position();
                    if (id == 1028) {
                        Data8BIM d8bim = new Data8BIM();
                        d8bim.pos = cpos;
                        d8bim.len = datalen;
                        this.resourceMap.put("IPTC", d8bim);
                        this.psresource.position(this.psresource.position() + Decode8BIM.evenLength(datalen));
                        continue;
                    }
                    if (id == 1058) {
                        Data8BIM d8bim = new Data8BIM();
                        d8bim.pos = cpos;
                        d8bim.len = datalen;
                        this.resourceMap.put("EXIF", d8bim);
                        this.psresource.position(this.psresource.position() + Decode8BIM.evenLength(datalen));
                        continue;
                    }
                    if (id == 1060) {
                        Data8BIM d8bim = new Data8BIM();
                        d8bim.pos = cpos;
                        d8bim.len = datalen;
                        this.resourceMap.put("XMP", d8bim);
                        this.psresource.position(this.psresource.position() + Decode8BIM.evenLength(datalen));
                        continue;
                    }
                    if (id >= 2000 && id <= 2998) {
                        Data8BIM d8bim = new Data8BIM();
                        if (name == null) {
                            name = Integer.toString(pathIDCount);
                            ++pathIDCount;
                        }
                        d8bim.name = name;
                        d8bim.pos = cpos;
                        d8bim.len = datalen;
                        this.pathList.add(d8bim);
                        this.psresource.position(this.psresource.position() + Decode8BIM.evenLength(datalen));
                        continue;
                    }
                    if (id == 1025) {
                        Data8BIM d8bim = new Data8BIM();
                        d8bim.name = "Working Path";
                        d8bim.pos = cpos;
                        d8bim.len = datalen;
                        pathListWON.add(d8bim);
                        this.psresource.position(this.psresource.position() + Decode8BIM.evenLength(datalen));
                        continue;
                    }
                    if (id == 1006) {
                        byte[] data = new byte[datalen];
                        this.psresource.get(data);
                        bb = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
                        if (this.alphaNames.size() == 0) {
                            for (bPos = 0; bPos < datalen; bPos += nameLen + 1) {
                                nameLen = bb.get();
                                nameRaw = new byte[nameLen];
                                bb.get(nameRaw);
                                nameStr = "";
                                try {
                                    nameStr = new String(nameRaw, "ISO-8859-1");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    // empty catch block
                                }
                                this.alphaNames.add(nameStr);
                            }
                        }
                        if (Decode8BIM.isPosEven(this.psresource.position())) continue;
                        this.psresource.get();
                        continue;
                    }
                    if (id == 1045) {
                        if (this.alphaNames.size() > 0) {
                            this.alphaNames.clear();
                        }
                        byte[] data = new byte[datalen];
                        this.psresource.get(data);
                        bb = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
                        if (this.alphaNames.size() == 0) {
                            for (bPos = 0; bPos < datalen; bPos += nameLen * 2 + 4) {
                                nameLen = bb.getInt();
                                nameRaw = new byte[nameLen * 2 - 2];
                                bb.get(nameRaw);
                                bb.getShort();
                                nameStr = "";
                                try {
                                    nameStr = new String(nameRaw, "UNICODE");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    // empty catch block
                                }
                                this.alphaNames.add(nameStr);
                            }
                        }
                        if (Decode8BIM.isPosEven(this.psresource.position())) continue;
                        this.psresource.get();
                        continue;
                    }
                    int pos = this.psresource.position() + Decode8BIM.evenLength(datalen);
                    this.psresource.position(pos);
                    continue;
                }
                stop = true;
                this.error = true;
                continue;
            }
            stop = true;
            this.error = true;
        }
        if (this.pathList != null && pathListWON.size() > 0) {
            for (Data8BIM e : pathListWON) {
                this.pathList.add(e);
            }
        }
    }

    private static int evenLength(int len) {
        return (int)(Math.ceil((float)len / 2.0f) * 2.0);
    }

    private static boolean isPosEven(int pos) {
        return Decode8BIM.evenLength(pos) == pos;
    }

    static class CurvePoint {
        float x1;
        float y1;
        float x2;
        float y2;
        float x3;
        float y3;

        CurvePoint() {
        }

        public CurvePoint clone() {
            CurvePoint cp = new CurvePoint();
            cp.x1 = this.x1;
            cp.y1 = this.y1;
            cp.x2 = this.x2;
            cp.y2 = this.y2;
            cp.x3 = this.x3;
            cp.y3 = this.y3;
            return cp;
        }
    }
}

