/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;

public final class ICCDefaultReader {
    private static ICC_Profile iccCMYK = null;
    private static ICC_Profile iccGray = null;
    private static ICC_Profile iccRGB = null;

    public static final ICC_Profile getDefaultICCProfile(String type) throws IOException {
        ICC_Profile icc = null;
        if (type.equalsIgnoreCase("cmyk")) {
            if (iccCMYK == null) {
                InputStream iccstream = new ICCDefaultReader().getClass().getClassLoader().getResourceAsStream("com/neptunelabs/imagereader/resources/defaultCMYK.icm");
                iccCMYK = ICC_Profile.getInstance(iccstream);
                iccstream.close();
            }
            icc = iccCMYK;
        } else if (type.equalsIgnoreCase("lab")) {
            icc = ICC_Profile.getInstance("CIEXYZ.pf");
        } else if (type.equalsIgnoreCase("gray")) {
            if (iccGray == null) {
                InputStream iccstream = new ICCDefaultReader().getClass().getClassLoader().getResourceAsStream("com/neptunelabs/imagereader/resources/defaultGray.icc");
                iccGray = ICC_Profile.getInstance(iccstream);
                iccstream.close();
            }
            icc = iccGray;
        } else if (type.equalsIgnoreCase("rgb")) {
            if (iccGray == null) {
                InputStream iccstream = new ICCDefaultReader().getClass().getClassLoader().getResourceAsStream("com/neptunelabs/imagereader/resources/defaultsRGB.icc");
                iccRGB = ICC_Profile.getInstance(iccstream);
                iccstream.close();
            }
            icc = iccRGB;
        }
        return icc;
    }
}

