/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import java.awt.color.ICC_Profile;
import java.nio.ByteOrder;

public final class ICCDumper {
    public static String dump(String name, byte[] iccbytes) {
        return ICCDumper.dump(name, ICC_Profile.getInstance(iccbytes));
    }

    public static String dump(String name, ICC_Profile icc) {
        StringBuilder sb = new StringBuilder();
        if (icc != null) {
            byte[] bytes;
            float[] blackPoint;
            if (name != null) {
                sb.append("Name:" + name + "\n");
            }
            sb.append("ColorSpaceType:" + icc.getColorSpaceType() + "\n");
            sb.append("MajorVersion:" + icc.getMajorVersion() + "\n");
            sb.append("MinorVersion:" + icc.getMinorVersion() + "\n");
            sb.append("NumComponents:" + icc.getNumComponents() + "\n");
            sb.append("PCSType:" + icc.getPCSType() + "\n");
            sb.append("ProfileClass:" + icc.getProfileClass() + "\n");
            float[] whitePoint = ICCDumper.getXYZData(icc, 0x77747074);
            if (whitePoint != null) {
                sb.append("WhitePoint:" + whitePoint[0] + "x" + whitePoint[1] + "x" + whitePoint[2] + "\n");
            }
            if ((blackPoint = ICCDumper.getXYZData(icc, 1651208308)) != null) {
                sb.append("BlackPoint:" + blackPoint[0] + "x" + blackPoint[1] + "x" + blackPoint[2] + "\n");
            }
            if ((bytes = icc.getData(80)) != null) {
                sb.append("Creator:" + new String(bytes) + "\n");
            }
            if ((bytes = icc.getData(48)) != null) {
                sb.append("Manufacturer:" + new String(bytes) + "\n");
            }
            if ((bytes = icc.getData(84)) != null) {
                sb.append("ProfileID:" + new String(bytes) + "\n");
            }
            if ((bytes = icc.getData(40)) != null) {
                sb.append("Platform:" + new String(bytes) + "\n");
            }
            if ((bytes = icc.getData(1935897188)) != null) {
                sb.append("icSigScreeningDescTag:" + new String(bytes) + "\n");
            }
            if ((bytes = icc.getData(1886610801)) != null) {
                sb.append("icSigProfileSequenceDescTag:" + new String(bytes) + "\n");
            }
            if ((bytes = icc.getData(1684370275)) != null) {
                String desc = null;
                if (icc.getMajorVersion() >= 4) {
                    int len = ICCDumper.getInt(bytes, 20);
                    byte[] descRaw = new byte[len];
                    System.arraycopy(bytes, ICCDumper.getInt(bytes, 24), descRaw, 0, len);
                    desc = new String(descRaw, FileOperations.charsetUTF16BE).trim();
                } else {
                    int l;
                    for (l = ICCDumper.getInt(bytes, 8); bytes[12 + l - 1] == 0 && l > 0; --l) {
                    }
                    desc = new String(bytes, 12, l).trim();
                }
                sb.append("Description:" + desc + "\n");
            }
        }
        return sb.toString();
    }

    public static int getInt(byte[] bytes, int i) {
        int j = 0;
        for (int k = 0; k < 4; ++k) {
            j = j << 8 | 0xFF & bytes[k + i];
        }
        return j;
    }

    private static float[] getXYZData(ICC_Profile icc, int signature) {
        byte[] data = icc.getData(signature);
        if (data == null) {
            return null;
        }
        ByteArrayWalker buf = ByteArrayWalker.wrap(data, ByteOrder.BIG_ENDIAN);
        if (buf.getInt(0) != 1482250784) {
            return null;
        }
        float[] point = new float[]{(float)buf.getInt(8) / 65536.0f, (float)buf.getInt(12) / 65536.0f, (float)buf.getInt(16) / 65536.0f};
        return point;
    }
}

