/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import com.neptunelabs.imagereader.helper.RangeRelative;
import com.neptunelabs.imagereader.image.FSIImage;

public class RangePixel {
    public final int left;
    public final int top;
    public final int width;
    public final int height;
    public final int widthOrg;
    public final int heightOrg;

    private RangePixel(int left, int top, int width, int height, int widthOrg, int heightOrg) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.widthOrg = widthOrg;
        this.heightOrg = heightOrg;
    }

    public static RangePixel create(FSIImage image) {
        return RangePixel.create(image.getWidth(), image.getHeight());
    }

    public static RangePixel create(int width, int height) {
        return new RangePixel(0, 0, width, height, width, height);
    }

    public static RangePixel create(RangeRelative rr, int imageWidth, int imageHeight) {
        int left = (int)Math.floor(rr.left * (double)imageWidth);
        int top = (int)Math.floor(rr.top * (double)imageHeight);
        int width = (int)Math.ceil(rr.width * (double)imageWidth);
        int height = (int)Math.ceil(rr.height * (double)imageHeight);
        width = width < 0 ? 0 : width;
        int n = height = height < 0 ? 0 : height;
        int n2 = left < 0 ? 0 : (left = left > imageWidth - 1 ? imageWidth - 1 : left);
        int n3 = top < 0 ? 0 : (top = top > imageHeight - 1 ? imageHeight - 1 : top);
        if (left + width > imageWidth) {
            width = imageWidth - left;
        }
        if (top + height > imageHeight) {
            height = imageHeight - top;
        }
        return new RangePixel(left, top, width, height, imageWidth, imageHeight);
    }

    public static RangePixel create(RangeRelative rr, int imageWidth, int imageHeight, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight) {
        RangePixel rpInFullSize = RangePixel.create(rr, imageWidth, imageHeight);
        if (targetOffsetX > rpInFullSize.left + rpInFullSize.width || targetOffsetX + targetWidth < rpInFullSize.left || targetOffsetY > rpInFullSize.top + rpInFullSize.height || targetOffsetY + targetHeight < rpInFullSize.top) {
            return new RangePixel(0, 0, 0, 0, targetWidth, targetHeight);
        }
        int left = rpInFullSize.left > targetOffsetX ? rpInFullSize.left - targetOffsetX : 0;
        int top = rpInFullSize.top > targetOffsetY ? rpInFullSize.top - targetOffsetY : 0;
        int right = rpInFullSize.left + rpInFullSize.width > targetOffsetX + targetWidth ? targetWidth : rpInFullSize.left + rpInFullSize.width - targetOffsetX;
        int bottom = rpInFullSize.top + rpInFullSize.height > targetOffsetY + targetHeight ? targetHeight : rpInFullSize.top + rpInFullSize.height - targetOffsetY;
        int width = right - left;
        int height = bottom - top;
        return new RangePixel(left, top, width, height, targetWidth, targetHeight);
    }

    public static RangePixel create(String[] rawPixelStrings, int imageWidth, int imageHeight) {
        int left = Integer.parseInt(rawPixelStrings[0]);
        int top = Integer.parseInt(rawPixelStrings[1]);
        int width = Integer.parseInt(rawPixelStrings[2]);
        int height = Integer.parseInt(rawPixelStrings[3]);
        width = width < 0 ? 0 : width;
        int n = height = height < 0 ? 0 : height;
        int n2 = left < 0 ? 0 : (left = left > imageWidth - 1 ? imageWidth - 1 : left);
        int n3 = top < 0 ? 0 : (top = top > imageHeight - 1 ? imageHeight - 1 : top);
        if (left + width > imageWidth) {
            width = imageWidth - left;
        }
        if (top + height > imageHeight) {
            height = imageHeight - top;
        }
        return new RangePixel(left, top, width, height, imageWidth, imageHeight);
    }

    public String toString() {
        return "Pixel Range: " + this.left + ", " + this.top + ", " + this.width + ", " + this.height;
    }
}

