/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.util.concurrent.Callable;

public abstract class ReaderHelperAbstact {
    public final FSILogger logger;
    public final SwapPool swapPool;
    public final ExecutorPool executorPool;
    public final PluginLoader pluginLoader;

    public ReaderHelperAbstact(FSILogger logger, SwapPool swapPool, ExecutorPool executorPool, PluginLoader pluginLoader) {
        this.logger = logger;
        this.swapPool = swapPool;
        this.executorPool = executorPool;
        this.pluginLoader = pluginLoader;
    }

    protected class TileCopierRaster
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private final Raster raster;
        private final int tileOffsetX;
        private final int tileOffsetY;
        private final int resultOffsetX;
        private final int resultOffsetY;
        private final FSIImage targetImage;

        public TileCopierRaster(int priority, FSIImage targetImage, Raster raster, int tileOffsetX, int tileOffsetY, int resultOffsetX, int resultOffsetY) {
            this.priority = priority;
            this.targetImage = targetImage;
            this.raster = raster;
            this.tileOffsetX = tileOffsetX;
            this.tileOffsetY = tileOffsetY;
            this.resultOffsetX = resultOffsetX;
            this.resultOffsetY = resultOffsetY;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Boolean call() {
            boolean result = false;
            try {
                DataBuffer db = this.raster.getDataBuffer();
                int dbtype = db.getDataType();
                if (dbtype == 0) {
                    int bands = this.raster.getNumBands();
                    if (bands == 3) {
                        int i = 0;
                        for (int y = 0; y < this.raster.getHeight(); ++y) {
                            for (int x = 0; x < this.raster.getWidth(); ++x) {
                                if (x >= this.tileOffsetX && y >= this.tileOffsetY) {
                                    int targetX = x - this.tileOffsetX + this.resultOffsetX;
                                    int targetY = y - this.tileOffsetY + this.resultOffsetY;
                                    if (targetX < this.targetImage.getWidth() && targetY < this.targetImage.getHeight()) {
                                        int rgb = db.getElem(0, i) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i + 2);
                                        this.targetImage.setSample(targetX, targetY, rgb);
                                    }
                                }
                                i += 3;
                            }
                        }
                        result = true;
                    } else if (bands == 4) {
                        int i = 0;
                        for (int y = 0; y < this.raster.getHeight(); ++y) {
                            for (int x = 0; x < this.raster.getWidth(); ++x) {
                                if (x >= this.tileOffsetX && y >= this.tileOffsetY) {
                                    int targetX = x - this.tileOffsetX + this.resultOffsetX;
                                    int targetY = y - this.tileOffsetY + this.resultOffsetY;
                                    if (targetX < this.targetImage.getWidth() && targetY < this.targetImage.getHeight()) {
                                        int rgb = db.getElem(0, i) << 16 | db.getElem(0, i + 1) << 8 | db.getElem(0, i + 2);
                                        this.targetImage.setSample(targetX, targetY, rgb);
                                    }
                                }
                                i += 4;
                            }
                        }
                        result = true;
                    } else if (bands == 1) {
                        int i = 0;
                        for (int y = 0; y < this.raster.getHeight(); ++y) {
                            for (int x = 0; x < this.raster.getWidth(); ++x) {
                                if (x >= this.tileOffsetX && y >= this.tileOffsetY) {
                                    int targetX = x - this.tileOffsetX + this.resultOffsetX;
                                    int targetY = y - this.tileOffsetY + this.resultOffsetY;
                                    if (targetX < this.targetImage.getWidth() && targetY < this.targetImage.getHeight()) {
                                        int rgb = db.getElem(0, i);
                                        rgb = rgb << 16 | rgb << 8 | rgb;
                                        this.targetImage.setSample(targetX, targetY, rgb);
                                    }
                                }
                                ++i;
                            }
                        }
                        result = true;
                    }
                }
            }
            catch (FSIImageException e) {
                result = false;
            }
            return result;
        }
    }

    protected class TileCopierFSIImage
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private final FSIImage targetImage;
        private final FSIImage smallImage;
        private final int tileOffsetX;
        private final int tileOffsetY;
        private final int currentResultOffsetX;
        private final int currentResultOffsetY;

        public TileCopierFSIImage(int priority, FSIImage targetImage, FSIImage image, int tileOffsetX, int tileOffsetY, int currentResultOffsetX, int currentResultOffsetY) {
            this.priority = priority;
            this.smallImage = image;
            this.targetImage = targetImage;
            this.tileOffsetX = tileOffsetX;
            this.tileOffsetY = tileOffsetY;
            this.currentResultOffsetX = currentResultOffsetX;
            this.currentResultOffsetY = currentResultOffsetY;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Boolean call() {
            boolean result = false;
            if (this.smallImage != null) {
                int i = 0;
                int j = 0;
                int rasterStart = this.tileOffsetY * this.smallImage.getWidth() + this.tileOffsetX;
                int length = this.smallImage.getWidth() * this.smallImage.getHeight();
                for (int p = rasterStart; p < length; ++p) {
                    this.targetImage.setSample(i + this.currentResultOffsetX, j + this.currentResultOffsetY, this.smallImage.getSample(p));
                    if (++i == this.smallImage.getWidth() - this.tileOffsetX) {
                        i = 0;
                        ++j;
                        if (this.tileOffsetX != 0) {
                            p += this.tileOffsetX;
                        }
                    }
                    if (this.currentResultOffsetX + i == this.targetImage.getWidth()) {
                        int bytesToSkip = this.smallImage.getWidth() - i;
                        p += bytesToSkip;
                        i = 0;
                        ++j;
                    }
                    if (this.currentResultOffsetY + j == this.targetImage.getHeight()) break;
                }
                if (this.smallImage.getMode() != this.targetImage.getMode() && this.smallImage.hasAlpha()) {
                    this.targetImage.setMode(this.smallImage.getMode());
                }
                this.smallImage.dispose();
                result = true;
            }
            return result;
        }
    }

    protected class TileCopierBI
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private BufferedImageWrap biw;
        private final BufferedImageConverterThreaded converter;
        private final FSIImage targetImage;
        private final int currentResultOffsetX;
        private final int currentResultOffsetY;
        private final int tileOffsetX;
        private final int tileOffsetY;

        public TileCopierBI(int priority, BufferedImageWrap biw, BufferedImageConverterThreaded converter, FSIImage targetImage, int tileOffsetX, int tileOffsetY, int currentResultOffsetX, int currentResultOffsetY) {
            this.priority = priority;
            this.biw = biw;
            this.converter = converter;
            this.targetImage = targetImage;
            this.currentResultOffsetX = currentResultOffsetX;
            this.currentResultOffsetY = currentResultOffsetY;
            this.tileOffsetX = tileOffsetX;
            this.tileOffsetY = tileOffsetY;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Boolean call() {
            boolean result = false;
            try {
                FSIImageMode mode = this.targetImage.hasAlpha() ? FSIImageMode.ARGB : FSIImageMode.RGB;
                FSIImageLimited smallImage = new FSIImageLimited(ReaderHelperAbstact.this.logger, ReaderHelperAbstact.this.swapPool, this.targetImage.getByteOrder(), this.biw.width, this.biw.height, null, mode);
                result = this.converter.convert(this.priority, 0, ExecutorPool.Type.CONVERTER_CPU, this.biw, smallImage, 0, 0);
                TileCopierFSIImage tCopier = new TileCopierFSIImage(this.priority, this.targetImage, smallImage, this.tileOffsetX, this.tileOffsetY, this.currentResultOffsetX, this.currentResultOffsetY);
                tCopier.call();
                ((FSIImage)smallImage).dispose();
            }
            catch (Exception e) {
                ReaderHelperAbstact.this.logger.logException(e, 3804, this.biw.sourceImage, e.getLocalizedMessage());
                result = false;
            }
            catch (Error e) {
                ReaderHelperAbstact.this.logger.logError(e, 3804, this.biw.sourceImage, e.getLocalizedMessage());
                result = false;
            }
            this.biw.dispose();
            this.biw = null;
            return result;
        }
    }

    protected class DirectCopierBI
    implements Callable<Boolean>,
    PriorityExecutor.Important {
        private final int priority;
        private BufferedImageWrap biw;
        private final BufferedImageConverter converter;
        private final FSIImage targetImage;
        private final int currentResultOffsetX;
        private final int currentResultOffsetY;

        public DirectCopierBI(int priority, BufferedImageWrap biw, BufferedImageConverter converter, FSIImage targetImage, int currentResultOffsetX, int currentResultOffsetY) {
            this.priority = priority;
            this.biw = biw;
            this.converter = converter;
            this.targetImage = targetImage;
            this.currentResultOffsetX = currentResultOffsetX;
            this.currentResultOffsetY = currentResultOffsetY;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Boolean call() {
            boolean result = false;
            try {
                result = this.converter.convert(this.priority, 0, ExecutorPool.Type.CONVERTER_CPU, this.biw, this.targetImage, this.currentResultOffsetX, this.currentResultOffsetY);
            }
            catch (Exception e) {
                ReaderHelperAbstact.this.logger.logException(e, 3804, this.biw.sourceImage, e.getLocalizedMessage());
                result = false;
            }
            catch (Error e) {
                ReaderHelperAbstact.this.logger.logError(e, 3804, this.biw.sourceImage, e.getLocalizedMessage());
                result = false;
            }
            this.biw.dispose();
            this.biw = null;
            return result;
        }
    }
}

