/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import com.neptunelabs.imagereader.helper.RangePixel;
import com.neptunelabs.imagereader.image.FSIImage;

public final class Selection {
    private byte[] alphaSelection;

    public Selection() {
        this.alphaSelection = null;
    }

    public Selection(FSIImage image) {
        FSIImage slice = image.createSlice();
        int size = (int)slice.getIntSize();
        this.alphaSelection = new byte[size];
        slice.setPosition(0L);
        for (int l = 0; l < size; ++l) {
            this.alphaSelection[l] = (byte)(slice.getSample() >> 24 & 0xFF);
        }
    }

    public Selection(RangePixel range) {
        this.alphaSelection = new byte[range.widthOrg * range.heightOrg];
        int xWidth = range.left + range.width;
        int yHeight = range.top + range.height;
        for (int y = range.top; y < yHeight; ++y) {
            for (int x = range.left; x < xWidth; ++x) {
                int p = y * range.widthOrg + x;
                this.alphaSelection[p] = -1;
            }
        }
    }

    public Selection(byte[] alphaSelection) {
        this.alphaSelection = alphaSelection;
    }

    public byte[] getAlphaSelection() {
        return this.alphaSelection;
    }

    public void invert() {
        if (this.alphaSelection != null) {
            for (int c = 0; c < this.alphaSelection.length; ++c) {
                this.alphaSelection[c] = (byte)(255 - this.alphaSelection[c]);
            }
        }
    }

    public void addSelection(Selection otherSelection) {
        byte[] other = otherSelection.getAlphaSelection();
        if (this.alphaSelection != null) {
            for (int i = 0; i < other.length; ++i) {
                int value = (this.alphaSelection[i] & 0xFF) + (other[i] & 0xFF);
                if (value > 255) {
                    value = 255;
                }
                this.alphaSelection[i] = (byte)(value & 0xFF);
            }
        } else {
            this.alphaSelection = other;
        }
    }

    public void subtractSelection(Selection otherSelection) {
        if (this.alphaSelection != null) {
            byte[] other = otherSelection.getAlphaSelection();
            for (int i = 0; i < other.length; ++i) {
                int value = (this.alphaSelection[i] & 0xFF) - (other[i] & 0xFF);
                if (value < 0) {
                    value = 0;
                }
                this.alphaSelection[i] = (byte)(value & 0xFF);
            }
        }
    }
}

