/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.helper;

import com.neptunelabs.imagereader.helper.ICCDumper;
import com.neptunelabs.imagereader.helper.Rational;

public class TIFFImage
implements Comparable<TIFFImage> {
    public int imagecount = 0;
    public int width = -1;
    public int height = -1;
    public int bitspersample = 0;
    public int compression = 0;
    public int planarconfiguration = -1;
    public int photometric = -1;
    public int samplesperpixel = -1;
    public int tilewidth = -1;
    public int tileheight = -1;
    public int[] extrasamples = null;
    public Rational xResolution = null;
    public Rational yResolution = null;
    public int unitResolution = 2;
    public int orientation = -1;
    public String icc_name = null;
    public byte[] icc = null;
    public byte[] xmp = null;
    public byte[] iptc = null;
    public byte[] exif = null;
    public String software = null;
    public long next_idf = -1L;

    public float resolution(Rational r, int unit) {
        float resx = -1.0f;
        if (r != null && unit != 1) {
            long numerator = r.numerator;
            long dominator = r.denominator;
            if (unit == 2) {
                numerator *= 100L;
                dominator *= 254L;
            }
            resx = (float)(10.0 * (double)dominator / (double)numerator);
            if (unit == 2) {
                resx = (float)Math.floor(25.4f / resx);
            }
        }
        return resx;
    }

    public String toString() {
        String str;
        StringBuilder sb = new StringBuilder();
        sb.append("Tiff Image");
        if (this.software != null) {
            sb.append("Software: ");
            sb.append(this.software);
            sb.append('\n');
        }
        sb.append("Image Position: ");
        sb.append(this.imagecount);
        sb.append('\n');
        sb.append("Dimension: ");
        sb.append(this.width);
        sb.append(" x ");
        sb.append(this.height);
        sb.append('\n');
        sb.append("Resolution: ");
        sb.append(this.resolution(this.xResolution, this.unitResolution));
        sb.append(" x ");
        sb.append(this.resolution(this.yResolution, this.unitResolution));
        sb.append(' ');
        if (this.unitResolution == 1) {
            sb.append(" pixel/cm");
        } else if (this.unitResolution == 2) {
            sb.append(" pixel/inch");
        }
        sb.append('\n');
        sb.append("Tile Dimension: ");
        sb.append(this.tilewidth);
        sb.append(" x ");
        sb.append(this.tileheight);
        sb.append('\n');
        sb.append("Samples per Pixel: ");
        sb.append(this.samplesperpixel);
        sb.append('\n');
        sb.append("Bits per Samples: ");
        sb.append(this.bitspersample);
        sb.append('\n');
        sb.append("Planar Configuration: ");
        switch (this.planarconfiguration) {
            case 1: {
                sb.append("Chunky format (RGBRGBRGB)");
                break;
            }
            case 2: {
                sb.append("Separate format");
            }
        }
        sb.append('\n');
        sb.append("Compression: ");
        switch (this.compression) {
            case 1: {
                str = "None";
                break;
            }
            case 5: {
                str = "LZW";
                break;
            }
            case 6: {
                str = "OJPEG";
                break;
            }
            case 7: {
                str = "JPEG";
                break;
            }
            case 8: {
                str = "ADOBE_DEFLATE";
                break;
            }
            case 32773: {
                str = "PACKBITS";
                break;
            }
            case 32946: {
                str = "DEFLATE";
                break;
            }
            default: {
                str = "UNKNOWN";
            }
        }
        sb.append(str);
        sb.append('\n');
        sb.append("Photometric: ");
        switch (this.photometric) {
            case 2: {
                str = "RGB";
                break;
            }
            case 5: {
                str = "CMYK";
                break;
            }
            case 8: {
                str = "CIELAB";
                break;
            }
            case 9: {
                str = "ICCLAB";
                break;
            }
            case 10: {
                str = "ITULAB";
                break;
            }
            default: {
                str = "UNKNOWN";
            }
        }
        sb.append(str);
        sb.append('\n');
        sb.append('\n');
        if (this.iptc != null) {
            sb.append("IPTC:\n");
            sb.append("---------------------\n");
            sb.append('\n');
            sb.append('\n');
        }
        if (this.exif != null) {
            sb.append("EXIF:\n");
            sb.append("---------------------\n");
            sb.append('\n');
            sb.append('\n');
        }
        if (this.xmp != null) {
            sb.append("XMP:\n");
            sb.append("---------------------\n");
            sb.append('\n');
            sb.append('\n');
        }
        if (this.icc != null) {
            sb.append("ICC Profile:\n");
            sb.append("---------------------\n");
            sb.append(ICCDumper.dump(null, this.icc));
            sb.append('\n');
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(TIFFImage o) {
        if (this.width < o.width) {
            return -1;
        }
        if (this.width > o.width) {
            return 1;
        }
        return 0;
    }
}

