/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.image;

import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class FSIImage
implements CacheableData<FSIImage> {
    protected final FSILogger logger;
    protected final SwapPool swapPool;
    protected final String source;
    protected final int width;
    protected final int height;
    protected final long intSize;
    protected final long byteSize;
    protected final ByteOrder byteOrder;
    protected boolean hasalpha = false;
    protected boolean error = false;
    protected FSIImageMode mode;
    protected volatile boolean disposed = false;
    private byte[] customDataKey = null;
    private byte[] customDataValue = null;

    FSIImage(FSILogger logger, SwapPool swapPool, int width, int height, String source, FSIImageMode mode, ByteOrder byteOrder) {
        this.logger = logger;
        this.swapPool = swapPool;
        this.width = width;
        this.height = height;
        this.source = source;
        this.mode = mode;
        this.byteOrder = byteOrder;
        this.intSize = (long)width * (long)height;
        this.byteSize = this.intSize * 4L;
    }

    public abstract FSIImage createSlice() throws FSIImageException;

    public abstract FSIImage createCompatibleImage(int var1, int var2) throws FSIImageException;

    public abstract FSIImage createCompatibleImage() throws FSIImageException;

    public abstract FSIImage createCopy() throws FSIImageException;

    public abstract boolean createExtraAlpha(int var1);

    public abstract int getExtraAlphaCount();

    public abstract void copyInPlace(FSIImage var1, int var2, int var3) throws FSIImageException;

    public abstract void setSample(int var1) throws FSIImageException;

    public abstract void setSample(long var1, int var3) throws FSIImageException;

    public abstract void setSample(int var1, int var2, int var3) throws FSIImageException;

    public abstract void setSampleExtraAlpha(int var1, byte var2) throws FSIImageException;

    public abstract void setSampleExtraAlpha(int var1, long var2, byte var4) throws FSIImageException;

    public abstract void setSampleExtraAlpha(int var1, int var2, int var3, byte var4) throws FSIImageException;

    public abstract void setSampleSafe(int var1, int var2, int var3);

    public abstract void setSamples(long var1, int[] var3) throws FSIImageException;

    public abstract void setSamplesExtraAlpha(int var1, long var2, byte[] var4) throws FSIImageException;

    public abstract void setSamples(long var1, IntBuffer var3) throws FSIImageException;

    public abstract void setSamples(int var1, int var2, int var3, int var4, int[] var5) throws FSIImageException;

    public abstract int getSample() throws FSIImageException;

    public abstract int getSample(long var1) throws FSIImageException;

    public abstract int getSample(int var1, int var2) throws FSIImageException;

    public abstract byte getSampleExtraAlpha(int var1) throws FSIImageException;

    public abstract byte getSampleExtraAlpha(int var1, long var2) throws FSIImageException;

    public abstract byte getSampleExtraAlpha(int var1, int var2, int var3) throws FSIImageException;

    public abstract void getSampleFloat(int var1, int var2, float[] var3) throws FSIImageException;

    public abstract void getSampleFloat(int var1, int var2, float[] var3, int var4) throws FSIImageException;

    public abstract void getSampleRangeBytes(int var1, int var2, int var3, int var4, byte[] var5) throws FSIImageException;

    public abstract void getSampleRange(int var1, int var2, int var3, int var4, int[] var5) throws FSIImageException;

    public abstract void getSampleExtraAlphaRange(int var1, int var2, int var3, int var4, int var5, byte[] var6) throws FSIImageException;

    public abstract void getSamples(int[] var1, int var2, int var3) throws FSIImageException;

    public abstract void getSamplesExtraAlpha(int var1, byte[] var2, int var3, int var4) throws FSIImageException;

    public abstract boolean isMapped();

    public abstract void clear();

    public abstract long getPosition();

    public abstract void setPosition(long var1);

    public abstract void setPositionExtraAlpha(int var1, long var2);

    public abstract void setPosition(int var1, int var2);

    public abstract void setPositionExtraAlpha(int var1, int var2, int var3);

    public abstract void dispose() throws FSIImageException;

    public boolean hasError() {
        return this.error;
    }

    public String getSource() {
        return this.source;
    }

    public void setCustomData(byte[] key, byte[] value) {
        this.customDataKey = key;
        this.customDataValue = value;
    }

    public Pair<byte[], byte[]> getCustomData() {
        if (this.customDataKey != null && this.customDataValue != null) {
            return new Pair<byte[], byte[]>(this.customDataKey, this.customDataValue);
        }
        return null;
    }

    public abstract String toString();

    public abstract boolean addAlpha();

    public void forceAlpha(boolean state) {
        this.hasalpha = state;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getIntSize() {
        return this.intSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public FSIImageMode getMode() {
        return this.mode;
    }

    public void setMode(FSIImageMode mode) {
        this.mode = mode;
        this.hasalpha = mode == FSIImageMode.ARGB || mode == FSIImageMode.AGRAY;
    }

    public boolean hasAlpha() {
        return this.hasalpha;
    }

    public abstract boolean hasExtraAlpha();

    public boolean isImageCompatible(FSIImage otherImage) {
        return this.mode == otherImage.getMode();
    }

    public void removeAlpha() {
        if (this.hasalpha) {
            if (this.mode == FSIImageMode.ARGB) {
                this.mode = FSIImageMode.RGB;
            } else if (this.mode == FSIImageMode.AGRAY) {
                this.mode = FSIImageMode.GRAY;
            }
            this.hasalpha = false;
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setSample(x, y, 0xFF000000 | this.getSample(x, y));
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.IMAGE;
    }

    public static final FSIImage unpack(FSILogger logger, SwapPool swapPool, byte[] data) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(data, ByteOrder.nativeOrder());
        try {
            byte imageType = bb.get();
            boolean error = bb.get() == 1;
            String source = null;
            int sourceLen = bb.getInt();
            if (sourceLen > 0) {
                byte[] dst = new byte[sourceLen];
                bb.get(dst);
                source = new String(dst);
            }
            int width = bb.getInt();
            int height = bb.getInt();
            byte byteOrderByte = bb.get();
            ByteOrder byteOrder = byteOrderByte == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            byte modeInt = bb.get();
            FSIImageMode mode = FSIImageMode.values()[modeInt];
            FSIImage image = imageType == 0 ? new FSIImageLimited(logger, swapPool, byteOrder, width, height, source, mode) : new FSIImageUnlimited(logger, swapPool, byteOrder, width, height, source, mode, null, false);
            image.error = error;
            bb.getLong();
            bb.getLong();
            boolean hasalpha = bb.get() == 1;
            boolean disposed = bb.get() == 1;
            image.hasalpha = hasalpha;
            image.disposed = disposed;
            byte[] custom1 = null;
            byte[] custom2 = null;
            int leni = bb.getInt();
            if (leni > 0) {
                custom1 = new byte[leni];
                bb.get(custom1);
            }
            if ((leni = bb.getInt()) > 0) {
                custom2 = new byte[leni];
                bb.get(custom2);
            }
            image.setCustomData(custom1, custom2);
            long len = bb.getInt();
            int i = 0;
            while ((long)i < len) {
                image.setSample(bb.getInt());
                ++i;
            }
            return image;
        }
        catch (BufferUnderflowException e) {
            return null;
        }
    }

    protected static final int getPos(int x, int y, int width) {
        return y * width + x;
    }
}

