/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.image;

import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.swap.SwapByteFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapIntFileAbstract;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public final class FSIImageLimited
extends FSIImage {
    private final boolean mappedForced;
    private final SwapIntFileAbstract rgbSwapFile;
    private final IntBuffer ib;
    private SwapByteFileAbstract[] extraAlphaSwapFiles;
    private ByteBuffer[] extraAlpha;

    /*
     * Unable to fully structure code
     */
    public FSIImageLimited(FSILogger logger, SwapPool swapPool, ByteOrder forceByteOrder, int width, int height, String source, FSIImageMode mode, boolean mappedForced, SwapIntFileAbstract swapFileRGB, SwapByteFileAbstract[] swapFilesExtraAlpha, boolean makeSlice) throws FSIImageException {
        super(logger, swapPool, width, height, source, mode, forceByteOrder);
        if (makeSlice) {
            this.rgbSwapFile = swapFileRGB.makeSlice();
            if (swapFilesExtraAlpha != null) {
                this.extraAlphaSwapFiles = new SwapByteFileAbstract[swapFilesExtraAlpha.length];
                for (b = 0; b < swapFilesExtraAlpha.length; ++b) {
                    this.extraAlphaSwapFiles[b] = swapFilesExtraAlpha[b].makeSlice();
                }
            }
        } else {
            try {
                this.rgbSwapFile = swapPool.createSwapIntFile(Integer.toHexString(swapPool.getRandom().nextInt(99)), this.byteSize, true, mappedForced, forceByteOrder);
                if (this.rgbSwapFile == null || !this.rgbSwapFile.isMapped()) ** GOTO lbl18
                logger.log(3836, new Object[]{this.byteSize, width, height, source});
            }
            catch (IOException e) {
                throw new FSIImageException("Creating Image with size " + this.byteSize + " failed: " + e.getLocalizedMessage() + " :" + source);
            }
        }
lbl18:
        // 3 sources

        if (this.rgbSwapFile == null) {
            this.error = true;
        }
        this.ib = this.rgbSwapFile != null ? this.rgbSwapFile.getIntBuffer() : null;
        if (this.extraAlphaSwapFiles != null) {
            this.extraAlpha = new ByteBuffer[this.extraAlphaSwapFiles.length];
            for (b = 0; b < this.extraAlphaSwapFiles.length; ++b) {
                this.extraAlpha[b] = this.extraAlphaSwapFiles[b].getByteBuffer();
            }
        }
        this.mappedForced = mappedForced;
        this.hasalpha = mode == FSIImageMode.AGRAY || mode == FSIImageMode.ARGB;
    }

    public FSIImageLimited(FSILogger logger, SwapPool swapPool, ByteOrder byteOrder, int width, int height, String source, FSIImageMode mode, boolean mappedForced) throws FSIImageException {
        this(logger, swapPool, byteOrder, width, height, source, mode, mappedForced, null, null, false);
    }

    public FSIImageLimited(FSILogger logger, SwapPool swapPool, ByteOrder byteOrder, int width, int height, String source, FSIImageMode mode) throws FSIImageException {
        this(logger, swapPool, byteOrder, width, height, source, mode, false, null, null, false);
    }

    @Override
    public FSIImageLimited createCompatibleImage(int owidth, int oheight) throws FSIImageException {
        FSIImageLimited result = new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, owidth, oheight, this.source, this.mode, this.mappedForced, null, null, false);
        if (this.extraAlpha != null) {
            result.createExtraAlpha(this.extraAlpha.length);
        }
        return result;
    }

    @Override
    public FSIImageLimited createCompatibleImage() throws FSIImageException {
        return this.createCompatibleImage(this.width, this.height);
    }

    public FSIImageLimited createCompatibleAlphaImage() throws FSIImageException {
        FSIImageMode newMode = this.mode == FSIImageMode.RGB || this.mode == FSIImageMode.ARGB ? FSIImageMode.ARGB : FSIImageMode.AGRAY;
        return new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.width, this.height, this.source, newMode, this.mappedForced, null, null, false);
    }

    @Override
    public FSIImageLimited createCopy() throws FSIImageException {
        Pair<byte[], byte[]> customData;
        if (this.disposed) {
            throw new FSIImageException("Image already disposed: " + this.source);
        }
        FSIImageLimited result = new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.width, this.height, this.source, this.mode, this.mappedForced, null, null, false);
        try {
            this.ib.position(0);
            result.ib.position(0);
            result.ib.put(this.ib);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.ib.capacity() + " integer buffer copy " + this.intSize + " :" + this.source);
        }
        if (this.extraAlpha != null) {
            result.createExtraAlpha(this.extraAlpha.length);
            for (int b = 0; b < this.extraAlpha.length; ++b) {
                this.extraAlpha[b].position(0);
                result.extraAlpha[b].put(this.extraAlpha[b]);
            }
        }
        if ((customData = this.getCustomData()) != null) {
            byte[] originalKey = customData.getItem1();
            byte[] newKey = new byte[originalKey.length];
            System.arraycopy(originalKey, 0, newKey, 0, originalKey.length);
            byte[] originalValue = customData.getItem2();
            byte[] newValue = new byte[originalValue.length];
            System.arraycopy(originalValue, 0, newValue, 0, originalValue.length);
            result.setCustomData(newKey, newValue);
        }
        return result;
    }

    @Override
    public boolean createExtraAlpha(int banks) {
        boolean result = true;
        if (this.extraAlpha == null) {
            int b;
            this.extraAlpha = new ByteBuffer[banks];
            this.extraAlphaSwapFiles = new SwapByteFileAbstract[banks];
            int bytes = this.width * this.height;
            try {
                for (b = 0; b < banks; ++b) {
                    this.extraAlphaSwapFiles[b] = this.swapPool.createSwapByteFile(Integer.toHexString(this.swapPool.getRandom().nextInt(99)), bytes, true, this.mappedForced, this.byteOrder);
                    if (this.extraAlphaSwapFiles[b] == null) {
                        result = false;
                        break;
                    }
                    this.extraAlpha[b] = this.extraAlphaSwapFiles[b].getByteBuffer();
                }
            }
            catch (Exception e) {
                result = false;
            }
            catch (Error e) {
                result = false;
            }
            if (!result) {
                for (b = 0; b < banks; ++b) {
                    if (this.extraAlphaSwapFiles[b] == null) continue;
                    try {
                        this.swapPool.disposeSwapFile(this.extraAlphaSwapFiles[b]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int getExtraAlphaCount() {
        if (this.extraAlpha != null) {
            return this.extraAlpha.length;
        }
        return 0;
    }

    @Override
    public FSIImageLimited createSlice() throws FSIImageException {
        if (this.disposed) {
            throw new FSIImageException("Image already disposed: " + this.source);
        }
        FSIImageLimited result = new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, this.width, this.height, this.source, this.mode, this.mappedForced, this.rgbSwapFile, this.extraAlphaSwapFiles, true);
        return result;
    }

    @Override
    public void copyInPlace(FSIImage image, int posX, int posY) throws FSIImageException {
        int swidth = image.getWidth();
        int sheight = image.getHeight();
        int[] line = new int[swidth];
        byte[] lineAlpha = new byte[swidth];
        for (int y = 0; y < sheight; ++y) {
            image.setPosition(y * swidth);
            image.getSamples(line, 0, line.length);
            this.setSamples((long)(posX + (posY + y) * this.width), line);
        }
        if (image.getExtraAlphaCount() > 0) {
            this.createExtraAlpha(image.getExtraAlphaCount());
            for (int b = 0; b < this.extraAlpha.length; ++b) {
                for (int y = 0; y < sheight; ++y) {
                    image.setPositionExtraAlpha(b, y * swidth);
                    image.getSamplesExtraAlpha(b, lineAlpha, 0, lineAlpha.length);
                    this.setSamplesExtraAlpha(b, posX + (posY + y) * this.width, lineAlpha);
                }
            }
        }
    }

    @Override
    public boolean isMapped() {
        return this.rgbSwapFile.isMapped();
    }

    @Override
    public void setSample(int value) throws FSIImageException {
        try {
            this.ib.put(value);
        }
        catch (BufferOverflowException e) {
            throw new FSIImageException("BufferOverflowException in " + this.ib.capacity() + " source: " + this.source);
        }
    }

    @Override
    public void setSample(long index, int value) throws FSIImageException {
        try {
            this.ib.put((int)index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Out of range: " + index + " in " + this.ib.capacity() + " source: " + this.source);
        }
    }

    @Override
    public void setSample(int x, int y, int value) throws FSIImageException {
        try {
            this.ib.put(FSIImageLimited.getPos(x, y, this.width), value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Out of range: " + x + "x" + y + " in FSIImage " + this.width + "x" + this.height + "(" + this.ib.capacity() + ")" + " source: " + this.source);
        }
    }

    @Override
    public void setSampleExtraAlpha(int bank, byte value) throws FSIImageException {
        try {
            this.extraAlpha[bank].put(value);
        }
        catch (Exception e) {
            throw new FSIImageException("BufferOverflowException in " + this.ib.capacity() + " source: " + this.source);
        }
    }

    @Override
    public void setSampleExtraAlpha(int bank, long index, byte value) throws FSIImageException {
        try {
            this.extraAlpha[bank].put((int)index, value);
        }
        catch (Exception e) {
            throw new FSIImageException("Out of range: " + index + " in " + this.ib.capacity() + " source: " + this.source);
        }
    }

    @Override
    public void setSampleExtraAlpha(int bank, int x, int y, byte value) throws FSIImageException {
        try {
            this.extraAlpha[bank].put(y * this.width + x, value);
        }
        catch (Exception e) {
            throw new FSIImageException("Out of range: " + x + "x" + y + " in FSIImage " + this.width + "x" + this.height + "(" + this.ib.capacity() + ")" + " source: " + this.source);
        }
    }

    @Override
    public void setSampleSafe(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.ib.put(y * this.width + x, value);
        }
    }

    @Override
    public int getSample() throws FSIImageException {
        int result;
        try {
            result = this.ib.get();
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("BufferUnderflowException in " + this.ib.capacity() + " source: " + this.source);
        }
        return result;
    }

    @Override
    public int getSample(long index) throws FSIImageException {
        try {
            return this.ib.get((int)index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + index + " in " + this.ib.capacity() / 4 + " source: " + this.source);
        }
    }

    @Override
    public int getSample(int x, int y) throws FSIImageException {
        try {
            return this.ib.get(y * this.width + x);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + x + "x" + y + " in " + this.ib.capacity() / 4 + " source: " + this.source);
        }
    }

    @Override
    public byte getSampleExtraAlpha(int bank) throws FSIImageException {
        byte result;
        try {
            result = this.extraAlpha[bank].get();
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("BufferUnderflowException in " + this.ib.capacity() + " source: " + this.source);
        }
        return result;
    }

    @Override
    public byte getSampleExtraAlpha(int bank, long index) throws FSIImageException {
        try {
            return this.extraAlpha[bank].get((int)index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + index + " in " + this.ib.capacity() / 4 + " source: " + this.source);
        }
    }

    @Override
    public byte getSampleExtraAlpha(int bank, int x, int y) throws FSIImageException {
        try {
            return this.extraAlpha[bank].get(y * this.width + x);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + x + "x" + y + " in " + this.ib.capacity() / 4 + " source: " + this.source);
        }
    }

    @Override
    public void getSampleFloat(int x, int y, float[] data) throws FSIImageException {
        try {
            int argb = this.ib.get(y * this.width + x);
            data[0] = (float)(argb >>> 24) / 255.0f;
            data[1] = (float)(argb >> 16 & 0xFF) / 255.0f;
            data[2] = (float)(argb >> 8 & 0xFF) / 255.0f;
            data[3] = (float)(argb & 0xFF) / 255.0f;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + x + "x" + y + " in " + this.ib.capacity() / 4 + " source: " + this.source);
        }
    }

    @Override
    public void getSampleFloat(int x, int y, float[] data, int offset) throws FSIImageException {
        try {
            int argb = this.ib.get(y * this.width + x);
            data[offset] = (float)(argb >>> 24) / 255.0f;
            data[offset + 1] = (float)(argb >> 16 & 0xFF) / 255.0f;
            data[offset + 2] = (float)(argb >> 8 & 0xFF) / 255.0f;
            data[offset + 3] = (float)(argb & 0xFF) / 255.0f;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + x + "x" + y + " in " + this.ib.capacity() / 4 + " source: " + this.source);
        }
    }

    @Override
    public void getSampleRange(int x1, int y1, int x2, int y2, int[] data) throws FSIImageException {
        try {
            int length = x2 - x1;
            int index = 0;
            for (int y = y1; y <= y2; ++y) {
                this.ib.position(x1 + y * this.width);
                this.ib.get(data, index, length + 1);
                index += length + 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Coordinates out of range: " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
    }

    @Override
    public void getSampleExtraAlphaRange(int bank, int x1, int y1, int x2, int y2, byte[] data) throws FSIImageException {
        try {
            int length = x2 - x1;
            int index = 0;
            for (int y = y1; y <= y2; ++y) {
                this.extraAlpha[bank].position(x1 + y * this.width);
                this.extraAlpha[bank].get(data, index, length + 1);
                index += length + 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Coordinates out of range: " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
    }

    @Override
    public void getSampleRangeBytes(int x1, int y1, int x2, int y2, byte[] data) throws FSIImageException {
        int index = 0;
        int argb = 0;
        int y = 0;
        int w = x2 - x1 + 1;
        int[] line = new int[w];
        try {
            for (y = y1; y <= y2; ++y) {
                this.setPosition(x1 + y * this.width);
                this.ib.get(line, 0, line.length);
                for (int i = 0; i < w; ++i) {
                    argb = line[i];
                    data[index++] = (byte)(argb >>> 24);
                    data[index++] = (byte)(argb >> 16);
                    data[index++] = (byte)(argb >> 8);
                    data[index++] = (byte)argb;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + x1 + " " + y1 + " " + x2 + " " + y2 + "(Pos " + index + " of " + data.length + " of " + this.ib.capacity() + ") :" + this.source);
        }
    }

    @Override
    public void getSamples(int[] i, int offset, int length) throws FSIImageException {
        try {
            this.ib.get(i, offset, length);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("BufferUnderflowException :" + this.source + " " + i.length + " " + this.ib.capacity());
        }
    }

    @Override
    public void getSamplesExtraAlpha(int bank, byte[] i, int offset, int length) throws FSIImageException {
        try {
            this.extraAlpha[bank].get(i, offset, length);
        }
        catch (Exception e) {
            throw new FSIImageException("BufferUnderflowException :" + this.source + " " + i.length + " " + this.ib.capacity());
        }
    }

    public IntBuffer getSamplesBuffer() {
        if (this.disposed) {
            throw new FSIImageException("Image already disposed: " + this.source);
        }
        return this.ib;
    }

    @Override
    public void clear() {
        if (this.disposed) {
            throw new FSIImageException("Image already disposed: " + this.source);
        }
        this.ib.clear();
    }

    @Override
    public long getPosition() {
        return this.ib.position();
    }

    @Override
    public void setPosition(long pos) {
        this.ib.position((int)pos);
    }

    @Override
    public void setPositionExtraAlpha(int bank, long pos) {
        this.extraAlpha[bank].position((int)pos);
    }

    @Override
    public void setPosition(int x, int y) {
        this.ib.position(y * this.width + x);
    }

    @Override
    public void setPositionExtraAlpha(int bank, int x, int y) {
        this.extraAlpha[bank].position(y * this.width + x);
    }

    @Override
    public void setSamples(long position, int[] samples) throws FSIImageException {
        try {
            this.ib.position((int)position);
            this.ib.put(samples, 0, samples.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + this.source);
        }
    }

    @Override
    public void setSamplesExtraAlpha(int bank, long position, byte[] samples) throws FSIImageException {
        try {
            this.extraAlpha[bank].position((int)position);
            this.extraAlpha[bank].put(samples, 0, samples.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + this.source);
        }
    }

    @Override
    public void setSamples(long offset, IntBuffer samples) throws FSIImageException {
        try {
            this.ib.position((int)offset);
            this.ib.put(samples);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + this.source);
        }
    }

    @Override
    public void setSamples(int x, int y, int width, int height, int[] samples) throws FSIImageException {
        int index = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.setSample(x + j, y + i, samples[index++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws FSIImageException {
        if (!this.disposed) {
            try {
                this.swapPool.disposeSwapFile(this.rgbSwapFile);
                if (this.extraAlphaSwapFiles != null) {
                    for (SwapByteFileAbstract extraAlphaSwapFile : this.extraAlphaSwapFiles) {
                        try {
                            if (extraAlphaSwapFile == null) continue;
                            this.swapPool.disposeSwapFile(extraAlphaSwapFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                this.disposed = true;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("@" + Integer.toHexString(this.hashCode()));
        sb.append(": ");
        sb.append(this.width);
        sb.append("x");
        sb.append(this.height);
        sb.append(";Mode:");
        sb.append((Object)this.mode);
        if (this.extraAlpha != null) {
            sb.append(";extraAlpha:" + this.extraAlpha.length);
        }
        sb.append(";alpha:");
        sb.append(this.hasalpha);
        sb.append(";disposed:");
        sb.append(this.disposed);
        sb.append(";error:");
        sb.append(this.error);
        sb.append(";swapFile:");
        sb.append(this.rgbSwapFile);
        sb.append(";hash:");
        sb.append(this.getClass().hashCode());
        return sb.toString();
    }

    @Override
    public boolean addAlpha() {
        boolean result = false;
        if (!this.hasalpha) {
            this.ib.position(0);
            for (int i = 0; i < this.ib.capacity(); ++i) {
                this.ib.put(i, 0xFF000000 | this.ib.get(i) & 0xFFFFFF);
            }
            this.hasalpha = true;
            if (this.mode == FSIImageMode.RGB) {
                this.mode = FSIImageMode.ARGB;
            } else if (this.mode == FSIImageMode.GRAY) {
                this.mode = FSIImageMode.AGRAY;
            }
        }
        return false;
    }

    @Override
    public void removeAlpha() {
        if (this.hasalpha) {
            if (this.mode == FSIImageMode.ARGB) {
                this.mode = FSIImageMode.RGB;
            } else if (this.mode == FSIImageMode.AGRAY) {
                this.mode = FSIImageMode.GRAY;
            }
            this.hasalpha = false;
        }
        this.ib.position(0);
        for (int i = 0; i < this.ib.capacity(); ++i) {
            this.ib.put(i, 0xFF000000 | this.ib.get(i));
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public CacheableData<FSIImage> copy() {
        return this.createCopy();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasExtraAlpha() {
        return this.extraAlpha != null;
    }
}

