/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.image;

import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.helpers.swap.UnlimitedByteBuffer;
import com.neptunelabs.fsiframework.helpers.swap.UnlimitedIntBuffer;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public final class FSIImageUnlimited
extends FSIImage {
    private UnlimitedIntBuffer ub;
    private UnlimitedByteBuffer[] ubExtraAlpha;

    public FSIImageUnlimited(FSILogger logger, SwapPool swapPool, ByteOrder forceByteOrder, int width, int height, String source, FSIImageMode mode, UnlimitedIntBuffer ubCopy, boolean makeSlice) throws FSIImageException {
        this(logger, swapPool, forceByteOrder, width, height, source, mode, ubCopy, null, makeSlice);
    }

    public FSIImageUnlimited(FSILogger logger, SwapPool swapPool, ByteOrder forceByteOrder, int width, int height, String source, FSIImageMode mode, UnlimitedIntBuffer ubCopy, UnlimitedByteBuffer[] ubExtraAlphaCopy, boolean makeSlice) throws FSIImageException {
        super(logger, swapPool, width, height, source, mode, forceByteOrder);
        try {
            if (makeSlice && ubCopy != null) {
                this.ub = ubCopy.slice();
                if (ubExtraAlphaCopy != null) {
                    this.ubExtraAlpha = new UnlimitedByteBuffer[ubExtraAlphaCopy.length];
                    for (int i = 0; i < ubExtraAlphaCopy.length; ++i) {
                        this.ubExtraAlpha[i] = ubExtraAlphaCopy[i].slice();
                    }
                }
            } else {
                this.ub = new UnlimitedIntBuffer(swapPool, forceByteOrder, this.byteSize);
            }
            if (this.ub.hasError()) {
                this.error = true;
                this.ub.dispose();
                throw new FSIImageException("Creating MappedImage with size " + this.byteSize + " failed: " + source + " in " + swapPool.getSwapDir());
            }
        }
        catch (IOException e) {
            throw new FSIImageException("Creating MappedImage with size " + this.byteSize + " failed: " + e.getLocalizedMessage() + " :" + source);
        }
        this.hasalpha = mode == FSIImageMode.AGRAY || mode == FSIImageMode.ARGB;
    }

    @Override
    public FSIImage createCompatibleImage(int owidth, int oheight) throws FSIImageException {
        FSIImageUnlimited result = new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, owidth, oheight, this.source, this.mode, null, false);
        if (this.ubExtraAlpha != null) {
            result.createExtraAlpha(this.ubExtraAlpha.length);
        }
        return result;
    }

    @Override
    public FSIImage createCompatibleImage() throws FSIImageException {
        return this.createCompatibleImage(this.width, this.height);
    }

    @Override
    public FSIImage createCopy() throws FSIImageException {
        if (this.disposed) {
            throw new FSIImageException("Image already disposed");
        }
        FSIImageUnlimited result = new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.width, this.height, this.source, this.mode, null, false);
        try {
            int sCount = this.ub.getSwapCount();
            UnlimitedIntBuffer destUB = result.getUnlimitedBuffer();
            for (int s = 0; s < sCount; ++s) {
                destUB.copyIntBuffer(this.ub.getSwapIntBuffer(s));
            }
            this.ub.position(0L);
            destUB.position(0L);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.ub.capacity() + " unlimited buffer copy " + this.intSize + " :" + this.source);
        }
        catch (BufferOverflowException e) {
            throw new FSIImageException("BufferOverflowException in " + this.ub.capacity() + " unlimited buffer copy " + this.intSize + " :" + this.source);
        }
        if (this.ubExtraAlpha != null) {
            result.createExtraAlpha(this.ubExtraAlpha.length);
            for (int b = 0; b < this.ubExtraAlpha.length; ++b) {
                UnlimitedByteBuffer ubb = this.ubExtraAlpha[b];
                UnlimitedByteBuffer destUB = result.getExtraAlphaUnlimitedBuffer(b);
                int sCount = ubb.getSwapCount();
                for (int s = 0; s < sCount; ++s) {
                    destUB.copyByteBuffer(ubb.getSwapIntBuffer(s));
                }
                ubb.position(0L);
                destUB.position(0L);
            }
        }
        return result;
    }

    @Override
    public FSIImageUnlimited createSlice() throws FSIImageException {
        if (this.disposed) {
            throw new FSIImageException("Image already disposed");
        }
        FSIImageUnlimited result = new FSIImageUnlimited(this.logger, this.swapPool, this.byteOrder, this.width, this.height, this.source, this.mode, this.ub, this.ubExtraAlpha, true);
        return result;
    }

    @Override
    public boolean createExtraAlpha(int banks) {
        boolean result = true;
        if (this.ubExtraAlpha == null) {
            try {
                this.ubExtraAlpha = new UnlimitedByteBuffer[banks];
                int bytes = this.width * this.height;
                for (int b = 0; b < banks; ++b) {
                    try {
                        this.ubExtraAlpha[b] = new UnlimitedByteBuffer(this.swapPool, this.byteOrder, bytes);
                        continue;
                    }
                    catch (Exception e) {
                        result = false;
                        break;
                    }
                    catch (Error e) {
                        result = false;
                        break;
                    }
                }
            }
            catch (Exception e) {
                result = false;
            }
            catch (Error e) {
                result = false;
            }
            if (!result) {
                for (int b = 0; b < banks; ++b) {
                    if (this.ubExtraAlpha[b] == null) continue;
                    try {
                        this.ubExtraAlpha[b].dispose();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int getExtraAlphaCount() {
        if (this.ubExtraAlpha != null) {
            return this.ubExtraAlpha.length;
        }
        return 0;
    }

    @Override
    public void copyInPlace(FSIImage image, int posX, int posY) throws FSIImageException {
        int swidth = image.getWidth();
        int sheight = image.getHeight();
        int[] line = new int[swidth];
        byte[] lineAlpha = new byte[swidth];
        for (int y = 0; y < sheight; ++y) {
            image.setPosition(y * swidth);
            image.getSamples(line, 0, line.length);
            this.setSamples((long)(posX + (posY + y) * this.width), line);
        }
        if (image.getExtraAlphaCount() > 0) {
            this.createExtraAlpha(image.getExtraAlphaCount());
            for (int b = 0; b < this.ubExtraAlpha.length; ++b) {
                for (int y = 0; y < sheight; ++y) {
                    image.setPositionExtraAlpha(b, y * swidth);
                    image.getSamplesExtraAlpha(b, lineAlpha, 0, lineAlpha.length);
                    this.setSamplesExtraAlpha(b, posX + (posY + y) * this.width, lineAlpha);
                }
            }
        }
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    UnlimitedIntBuffer sliceBuffer() throws IOException {
        return this.ub.slice();
    }

    @Override
    public void setSample(int value) throws FSIImageException {
        try {
            this.ub.put(value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("BufferOverflowException in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void setSample(long index, int value) throws FSIImageException {
        try {
            this.ub.put(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + index + " in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void setSample(int x, int y, int value) throws FSIImageException {
        try {
            this.ub.put((long)y * (long)this.width + (long)x, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + ((long)y * (long)this.width + (long)x) + " in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void setSampleExtraAlpha(int bank, byte value) throws FSIImageException {
        try {
            this.ubExtraAlpha[bank].put(value);
        }
        catch (Exception e) {
            throw new FSIImageException("BufferOverflowException in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void setSampleExtraAlpha(int bank, long index, byte value) throws FSIImageException {
        try {
            this.ubExtraAlpha[bank].put(index, value);
        }
        catch (Exception e) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + index + " in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void setSampleExtraAlpha(int bank, int x, int y, byte value) throws FSIImageException {
        try {
            this.ubExtraAlpha[bank].put((long)y * (long)this.width + (long)x, value);
        }
        catch (Exception e) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + ((long)y * (long)this.width + (long)x) + " in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void setSampleSafe(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.ub.put((long)y * (long)this.width + (long)x, value);
        }
    }

    void setSample(UnlimitedIntBuffer fibSlice, int x, int y, int value) throws FSIImageException {
        try {
            fibSlice.put((long)y * (long)this.width + (long)x, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + ((long)y * (long)this.width + (long)x) + " in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public int getSample() throws FSIImageException {
        int result;
        try {
            result = this.ub.get();
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("BufferUnderflowException in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
        return result;
    }

    @Override
    public int getSample(long index) throws FSIImageException {
        try {
            return this.ub.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + index + " in " + this.ub.capacity() / 4L + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public int getSample(int x, int y) throws FSIImageException {
        try {
            return this.ub.get((long)y * (long)this.width + (long)x);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new FSIImageException("Position out of range (IOOB): " + x + "x" + y + " in " + this.ub.capacity() / 4L + " unlimited buffer: " + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Position out of range (BU): " + x + "x" + y + " in " + this.ub.capacity() / 4L + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public byte getSampleExtraAlpha(int bank) throws FSIImageException {
        byte result;
        try {
            result = (byte)this.ubExtraAlpha[bank].get();
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("BufferUnderflowException in " + this.ub.capacity() + " unlimited buffer: " + this.source);
        }
        return result;
    }

    @Override
    public byte getSampleExtraAlpha(int bank, long index) throws FSIImageException {
        try {
            return (byte)this.ubExtraAlpha[bank].get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + index + " in " + this.ub.capacity() / 4L + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public byte getSampleExtraAlpha(int bank, int x, int y) throws FSIImageException {
        try {
            return (byte)this.ubExtraAlpha[bank].get((long)y * (long)this.width + (long)x);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new FSIImageException("Position out of range (IOOB): " + x + "x" + y + " in " + this.ub.capacity() / 4L + " unlimited buffer: " + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Position out of range (BU): " + x + "x" + y + " in " + this.ub.capacity() / 4L + " unlimited buffer: " + this.source);
        }
    }

    @Override
    public void getSampleFloat(int x, int y, float[] data) throws FSIImageException {
        try {
            int argb = this.ub.get((long)y * (long)this.width + (long)x);
            data[0] = (float)(argb >>> 24) / 255.0f;
            data[1] = (float)(argb >> 16 & 0xFF) / 255.0f;
            data[2] = (float)(argb >> 8 & 0xFF) / 255.0f;
            data[3] = (float)(argb & 0xFF) / 255.0f;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + x + "x" + y + " in " + this.ub.capacity() / 4L + " integer buffer: " + this.source);
        }
    }

    @Override
    public void getSampleFloat(int x, int y, float[] data, int offset) throws FSIImageException {
        try {
            int argb = this.ub.get((long)y * (long)this.width + (long)x);
            data[offset] = (float)(argb >>> 24) / 255.0f;
            data[offset + 1] = (float)(argb >> 16 & 0xFF) / 255.0f;
            data[offset + 2] = (float)(argb >> 8 & 0xFF) / 255.0f;
            data[offset + 3] = (float)(argb & 0xFF) / 255.0f;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Position out of range: " + x + "x" + y + " in " + this.ub.capacity() / 4L + " integer buffer: " + this.source);
        }
    }

    @Override
    public void getSampleRange(int x1, int y1, int x2, int y2, int[] data) throws FSIImageException {
        try {
            int length = x2 - x1;
            int index = 0;
            for (int y = y1; y <= y2; ++y) {
                this.ub.position((long)x1 + (long)y * (long)this.width);
                this.ub.get(data, index, length + 1);
                index += length + 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range (IOOB): " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Coordinates out of range (BU): " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
    }

    @Override
    public void getSampleExtraAlphaRange(int bank, int x1, int y1, int x2, int y2, byte[] data) throws FSIImageException {
        try {
            int length = x2 - x1;
            int index = 0;
            for (int y = y1; y <= y2; ++y) {
                this.ubExtraAlpha[bank].position((long)x1 + (long)y * (long)this.width);
                this.ubExtraAlpha[bank].get(data, index, length + 1);
                index += length + 1;
            }
        }
        catch (Exception e) {
            throw new FSIImageException("Coordinates out of range (IOOB): " + x1 + " " + y1 + " " + x2 + " " + y2 + " :" + this.source);
        }
    }

    @Override
    public void getSampleRangeBytes(int x1, int y1, int x2, int y2, byte[] data) throws FSIImageException {
        int index = 0;
        int argb = 0;
        long y = 0L;
        int w = x2 - x1 + 1;
        int[] line = new int[w];
        try {
            for (y = (long)y1; y <= (long)y2; ++y) {
                this.ub.position((long)x1 + y * (long)this.width);
                this.ub.get(line, 0, line.length);
                for (int i = 0; i < w; ++i) {
                    argb = line[i];
                    data[index++] = (byte)(argb >>> 24);
                    data[index++] = (byte)(argb >> 16);
                    data[index++] = (byte)(argb >> 8);
                    data[index++] = (byte)argb;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range (IOOB): " + x1 + " " + y1 + " " + x2 + " " + y2 + "(Pos " + index + " of " + data.length + " and " + this.ub.capacity() + ") :" + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Coordinates out of range (BU): " + x1 + " " + y1 + " " + x2 + " " + y2 + "(Pos " + index + " of " + data.length + " and " + this.ub.capacity() + ") :" + this.source);
        }
    }

    @Override
    public void getSamples(int[] i, int offset, int length) throws FSIImageException {
        try {
            this.ub.get(i, offset, length);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("BufferUnderflowException :" + this.source);
        }
    }

    @Override
    public void getSamplesExtraAlpha(int bank, byte[] i, int offset, int length) throws FSIImageException {
        try {
            this.ubExtraAlpha[bank].get(i, offset, length);
        }
        catch (Exception e) {
            throw new FSIImageException("BufferUnderflowException :" + this.source);
        }
    }

    @Override
    public void clear() {
        if (this.disposed) {
            throw new FSIImageException("Image already disposed: " + this.source);
        }
        this.ub.clear();
    }

    @Override
    public long getPosition() {
        return this.ub.position();
    }

    @Override
    public void setPosition(long pos) {
        this.ub.position(pos);
    }

    @Override
    public void setPositionExtraAlpha(int bank, long pos) {
        this.ubExtraAlpha[bank].position(pos);
    }

    @Override
    public void setPosition(int x, int y) {
        this.ub.position((long)y * (long)this.width + (long)x);
    }

    @Override
    public void setPositionExtraAlpha(int bank, int x, int y) {
        this.ubExtraAlpha[bank].position((long)y * (long)this.width + (long)x);
    }

    @Override
    public void setSamples(long position, int[] samples) throws FSIImageException {
        int len = samples.length;
        try {
            this.ub.position(position);
            long min = UnlimitedIntBuffer.getSwapPosition(position);
            int minswap = (int)(min >> 32);
            int minnpos = (int)(min & 0xFFFFFFFFFFFFFFFFL);
            long max = UnlimitedIntBuffer.getSwapPosition(position + (long)len);
            int maxswap = (int)(max >> 32);
            int maxnpos = (int)(max & 0xFFFFFFFFFFFFFFFFL);
            if (minswap == maxswap && position + (long)len <= this.ub.capacity()) {
                this.ub.put(samples);
            } else {
                long maxPos = Math.min((long)len, this.ub.capacity() - this.ub.position());
                int c = 0;
                long s = 0L;
                while (s < maxPos) {
                    this.ub.put(samples[c]);
                    ++s;
                    ++c;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + this.source + " (SL:" + len + " P:" + position + ")\n" + this.ub);
        }
    }

    @Override
    public void setSamplesExtraAlpha(int bank, long position, byte[] samples) throws FSIImageException {
        int len = samples.length;
        try {
            this.ubExtraAlpha[bank].position(position);
            long min = UnlimitedIntBuffer.getSwapPosition(position);
            int minswap = (int)(min >> 32);
            int minnpos = (int)(min & 0xFFFFFFFFFFFFFFFFL);
            long max = UnlimitedIntBuffer.getSwapPosition(position + (long)len);
            int maxswap = (int)(max >> 32);
            int maxnpos = (int)(max & 0xFFFFFFFFFFFFFFFFL);
            if (minswap == maxswap && position + (long)len <= this.ub.capacity()) {
                this.ubExtraAlpha[bank].put(samples);
            } else {
                long maxPos = Math.min((long)len, this.ub.capacity() - this.ub.position());
                int c = 0;
                long s = 0L;
                while (s < maxPos) {
                    this.ubExtraAlpha[bank].put(samples[c]);
                    ++s;
                    ++c;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + this.source + " (SL:" + len + " P:" + position + ")\n" + this.ub);
        }
    }

    @Override
    public void setSamples(long position, IntBuffer samples) throws FSIImageException {
        try {
            this.ub.position(position);
            int len = samples.capacity();
            long min = UnlimitedIntBuffer.getSwapPosition(position);
            int minswap = (int)(min >> 32);
            int minnpos = (int)(min & 0xFFFFFFFFFFFFFFFFL);
            long max = UnlimitedIntBuffer.getSwapPosition(position + (long)len);
            int maxswap = (int)(max >> 32);
            int maxnpos = (int)(max & 0xFFFFFFFFFFFFFFFFL);
            if (minswap == maxswap && position + (long)len <= this.ub.capacity()) {
                samples.position(0);
                this.ub.copyIntBuffer(samples);
            } else {
                long maxPos = Math.min((long)len, this.ub.capacity() - this.ub.position()) + position;
                samples.position(0);
                for (long s = position; s < maxPos; ++s) {
                    this.ub.put(samples.get());
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new FSIImageException("Coordinates out of range (IOOB): " + this.source);
        }
        catch (BufferOverflowException e) {
            throw new FSIImageException("Coordinates out of range (BO): " + this.source);
        }
        catch (BufferUnderflowException e) {
            throw new FSIImageException("Coordinates out of range (BU): " + this.source);
        }
    }

    @Override
    public void setSamples(int x, int y, int width, int height, int[] samples) throws FSIImageException {
        int index = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.setSample(x + j, y + i, samples[index++]);
            }
        }
    }

    @Override
    public void dispose() throws FSIImageException {
        if (!this.disposed) {
            try {
                this.ub.dispose();
                if (this.ubExtraAlpha != null) {
                    for (int b = 0; b < this.ubExtraAlpha.length; ++b) {
                        try {
                            this.ubExtraAlpha[b].dispose();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new FSIImageException("Dispose Image failed: " + e.getLocalizedMessage() + " :" + this.source);
            }
            finally {
                this.disposed = true;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("@" + Integer.toHexString(this.hashCode()));
        sb.append(": ");
        sb.append(this.width);
        sb.append("x");
        sb.append(this.height);
        sb.append(";Mode:");
        sb.append((Object)this.mode);
        if (this.ubExtraAlpha != null) {
            sb.append(";extraAlpha:" + this.ubExtraAlpha.length);
        }
        sb.append(";alpha:");
        sb.append(this.hasalpha);
        sb.append(";disposed:");
        sb.append(this.disposed);
        sb.append(";error:");
        sb.append(this.error);
        sb.append(";ub:");
        sb.append(this.ub);
        sb.append(";hash:");
        return sb.toString();
    }

    @Override
    public boolean addAlpha() {
        boolean result = false;
        try {
            if (!this.hasalpha) {
                this.ub.position(0L);
                for (long i = 0L; i < this.ub.capacity(); ++i) {
                    this.ub.put(i, 0xFF000000 | this.ub.get(i));
                }
                this.hasalpha = true;
            }
            if (this.mode == FSIImageMode.RGB) {
                this.mode = FSIImageMode.ARGB;
            } else if (this.mode == FSIImageMode.GRAY) {
                this.mode = FSIImageMode.AGRAY;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new FSIImageException("Coordinates out of range: " + this.source);
        }
        return false;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public UnlimitedIntBuffer getUnlimitedBuffer() {
        return this.ub;
    }

    public UnlimitedByteBuffer getExtraAlphaUnlimitedBuffer(int bank) {
        return this.ubExtraAlpha[bank];
    }

    @Override
    public CacheableData<FSIImage> copy() {
        return this.createCopy();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasExtraAlpha() {
        return this.ubExtraAlpha != null;
    }
}

