/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.iptc;

import com.neptunelabs.fsiframework.helpers.FloatingParser;
import com.neptunelabs.imagereader.iptc.Rational;
import com.neptunelabs.imagereader.iptc.Tag;
import com.neptunelabs.imagereader.iptc.TagDescriptor;
import com.neptunelabs.imagereader.iptc.exception.IptcDataException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Directory {
    protected final Map<Integer, Object> _tagMap = new HashMap<Integer, Object>();
    protected TagDescriptor _descriptor;
    protected final List<Tag> _definedTagList = new ArrayList<Tag>();
    private List<String> _errorList;

    public abstract String getName();

    protected abstract Map<Integer, String> getTagNameMap();

    public boolean containsTag(int tagType) {
        return this._tagMap.containsKey(new Integer(tagType));
    }

    public Iterator<Tag> getTagIterator() {
        return this._definedTagList.iterator();
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(TagDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = descriptor;
    }

    public void addError(String message) {
        if (this._errorList == null) {
            this._errorList = new ArrayList<String>();
        }
        this._errorList.add(message);
    }

    public boolean hasErrors() {
        return this._errorList != null && this._errorList.size() > 0;
    }

    public Iterator<String> getErrors() {
        return this._errorList.iterator();
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public void setInt(int tagType, int value) {
        this.setObject(tagType, new Integer(value));
    }

    public void setDouble(int tagType, double value) {
        this.setObject(tagType, new Double(value));
    }

    public void setFloat(int tagType, float value) {
        this.setObject(tagType, new Float(value));
    }

    public void setString(int tagType, String value) {
        this.setObject(tagType, value);
    }

    public void setBoolean(int tagType, boolean value) {
        this.setObject(tagType, new Boolean(value));
    }

    public void setLong(int tagType, long value) {
        this.setObject(tagType, new Long(value));
    }

    public void setDate(int tagType, Date value) {
        this.setObject(tagType, value);
    }

    public void setCalendar(int tagType, Calendar value) {
        this.setObject(tagType, value);
    }

    public void setRational(int tagType, Rational rational) {
        this.setObject(tagType, rational);
    }

    public void setRationalArray(int tagType, Rational[] rationals) {
        this.setObjectArray(tagType, rationals);
    }

    public void setIntArray(int tagType, int[] ints) {
        this.setObjectArray(tagType, ints);
    }

    public void setByteArray(int tagType, byte[] bytes) {
        this.setObjectArray(tagType, bytes);
    }

    public void setStringArray(int tagType, String[] strings) {
        this.setObjectArray(tagType, strings);
    }

    public void setObject(int tagType, Object value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null object for tagType: " + tagType);
        }
        Integer key = new Integer(tagType);
        if (!this._tagMap.containsKey(key)) {
            this._definedTagList.add(new Tag(tagType, this));
        }
        this._tagMap.put(key, value);
    }

    public void setObjectArray(int tagType, Object array) {
        this.setObject(tagType, array);
    }

    public int getInt(int tagType) throws IptcDataException {
        int[] ints;
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException nfe) {
                String s = (String)o;
                byte[] bytes = s.getBytes();
                long val = 0L;
                for (int i = 0; i < bytes.length; ++i) {
                    val <<= 8;
                    val += (long)(bytes[i] & 0xFF);
                }
                return (int)val;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            if (rationals.length == 1) {
                return rationals[0].intValue();
            }
        } else if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            if (bytes.length == 1) {
                return bytes[0];
            }
        } else if (o instanceof int[] && (ints = (int[])o).length == 1) {
            return ints[0];
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to int.  It is of type '" + o.getClass() + "'.");
    }

    public String[] getStringArray(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String[]) {
            String[] strarr = (String[])o;
            return Arrays.copyOf(strarr, strarr.length);
        }
        if (o instanceof String) {
            String[] strings = new String[]{(String)o};
            return strings;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            String[] strings = new String[ints.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Integer.toString(ints[i]);
            }
            return strings;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            String[] strings = new String[bytes.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Byte.toString(bytes[i]);
            }
            return strings;
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            String[] strings = new String[rationals.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = rationals[i].toSimpleString(false);
            }
            return strings;
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to an String array.  It is of type '" + o.getClass() + "'.");
    }

    public int[] getIntArray(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            int[] ints = new int[rationals.length];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = rationals[i].intValue();
            }
            return ints;
        }
        if (o instanceof int[]) {
            int[] intarr = (int[])o;
            return Arrays.copyOf(intarr, intarr.length);
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            int[] ints = new int[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                int b;
                ints[i] = b = bytes[i];
            }
            return ints;
        }
        if (o instanceof String) {
            String str = (String)o;
            int[] ints = new int[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                ints[i] = str.charAt(i);
            }
            return ints;
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to an int array.  It is of type '" + o.getClass() + "'.");
    }

    public byte[] getByteArray(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            byte[] bytes = new byte[rationals.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = rationals[i].byteValue();
            }
            return bytes;
        }
        if (o instanceof byte[]) {
            byte[] bytearr = (byte[])o;
            return Arrays.copyOf(bytearr, bytearr.length);
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            byte[] bytes = new byte[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                bytes[i] = (byte)ints[i];
            }
            return bytes;
        }
        if (o instanceof String) {
            String str = (String)o;
            byte[] bytes = new byte[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                bytes[i] = (byte)str.charAt(i);
            }
            return bytes;
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a byte array.  It is of type '" + o.getClass() + "'.");
    }

    public double getDouble(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return FloatingParser.parseDouble((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new IptcDataException("unable to parse string " + o + " as a double", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a double.  It is of type '" + o.getClass() + "'.");
    }

    public float getFloat(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new IptcDataException("unable to parse string " + o + " as a float", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a float.  It is of type '" + o.getClass() + "'.");
    }

    public long getLong(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new IptcDataException("unable to parse string " + o + " as a long", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a long.  It is of type '" + o.getClass() + "'.");
    }

    public boolean getBoolean(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.getBoolean((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new IptcDataException("unable to parse string " + o + " as a boolean", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a boolean.  It is of type '" + o.getClass() + "'.");
    }

    public Calendar getCalendar(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Calendar) {
            return (Calendar)o;
        }
        if (o instanceof String) {
            String[] datePatterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String dateString = (String)o;
            SimpleDateFormat parser = null;
            for (int i = 0; i < datePatterns.length; ++i) {
                try {
                    parser = new SimpleDateFormat(datePatterns[i]);
                    parser.parse(dateString);
                    return parser.getCalendar();
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a java.util.Date.  It is of type '" + o.getClass() + "'.");
    }

    public Rational getRational(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational) {
            return (Rational)o;
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a Rational.  It is of type '" + o.getClass() + "'.");
    }

    public Rational[] getRationalArray(int tagType) throws IptcDataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new IptcDataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational[]) {
            return (Rational[])o;
        }
        throw new IptcDataException("Tag '" + tagType + "' cannot be cast to a Rational array.  It is of type '" + o.getClass() + "'.");
    }

    public String getString(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Rational) {
            return ((Rational)o).toSimpleString(true);
        }
        if (o.getClass().isArray()) {
            int arrayLength = Array.getLength(o);
            boolean isObjectArray = o.getClass().toString().startsWith("class [L");
            StringBuffer sbuffer = new StringBuffer();
            for (int i = 0; i < arrayLength; ++i) {
                if (i != 0) {
                    sbuffer.append(' ');
                }
                if (isObjectArray) {
                    sbuffer.append(Array.get(o, i).toString());
                    continue;
                }
                sbuffer.append(Array.getInt(o, i));
            }
            return sbuffer.toString();
        }
        return o.toString();
    }

    public Object getObject(int tagType) {
        return this._tagMap.get(new Integer(tagType));
    }

    public Object getObject(Integer tagType) {
        return this._tagMap.get(tagType);
    }

    public String getTagName(int tagType) {
        Integer key = new Integer(tagType);
        Map<Integer, String> nameMap = this.getTagNameMap();
        if (!nameMap.containsKey(key)) {
            String hex = Integer.toHexString(tagType);
            while (hex.length() < 4) {
                hex = "0" + hex;
            }
            return "Unknown tag (0x" + hex + ")";
        }
        return nameMap.get(key);
    }

    public String getDescription(int tagType) throws IptcDataException {
        if (this._descriptor == null) {
            throw new IptcDataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this._descriptor.getDescription(tagType);
    }
}

