/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.iptc;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.imagereader.iptc.Directory;
import com.neptunelabs.imagereader.iptc.IptcDescriptor;
import com.neptunelabs.imagereader.iptc.Tag;
import com.neptunelabs.imagereader.iptc.exception.IptcDataException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IptcDirectory
extends Directory {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private final DateFormat dateOutputFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat timeOutputFormat = new SimpleDateFormat("HH:mm:ss Z");
    public static final int TAG_CHARSET = 346;
    public static final int TAG_RECORD_VERSION = 512;
    public static final int TAG_OBJECT_NAME = 517;
    public static final int TAG_URGENCY = 522;
    public static final int TAG_CATEGORY = 527;
    public static final int TAG_SUPPLEMENTAL_CATEGORIES = 532;
    public static final int TAG_KEYWORDS = 537;
    public static final int TAG_RELEASE_DATE = 542;
    public static final int TAG_RELEASE_TIME = 547;
    public static final int TAG_SPECIAL_INSTRUCTIONS = 552;
    public static final int TAG_DATE_CREATED = 567;
    public static final int TAG_TIME_CREATED = 572;
    public static final int TAG_DATE_DIGITAL_CREATION = 574;
    public static final int TAG_TIME_DIGITAL_CREATION = 575;
    public static final int TAG_ORIGINATING_PROGRAM = 577;
    public static final int TAG_BY_LINE = 592;
    public static final int TAG_BY_LINE_TITLE = 597;
    public static final int TAG_CITY = 602;
    public static final int TAG_SUBLOCATION = 604;
    public static final int TAG_PROVINCE_OR_STATE = 607;
    public static final int TAG_COUNTRY_CODE = 612;
    public static final int TAG_COUNTRY_OR_PRIMARY_LOCATION = 613;
    public static final int TAG_ORIGINAL_TRANSMISSION_REFERENCE = 615;
    public static final int TAG_HEADLINE = 617;
    public static final int TAG_CREDIT = 622;
    public static final int TAG_SOURCE = 627;
    public static final int TAG_COPYRIGHT_NOTICE = 628;
    public static final int TAG_CONTACT = 630;
    public static final int TAG_CAPTION = 632;
    public static final int TAG_WRITER = 634;
    public static final int TAG_FSI_XMLDATA = 735;
    public static final int TAG_FSI_SEARCHDATA = 737;
    public static final int TAG_FSI_TILESX = 732;
    public static final int TAG_FSI_TILESY = 733;
    public static final int TAG_FSI_SCENESETS = 734;
    public static final int TAG_FSI_ENCODING = 736;
    private static final Map<Integer, String> tagNameMap = new HashMap<Integer, String>();
    private static final List<String> tagSortList = new ArrayList<String>();

    public static void registerTag(int tagNumber, String tagName) {
        tagNameMap.put(tagNumber, tagName);
        tagSortList.add(tagName);
    }

    public static String getDefinedTagName(Integer key) {
        if (tagNameMap.containsKey(key)) {
            return tagNameMap.get(key);
        }
        return "UNKNOWN";
    }

    public IptcDirectory() {
        this.setDescriptor(new IptcDescriptor(this));
    }

    public void setDate(int tagType, Calendar dateCal) {
        this.setCalendar(tagType, dateCal);
    }

    public void setTime(int tagType, Calendar timeCal) {
        this.setCalendar(tagType, timeCal);
    }

    public boolean knowsTag(int tagType) {
        return tagNameMap.containsKey(tagType);
    }

    @Override
    public final String getName() {
        return "IPTC";
    }

    @Override
    public final Map<Integer, String> getTagNameMap() {
        return tagNameMap;
    }

    public final String getTagName(Integer tagType) {
        if (tagNameMap.containsKey(tagType)) {
            return tagNameMap.get(tagType);
        }
        return null;
    }

    @Override
    public final String getTagName(int tagType) {
        return this.getTagName(new Integer(tagType));
    }

    public final Integer[] getTagTypes() {
        return tagNameMap.keySet().toArray(new Integer[tagNameMap.size()]);
    }

    public final String[] getTagNames() {
        return tagNameMap.values().toArray(new String[tagNameMap.size()]);
    }

    public final Integer getTagType(String name) {
        try {
            return this.getTagTypesByName(name, true)[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Tag[] getCurrentTags() {
        return this._definedTagList.toArray(new Tag[this._definedTagList.size()]);
    }

    public final Integer[] getCurrentTagTypes() {
        Integer[] tagTypes = new Integer[this._definedTagList.size()];
        int index = -1;
        for (Tag tag : this._definedTagList) {
            tagTypes[++index] = new Integer(tag.getTagType());
        }
        return tagTypes;
    }

    @Override
    public String getDescription(int tagType) throws IptcDataException {
        switch (tagType) {
            case 542: 
            case 547: 
            case 567: 
            case 572: 
            case 574: 
            case 575: {
                try {
                    return this.dateFormat.format(this.getCalendar(tagType).getTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.getDescription(tagType);
    }

    public final Integer[] getTagTypesByName(String name, boolean exactMatch) {
        Set<Map.Entry<Integer, String>> entries = tagNameMap.entrySet();
        if (entries.size() > 0) {
            Iterator<Map.Entry<Integer, String>> i = entries.iterator();
            Map.Entry<Integer, String> entry = null;
            ArrayList<Integer> tagTypeList = new ArrayList<Integer>();
            if (exactMatch) {
                while (i.hasNext()) {
                    entry = i.next();
                    if (!entry.getValue().equals(name)) continue;
                    tagTypeList.add(entry.getKey());
                }
            } else {
                while (i.hasNext()) {
                    entry = i.next();
                    name = name.toLowerCase();
                    if (entry.getValue().toLowerCase().indexOf(name) <= -1) continue;
                    tagTypeList.add(entry.getKey());
                }
            }
            return tagTypeList.toArray(new Integer[tagTypeList.size()]);
        }
        return null;
    }

    public String toString() {
        Tag[] tags;
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags = this.getCurrentTags()) {
            try {
                sb.append("\n");
                sb.append(tag.toString());
            }
            catch (Exception e) {
                sb.append("[" + tag.getTagType() + "]\t" + e);
            }
        }
        return sb.toString();
    }

    public Map<Pair<String, String>, String> getIptcMap() {
        Tag[] tags;
        HashMap<Pair<String, String>, String> map = new HashMap<Pair<String, String>, String>();
        for (Tag tag : tags = this.getCurrentTags()) {
            try {
                switch (tag.getTagType()) {
                    case 547: 
                    case 572: 
                    case 575: {
                        map.put(new Pair<String, String>(tag.getTagTypeHex(), tag.getTagName()), this.timeOutputFormat.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    case 542: 
                    case 567: 
                    case 574: {
                        map.put(new Pair<String, String>(tag.getTagTypeHex(), tag.getTagName()), this.dateOutputFormat.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    default: {
                        map.put(new Pair<String, String>(tag.getTagTypeHex(), tag.getTagName()), this.getString(tag.getTagType()));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public Map<String, String> getIptcSimpleMap() {
        Tag[] tags;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Tag tag : tags = this.getCurrentTags()) {
            try {
                switch (tag.getTagType()) {
                    case 547: 
                    case 572: 
                    case 575: {
                        map.put(tag.getTagName(), this.timeOutputFormat.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    case 542: 
                    case 567: 
                    case 574: {
                        map.put(tag.getTagName(), this.dateOutputFormat.format(this.getCalendar(tag.getTagType()).getTime()));
                        break;
                    }
                    default: {
                        map.put(tag.getTagName(), this.getString(tag.getTagType()));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public List<Pair<String, String>> getIptcSortedList() {
        Map<String, String> map = this.getIptcSimpleMap();
        List<Pair<String, String>> list = IptcDirectory.getSortedListFromMap(map);
        return list;
    }

    public static List<Pair<String, String>> getSortedListFromMap(Map<String, String> iptcMap) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (String string : tagSortList) {
            String value = iptcMap.get(string);
            if (value == null) continue;
            result.add(new Pair<String, String>(string, value));
            iptcMap.remove(string);
        }
        for (Map.Entry entry : iptcMap.entrySet()) {
            result.add(new Pair(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    static {
        IptcDirectory.registerTag(512, "Directory Version");
        IptcDirectory.registerTag(567, "Date Created");
        IptcDirectory.registerTag(628, "Copyright Notice");
        IptcDirectory.registerTag(634, "Writer");
        IptcDirectory.registerTag(617, "Headline");
        IptcDirectory.registerTag(592, "By-line");
        IptcDirectory.registerTag(597, "By-line Title");
        IptcDirectory.registerTag(622, "Credit");
        IptcDirectory.registerTag(627, "Source");
        IptcDirectory.registerTag(517, "Object Name");
        IptcDirectory.registerTag(527, "Category");
        IptcDirectory.registerTag(532, "Supplemental Category(s)");
        IptcDirectory.registerTag(602, "City");
        IptcDirectory.registerTag(604, "Sublocation");
        IptcDirectory.registerTag(607, "Province/State");
        IptcDirectory.registerTag(612, "Country Code");
        IptcDirectory.registerTag(613, "Country/Primary Location");
        IptcDirectory.registerTag(615, "Original Transmission Reference");
        IptcDirectory.registerTag(522, "Urgency");
        IptcDirectory.registerTag(542, "Release Date");
        IptcDirectory.registerTag(547, "Release Time");
        IptcDirectory.registerTag(572, "Time Created");
        IptcDirectory.registerTag(577, "Originating Program");
        IptcDirectory.registerTag(552, "Special Instructions");
        IptcDirectory.registerTag(537, "Keywords");
        IptcDirectory.registerTag(630, "Contact");
        IptcDirectory.registerTag(632, "Caption");
        IptcDirectory.registerTag(574, "Digital Creation Date");
        IptcDirectory.registerTag(575, "Digital Creation Time");
        IptcDirectory.registerTag(736, "FSI Encoding");
        IptcDirectory.registerTag(737, "FSI Search Data");
        IptcDirectory.registerTag(735, "FSI Extra");
        IptcDirectory.registerTag(732, "FSI Tiles X");
        IptcDirectory.registerTag(733, "FSI Tiles Y");
        IptcDirectory.registerTag(734, "FSI SceneSets");
        IptcDirectory.registerTag(276, "File Format");
        IptcDirectory.registerTag(278, "File Format Version");
        IptcDirectory.registerTag(336, "Time Sent");
        IptcDirectory.registerTag(306, "Product ID");
        IptcDirectory.registerTag(316, "Envelope Priority");
        IptcDirectory.registerTag(286, "Service Identifier");
        IptcDirectory.registerTag(326, "Date Sent");
        IptcDirectory.registerTag(261, "Destination");
        IptcDirectory.registerTag(256, "Record Version");
        IptcDirectory.registerTag(296, "Envelope Number");
        IptcDirectory.registerTag(549, "Expiration Date");
        IptcDirectory.registerTag(550, "Expiration Time");
        IptcDirectory.registerTag(582, "Program Version");
        IptcDirectory.registerTag(698, "Short Document ID");
        IptcDirectory.registerTag(699, "Unique Document ID");
        IptcDirectory.registerTag(695, "Character Set");
    }
}

