/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.iptc;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.imagereader.iptc.IptcDirectory;
import com.neptunelabs.imagereader.iptc.Tag;
import com.neptunelabs.imagereader.iptc.exception.IptcDataException;
import com.neptunelabs.imagereader.iptc.exception.IptcProcessingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class IptcDirectoryReader {
    private static final String[] timePatterns = new String[]{"HHmmss", "HHmmssZ", "HHmmss Z", "HH:mm:ss Z", "HH:mm:ss", "HH:mm"};
    private static final SimpleDateFormat[] simpleDateFormatter = new SimpleDateFormat[timePatterns.length];
    private int year;
    private int month;
    private int day = 0;
    private static final Charset charsetISO8859_1;
    private static final Charset charsetUTF8;

    public static final IptcDirectory getIptcDirectory(byte[] bytes) {
        return new IptcDirectoryReader().getIptcDirectory(new IptcDirectory(), bytes);
    }

    private final IptcDirectory getIptcDirectory(IptcDirectory iptcDirectory, byte[] bytes) {
        if (bytes == null) {
            return iptcDirectory;
        }
        Charset charset = charsetISO8859_1;
        Charset specificFSICharset = this.scanIptcDirectoryForFSISpecificCharset(iptcDirectory, bytes, false);
        int offset = 0;
        byte directoryType = 0;
        int tagType = 0;
        int tagByteCount = 0;
        int tagIdentifier = 0;
        while (offset < bytes.length) {
            try {
                Charset newcharset;
                if (bytes[offset] != 28) {
                    ++offset;
                    continue;
                }
                if (offset + 5 >= bytes.length) {
                    iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " not enough bytes available for IPTC tag(offset + 5) >= bytes.length   OFFSET: " + offset + "  BYTESLENGTH: " + bytes.length);
                    break;
                }
                ++offset;
                try {
                    directoryType = bytes[offset++];
                    tagType = bytes[offset++] & 0xFF;
                    tagByteCount = this.get2Bytes(offset, bytes);
                    tagIdentifier = tagType | directoryType << 8;
                }
                catch (IptcDataException e) {
                    iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " IPTC data segment ended mid-way through tag descriptor");
                    return iptcDirectory;
                }
                if (tagIdentifier > 767 || tagIdentifier < 0) {
                    if (iptcDirectory.hasErrors() && iptcDirectory.getErrorCount() > 9) {
                        iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " more than 10 errors occured - stop scanning for IPTC tags at OFFSET: " + offset + "  BYTECOUNT: " + tagByteCount + "  BUFFERLENGTH:" + bytes.length);
                        break;
                    }
                    iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " unknown tag identifier at OFFSET: " + offset + "  BYTECOUNT: " + tagByteCount + "  BUFFERLENGTH:" + bytes.length);
                    continue;
                }
                if (this.isIptcStartTag(bytes, offset + tagByteCount)) continue;
                if ((offset += 2) + tagByteCount > bytes.length) {
                    if (offset + tagByteCount > bytes.length + 1) {
                        iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " data for tag extends beyond end of iptc segment  OFFSET: " + offset + "  BYTECOUNT: " + tagByteCount + "  BUFFERLENGTH:" + bytes.length);
                    }
                    tagByteCount = bytes.length - offset;
                }
                if (tagByteCount == 32772) {
                    try {
                        tagByteCount = this.get2Bytes(offset + 2, bytes);
                    }
                    catch (IptcDataException e) {
                        iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " IPTC data segment ended mid-way through tag descriptor");
                        return iptcDirectory;
                    }
                    offset += 4;
                }
                if (specificFSICharset != null) {
                    switch (tagIdentifier) {
                        case 632: 
                        case 732: 
                        case 733: 
                        case 734: 
                        case 735: 
                        case 737: {
                            this.processTag(iptcDirectory, bytes, directoryType, tagType, offset, tagByteCount, specificFSICharset);
                            break;
                        }
                        default: {
                            newcharset = this.processTag(iptcDirectory, bytes, directoryType, tagType, offset, tagByteCount, charset);
                            if (newcharset != null) {
                                charset = newcharset;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else {
                    newcharset = this.processTag(iptcDirectory, bytes, directoryType, tagType, offset, tagByteCount, charset);
                    if (newcharset != null) {
                        charset = newcharset;
                    }
                }
                offset += tagByteCount - 1;
            }
            catch (IptcProcessingException ipe) {
                iptcDirectory.addError("getIptcDirectory " + ipe);
            }
            catch (Throwable t) {
                String message = "getIptcDirectory " + Tag.getTagTypeInfo(tagIdentifier) + " byteslength:" + bytes.length + " offset: " + offset + " tagbytecount: " + tagByteCount + " charset: " + charset + " >> ";
                iptcDirectory.addError(message + t);
            }
        }
        return iptcDirectory;
    }

    private final Charset scanIptcDirectoryForFSISpecificCharset(IptcDirectory iptcDirectory, byte[] bytes, boolean addErrorMessages) {
        if (bytes == null) {
            return null;
        }
        String fsiEncodingString = null;
        int offset = 0;
        byte directoryType = 0;
        int tagType = 0;
        int tagByteCount = 0;
        int tagIdentifier = 0;
        while (offset < bytes.length) {
            if (bytes[offset] != 28) {
                ++offset;
                continue;
            }
            if (offset + 5 >= bytes.length) {
                if (!addErrorMessages) break;
                iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " not enough bytes available for IPTC tag(offset + 5) >= bytes.length   OFFSET: " + offset + "  BYTESLENGTH: " + bytes.length);
                break;
            }
            ++offset;
            try {
                directoryType = bytes[offset++];
                tagType = bytes[offset++] & 0xFF;
                tagByteCount = this.get2Bytes(offset, bytes);
                tagIdentifier = tagType | directoryType << 8;
            }
            catch (IptcDataException e) {
                if (addErrorMessages) {
                    iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " IPTC data segment ended mid-way through tag descriptor OFFSET: " + offset);
                }
                return null;
            }
            if (!this.isIptcStartTag(bytes, offset + tagByteCount)) {
                offset += 2;
            } else if (addErrorMessages) {
                iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " No data found: IPTC tag 0x1c at OFFSET: " + offset + "  BYTECOUNT: " + tagByteCount + "  BUFFERLENGTH:" + bytes.length);
            }
            if (offset + tagByteCount > bytes.length) {
                if (addErrorMessages && offset + tagByteCount > bytes.length + 1) {
                    iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " data for tag extends beyond end of iptc segment  OFFSET: " + offset + "  BYTECOUNT: " + tagByteCount + "  BUFFERLENGTH:" + bytes.length);
                }
                tagByteCount = bytes.length - offset;
            }
            if (tagIdentifier == 736) {
                fsiEncodingString = new String(bytes, offset, tagByteCount, charsetISO8859_1);
                break;
            }
            offset += tagByteCount;
        }
        if (fsiEncodingString != null && !fsiEncodingString.equals("")) {
            try {
                return Charset.forName(fsiEncodingString);
            }
            catch (Exception e) {
                return null;
            }
        }
        return charsetUTF8;
    }

    private final boolean isIptcStartTag(byte[] bytes, int offset) {
        return offset + 1 < bytes.length && bytes[offset] == 28 && bytes[offset + 1] == 2;
    }

    private final int get2Bytes(int offset, byte[] bytes) throws IptcDataException {
        if (offset + 2 >= bytes.length) {
            throw new IptcDataException("Attempt to read bytes from outside Iptc data buffer");
        }
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    private Charset processTag(IptcDirectory iptcDirectory, byte[] bytes, int directoryType, int tagType, int offset, int tagByteCount, Charset charset) throws IptcProcessingException {
        block27: {
            int tagIdentifier = tagType | directoryType << 8;
            try {
                switch (tagIdentifier) {
                    case 256: 
                    case 512: {
                        short shortValue = (short)(bytes[offset] << 8 | bytes[offset + 1] & 0xFF);
                        iptcDirectory.setInt(tagIdentifier, shortValue);
                        return null;
                    }
                    case 522: {
                        iptcDirectory.setInt(tagIdentifier, bytes[offset]);
                        return null;
                    }
                    case 542: 
                    case 567: 
                    case 574: {
                        if (tagByteCount >= 8) {
                            String dateStr = new String(bytes, offset, tagByteCount);
                            try {
                                this.year = Integer.parseInt(dateStr.substring(0, 4));
                                this.month = Integer.parseInt(dateStr.substring(4, 6)) - 1;
                                this.day = Integer.parseInt(dateStr.substring(6, 8));
                                iptcDirectory.setDate(tagIdentifier, new GregorianCalendar(this.year, this.month, this.day));
                                return null;
                            }
                            catch (NumberFormatException e) {
                                iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + " Wrong Date: " + dateStr + "  " + e);
                            }
                        }
                    }
                    case 547: 
                    case 572: 
                    case 575: {
                        if (tagByteCount > 4) {
                            String timeStr = new String(bytes, offset, tagByteCount);
                            try {
                                GregorianCalendar c = null;
                                for (SimpleDateFormat sdf : simpleDateFormatter) {
                                    try {
                                        Date d = sdf.parse(timeStr);
                                        c = new GregorianCalendar();
                                        c.setTime(d);
                                        break;
                                    }
                                    catch (ParseException parseException) {
                                    }
                                }
                                if (c != null) {
                                    iptcDirectory.setTime(tagIdentifier, c);
                                } else {
                                    iptcDirectory.setString(tagIdentifier, timeStr);
                                }
                            }
                            catch (Exception e) {
                                iptcDirectory.addError(Tag.getTagTypeInfo(tagIdentifier) + "  Wrong Time: " + timeStr + "  " + e);
                            }
                        }
                        return null;
                    }
                    case 346: {
                        if (tagByteCount == 3 && bytes[offset] == 27 && bytes[offset + 1] == 37 && bytes[offset + 2] == 71) {
                            return charsetUTF8;
                        }
                        return null;
                    }
                }
                String str = tagByteCount < 1 ? "" : new String(bytes, offset, tagByteCount, charset);
                if (iptcDirectory.containsTag(tagIdentifier)) {
                    String[] newStrings;
                    String[] oldStrings;
                    try {
                        oldStrings = iptcDirectory.getStringArray(tagIdentifier);
                    }
                    catch (IptcDataException e) {
                        oldStrings = null;
                    }
                    if (oldStrings == null) {
                        newStrings = new String[1];
                    } else {
                        newStrings = new String[oldStrings.length + 1];
                        for (int i = 0; i < oldStrings.length; ++i) {
                            newStrings[i] = oldStrings[i];
                        }
                    }
                    newStrings[newStrings.length - 1] = str;
                    iptcDirectory.setStringArray(tagIdentifier, newStrings);
                    break block27;
                }
                iptcDirectory.setString(tagIdentifier, str);
            }
            catch (Throwable t) {
                String message = "processTag:: " + Tag.getTagTypeInfo(tagIdentifier) + " byteslength:" + bytes.length + " offset: " + offset + " tagbytecount: " + tagByteCount + " charset: " + charset;
                throw new IptcProcessingException(message, t);
            }
        }
        return charset;
    }

    public static Map<String, String> getIptcSimpleMap(byte[] bytes) {
        Map<String, String> result = null;
        IptcDirectory dir = IptcDirectoryReader.getIptcDirectory(bytes);
        if (dir != null) {
            result = dir.getIptcSimpleMap();
        }
        return result;
    }

    public static Map<Pair<String, String>, String> getIptcMap(byte[] bytes) {
        Map<Pair<String, String>, String> result = null;
        IptcDirectory dir = IptcDirectoryReader.getIptcDirectory(bytes);
        if (dir != null) {
            result = dir.getIptcMap();
        }
        return result;
    }

    public static List<Pair<String, String>> getIptcSortedList(byte[] bytes) {
        List<Pair<String, String>> result = null;
        IptcDirectory dir = IptcDirectoryReader.getIptcDirectory(bytes);
        if (dir != null) {
            result = dir.getIptcSortedList();
        }
        return result;
    }

    static {
        for (int i = 0; i < timePatterns.length; ++i) {
            IptcDirectoryReader.simpleDateFormatter[i] = new SimpleDateFormat(timePatterns[i]);
        }
        charsetISO8859_1 = Charset.forName("ISO-8859-1");
        charsetUTF8 = Charset.forName("UTF-8");
    }
}

