/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.iptc;

import com.neptunelabs.imagereader.iptc.IptcDirectory;
import java.util.HashMap;
import java.util.Map;

public class IptcSimpleMapReader {
    public final HashMap<String, String> getIptcMap(byte[] bytes) {
        Map<Integer, String> iptcTagMap = this.extractIPTCTags(bytes);
        HashMap<String, String> newIptcTagMap = new HashMap<String, String>();
        Integer key2 = null;
        IptcDirectory iptcDirectory = new IptcDirectory();
        for (Integer key2 : iptcTagMap.keySet()) {
            if (iptcDirectory.knowsTag(key2)) {
                newIptcTagMap.put(iptcDirectory.getTagName(key2), iptcTagMap.get(key2));
                continue;
            }
            newIptcTagMap.put("UNKNOWN [" + key2 + "]", iptcTagMap.get(key2));
        }
        return newIptcTagMap;
    }

    public final Map<Integer, String> extractIPTCTags(byte[] bytes) {
        int offset;
        HashMap<Integer, String> iptcTagMap = new HashMap<Integer, String>();
        if (bytes == null) {
            return null;
        }
        try {
            for (offset = 0; offset < bytes.length - 1 && this.get2Byte(bytes, offset) != 7170; ++offset) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte directoryType = 0;
        int tagType = 0;
        int tagByteCount = 0;
        while (offset < bytes.length) {
            if (bytes[offset] != 28) {
                ++offset;
                continue;
            }
            if (offset + 5 >= bytes.length) break;
            ++offset;
            try {
                directoryType = bytes[offset++];
                tagType = bytes[offset++] & 0xFF;
                tagByteCount = this.get2Byte(bytes, offset);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isIptcStartTag(bytes, offset + tagByteCount)) {
                offset += 2;
            }
            if (offset + tagByteCount > bytes.length) {
                tagByteCount = bytes.length - offset;
            }
            this.processTag(iptcTagMap, bytes, directoryType, tagType, offset, tagByteCount);
            offset += tagByteCount;
        }
        return iptcTagMap;
    }

    private final boolean isIptcStartTag(byte[] bytes, int offset) {
        return offset + 1 < bytes.length && bytes[offset] == 28 && bytes[offset + 1] == 2;
    }

    private final int get2Byte(byte[] bytes, int offset) throws Exception {
        if (offset >= bytes.length) {
            throw new Exception("Attempt to read  from outside IPTC data buffer  OFFSET:" + offset + "  BYTES: " + bytes.length);
        }
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    private void processTag(Map<Integer, String> iptcTagMap, byte[] bytes, int directoryType, int tagType, int offset, int tagByteCount) {
        Integer tagIdentifier = new Integer(tagType | directoryType << 8);
        String string = null;
        string = tagByteCount < 1 ? "" : new String(bytes, offset, tagByteCount);
        if (iptcTagMap.containsKey(tagIdentifier)) {
            string = iptcTagMap.get(tagIdentifier) + " " + string;
        }
        iptcTagMap.put(tagIdentifier, string);
    }
}

