/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.iptc;

import com.neptunelabs.imagereader.iptc.Directory;
import com.neptunelabs.imagereader.iptc.exception.IptcDataException;

public class Tag {
    private final int _tagType;
    private final Directory _directory;

    public Tag(int tagType, Directory directory) {
        this._tagType = tagType;
        this._directory = directory;
    }

    public final int getTagType() {
        return this._tagType;
    }

    public final String getTagTypeHex() {
        return Tag.getTagTypeHex(this._tagType);
    }

    public static final String getTagTypeHex(int tagType) {
        String hex = Integer.toHexString(tagType);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "0x" + hex;
    }

    public final String getDescription() throws IptcDataException {
        return this._directory.getDescription(this._tagType);
    }

    public final String getTagName() {
        String tagName = this._directory.getTagName(this._tagType);
        return tagName != null ? tagName : Tag.getTagID(this._tagType);
    }

    public final String getDirectoryName() {
        return this._directory.getName();
    }

    public final String toString() {
        String description;
        try {
            description = this.getDescription();
        }
        catch (IptcDataException e) {
            description = this._directory.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this._directory.getName() + "]   " + this.getTagTypeHex() + "(" + (this.getTagType() >> 8) + ":" + (this.getTagType() & 0xFF) + ") \t" + String.format("%20s :: %s", this.getTagName(), description);
    }

    public static final String getTagTypeInfo(int tagType) {
        return tagType + ":" + Tag.getTagTypeHex(tagType) + "(" + Tag.getTagID(tagType) + ")";
    }

    public static final String getTagID(int tagType) {
        return String.format("%d:%03d", tagType >> 8, tagType & 0xFF);
    }
}

