/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.helpers.HexDumpEncoder;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.Rational;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class FSIMetaData
implements CacheableData<FSIMetaData> {
    public int imageCount = 0;
    public PathCached sourceFile = null;
    public String source = null;
    public ImageFormat sourceFormat = null;
    public long filesize = -1L;
    public long lastModified = -1L;
    public boolean hasAlpha = false;
    public int extraSamples = 0;
    public int alphaBand = -1;
    public boolean alphaBandPremultiplied = false;
    public boolean sawAdobeMarker = false;
    public Histogram histogram = null;
    public ByteOrder byteOrder;
    public ColorType colorType = ColorType.UNKNOWN;
    private final TreeSet<FSISubImageMetaData> images = new TreeSet<FSISubImageMetaData>(new FSISubImageMetaDataComparator());
    private FSISubImageMetaData lastImage = null;

    public FSIMetaData(PathCached sourceFile) {
        if (sourceFile != null) {
            this.sourceFile = sourceFile;
            this.source = sourceFile.getAbsolutePath().toString();
        }
    }

    public FSISubImageMetaData createImage(int index) {
        return new FSISubImageMetaData(index);
    }

    public void addImage(FSISubImageMetaData image) {
        ++this.imageCount;
        this.images.add(image);
        this.lastImage = this.images.last();
    }

    public FSISubImageMetaData getSmallestImage() throws NoSuchElementException {
        return this.images.first();
    }

    public FSISubImageMetaData getLargestImage() throws NoSuchElementException {
        return this.images.last();
    }

    public Iterator<FSISubImageMetaData> getImagesIterator() {
        return this.images.descendingIterator();
    }

    public FSISubImageMetaData getLowerImage(FSISubImageMetaData image) {
        return this.images.lower(image);
    }

    public FSISubImageMetaData getImage() {
        return this.lastImage;
    }

    public int getSamplesPerPixel() {
        return this.lastImage.samplesperpixel;
    }

    public ICCProfileWrap getICC() {
        if (this.lastImage != null) {
            FSISubImageMetaData image2 = this.lastImage;
            if (image2.icc != null) {
                return image2.icc;
            }
            for (FSISubImageMetaData image2 : this.images) {
                if (image2.icc == null) continue;
                return image2.icc;
            }
        }
        return null;
    }

    public byte[] getIPTC() {
        if (this.lastImage != null) {
            FSISubImageMetaData image2 = this.lastImage;
            if (image2.iptc != null) {
                return image2.iptc;
            }
            for (FSISubImageMetaData image2 : this.images) {
                if (image2.iptc == null) continue;
                return image2.iptc;
            }
        }
        return null;
    }

    public byte[] getExif() {
        if (this.lastImage != null) {
            FSISubImageMetaData image2 = this.lastImage;
            if (image2.exif != null) {
                return image2.exif;
            }
            for (FSISubImageMetaData image2 : this.images) {
                if (image2.exif == null) continue;
                return image2.exif;
            }
        }
        return null;
    }

    public byte[] getXMP() {
        if (this.lastImage != null) {
            FSISubImageMetaData image2 = this.lastImage;
            if (image2.xmp != null) {
                return image2.xmp;
            }
            for (FSISubImageMetaData image2 : this.images) {
                if (image2.xmp == null) continue;
                return image2.xmp;
            }
        }
        return null;
    }

    public byte[] getSelections() {
        if (this.lastImage != null) {
            FSISubImageMetaData image2 = this.lastImage;
            if (image2.selections != null) {
                return image2.selections;
            }
            for (FSISubImageMetaData image2 : this.images) {
                if (image2.selections == null) continue;
                return image2.selections;
            }
        }
        return null;
    }

    public int[] getAlphaTypes() {
        int[] result = null;
        if (this.lastImage != null && this.lastImage.extrasamples != null && this.lastImage.extrasamples.length > 0) {
            result = new int[this.lastImage.extrasamples.length];
            for (int i = 0; i < this.lastImage.extrasamples.length; ++i) {
                result[i] = this.lastImage.extrasamples[i];
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public byte[] getAlphaNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getWidth() {
        if (this.lastImage != null) {
            return this.lastImage.width;
        }
        return -1;
    }

    public int getHeight() {
        if (this.lastImage != null) {
            return this.lastImage.height;
        }
        return -1;
    }

    public int getTileWidth() {
        if (this.lastImage != null) {
            return this.lastImage.tileWidth;
        }
        return -1;
    }

    public int getTileHeight() {
        if (this.lastImage != null) {
            return this.lastImage.tileHeight;
        }
        return -1;
    }

    public int getWidth(int levelIndex) {
        for (FSISubImageMetaData image : this.images) {
            if (image.index != levelIndex) continue;
            return image.width;
        }
        return this.lastImage.width;
    }

    public int getHeight(int levelIndex) {
        for (FSISubImageMetaData image : this.images) {
            if (image.index != levelIndex) continue;
            return image.height;
        }
        return this.lastImage.height;
    }

    public boolean isTiled(int levelIndex) {
        for (FSISubImageMetaData image : this.images) {
            if (image.index != levelIndex) continue;
            return image.isTiled;
        }
        return this.lastImage.isTiled;
    }

    public int getTileWidth(int levelIndex) {
        for (FSISubImageMetaData image : this.images) {
            if (image.index != levelIndex) continue;
            if (image.tileWidth == -1) {
                return image.width;
            }
            return image.tileWidth;
        }
        if (this.lastImage.tileWidth == -1) {
            return this.lastImage.width;
        }
        return this.lastImage.tileWidth;
    }

    public int getTileHeight(int levelIndex) {
        for (FSISubImageMetaData image : this.images) {
            if (image.index != levelIndex) continue;
            if (image.tileHeight == -1) {
                return image.height;
            }
            return image.tileHeight;
        }
        if (this.lastImage.tileHeight == -1) {
            return this.lastImage.height;
        }
        return this.lastImage.tileHeight;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("imageCount: " + this.imageCount);
        sb.append(", source: " + this.source);
        sb.append(", filesize: " + this.filesize);
        sb.append(", lastModified: " + this.lastModified);
        sb.append(", hasAlpha: " + this.hasAlpha);
        sb.append(", sawAdobeMarker: " + this.sawAdobeMarker);
        sb.append(", histogram: " + (this.histogram != null));
        sb.append(", byteOrder: " + this.byteOrder);
        sb.append(", colorType: " + (Object)((Object)this.colorType));
        sb.append(", getICC: " + this.getICC());
        sb.append(", last dim: " + this.getWidth() + "x" + this.getHeight());
        sb.append("\n");
        for (int i = 0; i < this.imageCount; ++i) {
            sb.append("Index: " + i + " ");
            sb.append(", Dim: " + this.getWidth(i) + "x" + this.getHeight(i));
            sb.append(", TileSize: " + this.getTileWidth(i) + "x" + this.getTileHeight(i));
            sb.append("\n");
        }
        if (this.getIPTC() != null) {
            HexDumpEncoder hde = new HexDumpEncoder();
            sb.append("IPTC:\n");
            sb.append("---------------------\n");
            sb.append(hde.encode(this.getIPTC()));
            sb.append('\n');
            sb.append('\n');
        }
        if (this.getExif() != null) {
            HexDumpEncoder hde = new HexDumpEncoder();
            sb.append("EXIF:\n");
            sb.append("---------------------\n");
            sb.append(hde.encode(this.getExif()));
            sb.append('\n');
            sb.append('\n');
        }
        if (this.getXMP() != null) {
            HexDumpEncoder hde = new HexDumpEncoder();
            sb.append("XMP:\n");
            sb.append("---------------------\n");
            sb.append(hde.encode(this.getXMP()));
            sb.append('\n');
            sb.append('\n');
        }
        if (this.getSelections() != null) {
            HexDumpEncoder hde = new HexDumpEncoder();
            sb.append("Selection:\n");
            sb.append("---------------------\n");
            sb.append(hde.encode(this.getSelections()));
            sb.append('\n');
            sb.append('\n');
        }
        if (this.getICC() != null) {
            HexDumpEncoder hde = new HexDumpEncoder();
            sb.append("ICC Profile:\n");
            sb.append("---------------------\n");
            sb.append(hde.encode(this.getICC().getBytes()));
            sb.append('\n');
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public CacheableData<FSIMetaData> copy() {
        throw new UnsupportedOperationException();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final FSIMetaData unpack(byte[] data) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(data, ByteOrder.nativeOrder());
        try {
            byte byteOrderByte;
            String sourceName = null;
            int len = bb.getInt();
            if (len > 0) {
                byte[] dst = new byte[len];
                bb.get(dst);
                sourceName = new String(dst);
            }
            FSIMetaData metaData = new FSIMetaData(new PathCached(Paths.get(sourceName, new String[0])));
            metaData.filesize = bb.getLong();
            metaData.lastModified = bb.getLong();
            metaData.hasAlpha = bb.get() == 1;
            metaData.sawAdobeMarker = bb.get() == 1;
            metaData.extraSamples = bb.getInt();
            metaData.alphaBand = bb.getInt();
            metaData.alphaBandPremultiplied = bb.get() == 1;
            len = bb.getInt();
            if (len > 0) {
                byte[] dst = new byte[len];
                bb.get(dst);
                metaData.histogram = Histogram.unserialize(dst);
            }
            ByteOrder byteOrder = (byteOrderByte = bb.get()) == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            metaData.byteOrder = byteOrder;
            metaData.colorType = ColorType.values()[bb.get()];
            int images = bb.getInt();
            for (int i = 0; i < images; ++i) {
                byte[] dst;
                int index = bb.getInt();
                FSISubImageMetaData image = metaData.createImage(index);
                image.width = bb.getInt();
                image.height = bb.getInt();
                image.tileWidth = bb.getInt();
                image.tileHeight = bb.getInt();
                image.pixelAspectRatio = bb.getFloat();
                image.isTiled = bb.get() == 1;
                len = bb.getInt();
                if (len > 0) {
                    dst = new byte[len];
                    bb.get(dst);
                    image.icc = new ICCProfileWrap(dst);
                }
                if ((len = bb.getInt()) > 0) {
                    image.iptc = new byte[len];
                    bb.get(image.iptc);
                }
                if ((len = bb.getInt()) > 0) {
                    image.exif = new byte[len];
                    bb.get(image.exif);
                }
                if ((len = bb.getInt()) > 0) {
                    image.xmp = new byte[len];
                    bb.get(image.xmp);
                }
                if ((len = bb.getInt()) > 0) {
                    image.selections = new byte[len];
                    bb.get(image.selections);
                }
                if ((len = bb.getInt()) > 0) {
                    image.alphaNames = new String[len];
                    for (int c = 0; c < len; ++c) {
                        byte[] dst2 = new byte[len];
                        bb.get(dst2);
                        image.alphaNames[c] = new String(dst2);
                    }
                }
                if ((len = bb.getInt()) > 0) {
                    dst = new byte[len];
                    bb.get(dst);
                    image.software = new String(dst);
                }
                image.bitspersample = bb.getInt();
                image.compression = bb.getInt();
                image.planarconfiguration = bb.getInt();
                image.photometric = bb.getInt();
                image.samplesperpixel = bb.getInt();
                len = bb.getInt();
                if (len > 0) {
                    image.extrasamples = new int[len];
                    for (int p = 0; p < len; ++p) {
                        image.extrasamples[p] = bb.getInt();
                    }
                }
                long num = bb.getLong();
                long den = bb.getLong();
                if (num != 0L && den != 0L) {
                    image.xResolution = new Rational(num, den);
                }
                num = bb.getLong();
                den = bb.getLong();
                if (num != 0L && den != 0L) {
                    image.yResolution = new Rational(num, den);
                }
                image.unitResolution = bb.getInt();
                image.orientation = bb.getInt();
                metaData.addImage(image);
            }
            return metaData;
        }
        catch (BufferUnderflowException e) {
            return null;
        }
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.METADATA;
    }

    private class FSISubImageMetaDataComparator<E>
    implements Comparator<FSISubImageMetaData> {
        @Override
        public int compare(FSISubImageMetaData o1, FSISubImageMetaData o2) {
            if (o1.width > o2.width || o1.height > o2.height) {
                return 1;
            }
            if (o1.width < o2.width || o1.height < o2.height) {
                return -1;
            }
            return 0;
        }
    }
}

