/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.NoSuchFileException;

public abstract class MetaReaderAbstract {
    int errorCode = 0;
    public static final int ERROR_CODE_NOT_FOUND = 1;
    public static final int ERROR_CODE_IO_EXCEPTION = 2;
    public static final int ERROR_CODE_INVALID_FORMAT = 4;
    public static final int ERROR_CODE_ZEROBYTE = 8;
    public static final int ERROR_CODE_UNKNOWN_COMPRESSION = 16;
    final FSILogger logger;
    final ImageFormat format;
    FSIMetaData metaData;
    final byte[] IPTCMagic = new byte[]{73, 80, 84, 67};
    final byte[] EXIF_MAGIC = new byte[]{69, 120, 105, 102, 0};
    final byte[] IPTC_MAGIC = new byte[]{28, 2};
    final byte[] PS8BIM_MAGIC = new byte[]{56, 66, 73, 77};
    final byte[] PR8BIM_MAGIC = new byte[]{80, 104, 111, 116, 111, 115, 104, 111, 112, 32, 51, 46, 48};
    byte[] XMP_MAGIC_XAP;
    byte[] XMP_MAGIC_EXT;
    final byte[] ICC_MAGIC = new byte[]{73, 67, 67, 95, 80, 82, 79, 70, 73, 76, 69};

    public MetaReaderAbstract(FSILogger logger, ImageFormat format) {
        this.logger = logger;
        this.format = format;
        try {
            this.XMP_MAGIC_XAP = new String("http://ns.adobe.com/xap/1.0/\u0000").getBytes("ASCII");
            this.XMP_MAGIC_EXT = new String("http://ns.adobe.com/xmp/extension/\u0000").getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public abstract void scanImage(PathCached var1, boolean var2) throws NoSuchFileException, IOException;

    public FSIMetaData getMetaData() {
        if (this.metaData != null && this.metaData.sourceFormat == null && this.format != null) {
            this.metaData.sourceFormat = this.format;
        }
        return this.metaData;
    }

    public int getErrorCode() {
        if (this.metaData.imageCount == 0) {
            this.errorCode |= 4;
        }
        return this.errorCode;
    }

    public boolean hasError() {
        return this.getErrorCode() != 0;
    }

    int isXMPBase(byte[] data) {
        int result = -1;
        for (int dp = 0; dp < data.length - this.XMP_MAGIC_XAP.length; ++dp) {
            if (data[dp] == this.XMP_MAGIC_XAP[0]) {
                result = this.XMP_MAGIC_XAP.length;
                int p = dp;
                int c = 0;
                while (p < dp + this.XMP_MAGIC_XAP.length) {
                    if (data[p] != this.XMP_MAGIC_XAP[c]) {
                        result = -1;
                        break;
                    }
                    ++p;
                    ++c;
                }
            }
            if (result != -1) break;
        }
        return result;
    }

    int isXMPExtension(byte[] data) {
        int result = -1;
        for (int dp = 0; dp < data.length - this.XMP_MAGIC_EXT.length; ++dp) {
            if (data[dp] == this.XMP_MAGIC_EXT[0]) {
                result = this.XMP_MAGIC_EXT.length + 32 + 4 + 4;
                int p = dp;
                int c = 0;
                while (p < dp + this.XMP_MAGIC_EXT.length) {
                    if (data[p] != this.XMP_MAGIC_EXT[c]) {
                        result = -1;
                        break;
                    }
                    ++p;
                    ++c;
                }
            }
            if (result != -1) break;
        }
        return result;
    }

    int isEXIF(byte[] data) {
        int result = -1;
        for (int dp = 0; dp < data.length - this.EXIF_MAGIC.length; ++dp) {
            if (data[dp] == this.EXIF_MAGIC[0]) {
                result = this.EXIF_MAGIC.length + 1;
                int p = dp;
                int c = 0;
                while (p < dp + this.EXIF_MAGIC.length) {
                    if (data[p] != this.EXIF_MAGIC[c]) {
                        result = -1;
                        break;
                    }
                    ++p;
                    ++c;
                }
            }
            if (result != -1) break;
        }
        return result;
    }

    int isIPTC(byte[] data) {
        int result = -1;
        for (int dp = 0; dp < data.length - this.IPTC_MAGIC.length; ++dp) {
            if (data[dp] == this.IPTC_MAGIC[0]) {
                result = this.IPTC_MAGIC.length + 1;
                int p = dp;
                int c = 0;
                while (p < dp + this.IPTC_MAGIC.length) {
                    if (data[p] != this.IPTC_MAGIC[c]) {
                        result = -1;
                        break;
                    }
                    ++p;
                    ++c;
                }
            }
            if (result != -1) break;
        }
        return result;
    }

    int is8BIM(byte[] data) {
        int result = -1;
        for (int dp = 0; dp < data.length - this.PR8BIM_MAGIC.length; ++dp) {
            if (data[dp] == this.PR8BIM_MAGIC[0]) {
                result = this.PR8BIM_MAGIC.length + 1;
                int p = dp;
                int c = 0;
                while (p < dp + this.PR8BIM_MAGIC.length) {
                    if (data[p] != this.PR8BIM_MAGIC[c]) {
                        result = -1;
                        break;
                    }
                    ++p;
                    ++c;
                }
            }
            if (result != -1) break;
        }
        if (result == -1) {
            for (int p = 0; p < this.PS8BIM_MAGIC.length; ++p) {
                if (data[p] != this.PS8BIM_MAGIC[p]) {
                    result = -1;
                    break;
                }
                result = 0;
            }
        }
        return result;
    }

    boolean isJPEGICC(byte[] data) {
        boolean result = false;
        if (data[0] == this.ICC_MAGIC[0]) {
            result = true;
            int p = 0;
            int c = 0;
            while (p < this.ICC_MAGIC.length) {
                if (data[p] != this.ICC_MAGIC[c]) {
                    result = false;
                    break;
                }
                ++p;
                ++c;
            }
        }
        return result;
    }

    int validateMetaData(FSISubImageMetaData imageMetaData) {
        int result = 0;
        if (imageMetaData.width <= 0 || imageMetaData.height <= 0) {
            result |= 4;
        }
        return result;
    }
}

