/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagereader.metareader;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;

public final class MetaReaderBMP
extends MetaReaderAbstract {
    public static final int VERSION = 256;
    private ReaderAbstract reader = null;

    public MetaReaderBMP(FSILogger fsilogger, ImageFormat format) {
        super(fsilogger, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached inputFile, boolean deep) throws IOException {
        block26: {
            this.metaData = new FSIMetaData(inputFile);
            try {
                this.reader = new ReaderChannel(inputFile.getPath(), StandardOpenOption.READ);
                this.reader.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            }
            catch (NoSuchFileException e) {
                this.logger.logException(e, 3801, this.metaData.source);
                this.errorCode |= 1;
            }
            catch (IOException e) {
                this.logger.logException(e, 3802, this.metaData.source);
                this.errorCode |= 2;
            }
            finally {
                if (this.errorCode != 0) {
                    this.close();
                }
            }
            try {
                byte[] header = new byte[2];
                this.reader.read(header);
                if (header[0] != 66 || header[1] != 77) {
                    this.errorCode |= 4;
                }
                if (this.errorCode != 0) break block26;
                FSISubImageMetaData metaDataImage = this.metaData.createImage(0);
                try {
                    this.reader.skip(12L);
                    int headerSize = this.reader.readInt();
                    if (headerSize == 12) {
                        metaDataImage.width = this.reader.readShort();
                        metaDataImage.height = Math.abs(this.reader.readShort());
                    } else {
                        metaDataImage.width = this.reader.readInt();
                        metaDataImage.height = Math.abs(this.reader.readInt());
                    }
                    this.reader.skip(2L);
                    short bits = this.reader.readShort();
                    this.metaData.colorType = this.getColorspace(bits);
                    metaDataImage.bitspersample = this.getBitsPerSamples(bits);
                    metaDataImage.samplesperpixel = this.getSamplesPerPixel(bits);
                    this.errorCode |= this.validateMetaData(metaDataImage);
                    if (this.errorCode == 0) {
                        this.metaData.addImage(metaDataImage);
                    }
                }
                catch (IOException e) {
                    this.errorCode |= 4;
                }
            }
            catch (Error e) {
                this.logger.logError(e, 3850, this.metaData.source);
                this.errorCode |= 4;
            }
            catch (NoSuchFileException e) {
                this.logger.logException(e, 3801, this.metaData.source);
                this.errorCode |= 1;
            }
            catch (IOException e) {
                this.logger.logException(e, 3850, this.metaData.source);
                this.errorCode |= 2;
            }
            catch (Exception e) {
                this.logger.logException(e, 3850, this.metaData.source);
                this.errorCode |= 4;
            }
            finally {
                this.close();
            }
        }
    }

    private void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            this.logger.logException(e, 3811, this.metaData.source, e.getLocalizedMessage());
            this.errorCode |= 2;
        }
    }

    private ColorType getColorspace(int image_colordepth) {
        ColorType cp = ColorType.UNKNOWN;
        if (image_colordepth == 1) {
            cp = ColorType.MONOCHROME;
        } else if (image_colordepth == 4 || image_colordepth == 8) {
            cp = ColorType.INDEXED;
        } else if (image_colordepth == 15) {
            cp = ColorType.RGB15;
        } else if (image_colordepth == 16) {
            cp = ColorType.RGB16;
        } else if (image_colordepth == 24 || image_colordepth == 32) {
            cp = ColorType.RGB24;
        }
        return cp;
    }

    private int getBitsPerSamples(int image_colordepth) {
        int ret = 1;
        switch (image_colordepth) {
            case 1: {
                ret = 1;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                ret = -1;
                break;
            }
            case 24: 
            case 32: {
                ret = 8;
            }
        }
        return ret;
    }

    private int getSamplesPerPixel(int image_colordepth) {
        int ret = 1;
        switch (image_colordepth) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                ret = -1;
                break;
            }
            case 24: 
            case 32: {
                ret = 3;
            }
        }
        return ret;
    }
}

